/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.core.ArrayBasedPrimitive;
import org.neo4j.kernel.impl.core.FirstRelationshipIds;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipIterator;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.command.RelationshipHoles;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;
import org.neo4j.kernel.impl.util.RelationshipFilter;

public class NodeImpl
extends ArrayBasedPrimitive {
    private static final RelIdArray[] NO_RELATIONSHIPS = new RelIdArray[0];
    static final int[] NO_RELATIONSHIP_TYPES = new int[0];
    private volatile RelIdArray[] relationships;
    private volatile int[] labels;
    private volatile RelationshipLoadingPosition relChainPosition;
    private final long id;
    private static final Comparator<RelIdArray> RELATIONSHIP_TYPE_COMPARATOR_FOR_SORTING = new Comparator<RelIdArray>(){

        @Override
        public int compare(RelIdArray o1, RelIdArray o2) {
            return o1.getType() - o2.getType();
        }
    };
    private static final Comparator RELATIONSHIP_TYPE_COMPARATOR_FOR_BINARY_SEARCH = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((RelIdArray)o1).getType() - (Integer)o2;
        }
    };

    public NodeImpl(long id) {
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        int size = super.sizeOfObjectInBytesIncludingOverhead() + 8 + 8 + 8 + 8;
        if (this.relationships != null && this.relationships.length > 0) {
            size = SizeOfs.withArrayOverheadIncludingReferences(size, this.relationships.length);
            for (RelIdArray array : this.relationships) {
                size += array.sizeOfObjectInBytesIncludingOverhead();
            }
        }
        if (this.labels != null && this.labels.length > 0) {
            size += SizeOfs.sizeOfArray(this.labels);
        }
        return size;
    }

    @Override
    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof NodeImpl && ((NodeImpl)obj).getId() == this.getId();
    }

    PrimitiveLongIterator getAllRelationships(RelationshipLoader relationshipLoader, RelIdArray.DirectionWrapper direction, CacheUpdateListener cacheUpdateListener) {
        this.ensureRelationshipMapNotNull(relationshipLoader, direction, NO_RELATIONSHIP_TYPES, cacheUpdateListener);
        boolean hasMore = this.hasMoreRelationshipsToLoad(direction, NO_RELATIONSHIP_TYPES);
        int numberOfRelIdArrays = this.relationships.length;
        RelIdIterator[] result = new RelIdIterator[numberOfRelIdArrays];
        for (int i = 0; i < numberOfRelIdArrays; ++i) {
            RelIdIterator iterator;
            RelIdArray src = this.relationships[i];
            result[i] = iterator = src.iterator(direction);
        }
        if (result.length == 0) {
            return PrimitiveLongCollections.emptyIterator();
        }
        return new RelationshipIterator(result, this, direction, NO_RELATIONSHIP_TYPES, relationshipLoader, hasMore, true, cacheUpdateListener);
    }

    PrimitiveLongIterator getAllRelationshipsOfType(RelationshipLoader relationshipLoader, RelIdArray.DirectionWrapper direction, int[] types, CacheUpdateListener cacheUpdateListener) {
        this.ensureRelationshipMapNotNull(relationshipLoader, direction, types, cacheUpdateListener);
        boolean hasMore = this.hasMoreRelationshipsToLoad(direction, types);
        RelIdIterator[] result = new RelIdIterator[types.length];
        int actualLength = 0;
        for (int typeId : types) {
            if (typeId == -1 || this.typeIn(typeId, actualLength, result)) continue;
            result[actualLength++] = this.getRelationshipsIterator(direction, typeId);
        }
        if (actualLength < result.length) {
            RelIdIterator[] compacted = new RelIdIterator[actualLength];
            System.arraycopy(result, 0, compacted, 0, actualLength);
            result = compacted;
        }
        if (result.length == 0) {
            return PrimitiveLongCollections.emptyIterator();
        }
        return new RelationshipIterator(result, this, direction, types, relationshipLoader, hasMore, false, cacheUpdateListener);
    }

    private boolean typeIn(int typeId, int actualLength, RelIdIterator[] result) {
        for (int i = 0; i < actualLength; ++i) {
            if (result[i].getType() != typeId) continue;
            return true;
        }
        return false;
    }

    private RelIdIterator getRelationshipsIterator(RelIdArray.DirectionWrapper direction, int type) {
        RelIdArray src = this.getRelIdArray(type);
        return src != null ? src.iterator(direction) : RelIdArray.empty(type).iterator(direction);
    }

    public PrimitiveLongIterator getRelationships(RelationshipLoader relationshipLoader, Direction dir, CacheUpdateListener cacheUpdateListener) {
        return this.getAllRelationships(relationshipLoader, RelIdArray.wrap(dir), cacheUpdateListener);
    }

    public PrimitiveLongIterator getRelationships(RelationshipLoader relationshipLoader, Direction direction, int[] types, CacheUpdateListener cacheUpdateListener) {
        return this.getAllRelationshipsOfType(relationshipLoader, RelIdArray.wrap(direction), types, cacheUpdateListener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.getId();
    }

    private void ensureRelationshipMapNotNull(RelationshipLoader relationshipLoader, RelIdArray.DirectionWrapper direction, int[] types, CacheUpdateListener cacheUpdateListener) {
        if (this.relationships == null || this.relationships.length == 0 && this.relChainPosition.hasMore(direction, types)) {
            this.loadInitialRelationships(relationshipLoader, direction, types, cacheUpdateListener);
        }
    }

    private void ensureRelationshipMapNotNull(RelationshipLoader relationshipLoader, CacheUpdateListener cacheUpdateListener) {
        this.ensureRelationshipMapNotNull(relationshipLoader, RelIdArray.DirectionWrapper.BOTH, NO_RELATIONSHIP_TYPES, cacheUpdateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitialRelationships(RelationshipLoader relationshipLoader, RelIdArray.DirectionWrapper direction, int[] types, CacheUpdateListener cacheUpdateListener) {
        Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, RelationshipLoadingPosition> rels = null;
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (this.relationships == null || this.relationships.length == 0 && this.relChainPosition.hasMore(direction, types)) {
                try {
                    this.relChainPosition = relationshipLoader.getRelationshipChainPosition(this.getId());
                }
                catch (InvalidRecordException e) {
                    throw new NotFoundException("Node[" + this.id + "]" + " concurrently deleted while loading its relationships?", e);
                }
                ArrayMap<Integer, RelIdArray> tmpRelMap = new ArrayMap<Integer, RelIdArray>();
                rels = this.getMoreRelationships(relationshipLoader, tmpRelMap, direction, types);
                this.relationships = this.toRelIdArray(tmpRelMap);
                this.relChainPosition = rels == null ? RelationshipLoadingPosition.EMPTY : rels.third();
                this.moreRelationshipsLoaded();
                cacheUpdateListener.newSize(this, this.sizeOfObjectInBytesIncludingOverhead());
            }
        }
        if (rels != null && ((List)rels.second()).size() > 0) {
            relationshipLoader.putAllInRelCache((Collection)rels.second());
        }
    }

    private RelIdArray[] toRelIdArray(ArrayMap<Integer, RelIdArray> tmpRelMap) {
        RelIdArray[] result = new RelIdArray[tmpRelMap.size()];
        int i = 0;
        for (RelIdArray array : tmpRelMap.values()) {
            result[i++] = array;
        }
        NodeImpl.sort(result);
        return result;
    }

    private static void sort(RelIdArray[] array) {
        Arrays.sort(array, RELATIONSHIP_TYPE_COMPARATOR_FOR_SORTING);
    }

    private Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, RelationshipLoadingPosition> getMoreRelationships(RelationshipLoader relationshipLoader, ArrayMap<Integer, RelIdArray> tmpRelMap, RelIdArray.DirectionWrapper direction, int[] types) {
        if (!this.hasMoreRelationshipsToLoad(direction, types)) {
            return Triplet.of(null, Collections.emptyList(), this.relChainPosition);
        }
        Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, RelationshipLoadingPosition> rels = this.loadMoreRelationships(relationshipLoader, direction, types);
        ArrayMap<Integer, RelIdArray> addMap = rels.first();
        if (addMap.size() == 0) {
            return rels;
        }
        for (Integer type : addMap.keySet()) {
            RelIdArray addRels = addMap.get(type);
            RelIdArray srcRels = tmpRelMap.get(type);
            if (srcRels == null) {
                tmpRelMap.put(type, addRels);
                continue;
            }
            RelIdArray newSrcRels = srcRels.addAll(addRels);
            if (newSrcRels == srcRels) continue;
            tmpRelMap.put(type, newSrcRels);
        }
        return rels;
    }

    protected boolean hasMoreRelationshipsToLoad() {
        return this.relChainPosition != null && this.relChainPosition.hasMore(RelIdArray.DirectionWrapper.BOTH, NO_RELATIONSHIP_TYPES);
    }

    boolean hasMoreRelationshipsToLoad(RelIdArray.DirectionWrapper direction, int[] types) {
        return this.relChainPosition != null && this.relChainPosition.hasMore(direction, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoadStatus getMoreRelationships(RelationshipLoader relationshipLoader, RelIdArray.DirectionWrapper direction, int[] types, CacheUpdateListener cacheUpdateListener) {
        boolean more;
        Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, RelationshipLoadingPosition> rels;
        if (!this.hasMoreRelationshipsToLoad(direction, types)) {
            return LoadStatus.NOTHING;
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (!this.hasMoreRelationshipsToLoad(direction, types)) {
                return LoadStatus.NOTHING;
            }
            rels = this.loadMoreRelationships(relationshipLoader, direction, types);
            ArrayMap<Integer, RelIdArray> addMap = rels.first();
            if (addMap.size() == 0) {
                return LoadStatus.NOTHING;
            }
            for (int type : addMap.keySet()) {
                RelIdArray addRels = addMap.get(type);
                RelIdArray srcRels = this.getRelIdArray(type);
                if (srcRels == null) {
                    this.putRelIdArray(addRels);
                    continue;
                }
                RelIdArray newSrcRels = srcRels.addAll(addRels);
                if (newSrcRels == srcRels) continue;
                this.putRelIdArray(newSrcRels);
            }
            this.relChainPosition = rels.third();
            this.moreRelationshipsLoaded();
            more = this.hasMoreRelationshipsToLoad(direction, types);
            cacheUpdateListener.newSize(this, this.sizeOfObjectInBytesIncludingOverhead());
        }
        relationshipLoader.putAllInRelCache((Collection<RelationshipImpl>)rels.second());
        return more ? LoadStatus.LOADED_MORE : LoadStatus.LOADED_END;
    }

    private Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, RelationshipLoadingPosition> loadMoreRelationships(RelationshipLoader relationshipLoader, RelIdArray.DirectionWrapper direction, int[] types) {
        try {
            return relationshipLoader.getMoreRelationships(this, direction, types);
        }
        catch (InvalidRecordException e) {
            throw new NotFoundException("Unable to load one or more relationships from Node[" + this.id + "]" + ". This usually happens when relationships are deleted by someone else just as we are about to " + "load them. Please try again.", e);
        }
    }

    private RelIdArray getRelIdArray(int type) {
        RelIdArray[] localRelationships = this.relationships;
        int index = Arrays.binarySearch(localRelationships, type, RELATIONSHIP_TYPE_COMPARATOR_FOR_BINARY_SEARCH);
        return index < 0 ? null : localRelationships[index];
    }

    private void putRelIdArray(RelIdArray addRels) {
        RelIdArray[] array = this.relationships;
        int expectedType = addRels.getType();
        for (int i = 0; i < array.length; ++i) {
            if (array[i].getType() != expectedType) continue;
            array[i] = addRels;
            return;
        }
        array = Arrays.copyOf(array, array.length + 1);
        array[array.length - 1] = addRels;
        NodeImpl.sort(array);
        this.relationships = array;
    }

    protected boolean isDense() {
        return false;
    }

    public synchronized boolean commitRelationshipMaps(PrimitiveIntObjectMap<RelIdArray> cowRelationshipAddMap, PrimitiveIntObjectMap<PrimitiveLongSet> removeMap, FirstRelationshipIds firstRelationshipIds, boolean dense) {
        if (dense != this.isDense()) {
            return true;
        }
        if (this.relationships == null) {
            return false;
        }
        if (cowRelationshipAddMap != null) {
            RelationshipFilter filter = this.filterForAddingRelationships(firstRelationshipIds, this.relChainPosition);
            for (int type : cowRelationshipAddMap) {
                RelIdArray add = (RelIdArray)cowRelationshipAddMap.get(type);
                PrimitiveLongSet remove = null;
                if (removeMap != null) {
                    remove = (PrimitiveLongSet)removeMap.get(type);
                }
                RelIdArray src = this.getRelIdArray(type);
                this.putRelIdArray(RelIdArray.from(src, add, remove, filter));
            }
        }
        if (removeMap != null) {
            for (int type : removeMap) {
                RelIdArray src;
                if (cowRelationshipAddMap != null && cowRelationshipAddMap.get(type) != null || (src = this.getRelIdArray(type)) == null) continue;
                PrimitiveLongSet remove = (PrimitiveLongSet)removeMap.get(type);
                this.putRelIdArray(RelIdArray.from(src, null, remove));
            }
        }
        return false;
    }

    protected RelationshipFilter filterForAddingRelationships(final FirstRelationshipIds firstRelationshipIdsToCommit, RelationshipLoadingPosition relChainPosition) {
        final PrimitiveLongSet cachedFirstIds = this.gatherFirstIds();
        return new RelationshipFilter(){

            @Override
            public boolean accept(int type, RelIdArray.DirectionWrapper direction, long firstCachedId) {
                long firstIdToCommit = firstRelationshipIdsToCommit.firstIdOf(type, direction);
                assert (firstIdToCommit != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) : "About to add relationships of " + type + " " + (Object)((Object)direction) + " to node " + NodeImpl.this.getId() + ", but apparently the tx state says that no such relationships " + "are to be added " + firstRelationshipIdsToCommit;
                return !cachedFirstIds.contains(firstIdToCommit);
            }
        };
    }

    protected PrimitiveLongSet gatherFirstIds() {
        PrimitiveLongSet result = Primitive.longSet((int)(this.relationships.length * 3));
        for (RelIdArray ids : this.relationships) {
            for (RelIdArray.DirectionWrapper direction : RelIdArray.DirectionWrapper.values()) {
                long firstId = direction.firstId(ids);
                if (firstId == (long)Record.NO_NEXT_RELATIONSHIP.intValue()) continue;
                result.add(firstId);
            }
        }
        return result;
    }

    public RelationshipLoadingPosition getRelChainPosition() {
        return this.relChainPosition;
    }

    void setRelChainPosition(RelationshipLoadingPosition position) {
        this.relChainPosition = position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRelationshipChainPosition(RelationshipHoles holes) {
        if (this.relChainPosition != null && this.relChainPosition.atPosition(holes)) {
            NodeImpl nodeImpl = this;
            synchronized (nodeImpl) {
                if (this.relChainPosition.atPosition(holes)) {
                    this.relChainPosition.patchPosition(this.getId(), holes);
                }
            }
        }
    }

    private void moreRelationshipsLoaded() {
        if (this.relationships != null && !this.hasMoreRelationshipsToLoad(RelIdArray.DirectionWrapper.BOTH, NO_RELATIONSHIP_TYPES)) {
            RelIdArray[] array = this.relationships;
            for (int i = 0; i < array.length; ++i) {
                array[i].shrink();
            }
            this.relChainPosition = RelationshipLoadingPosition.EMPTY;
        }
    }

    RelIdArray getRelationshipIds(int type) {
        return this.getRelIdArray(type);
    }

    RelIdArray[] getRelationshipIds() {
        return this.relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getLabels(CacheLoader<int[]> loader) throws EntityNotFoundException {
        if (this.labels == null) {
            NodeImpl nodeImpl = this;
            synchronized (nodeImpl) {
                if (this.labels == null) {
                    this.labels = loader.load(this.getId());
                }
            }
        }
        return this.labels;
    }

    public boolean hasLabel(int labelId, CacheLoader<int[]> loader) throws EntityNotFoundException {
        int[] labels = this.getLabels(loader);
        return Arrays.binarySearch(labels, labelId) >= 0;
    }

    public synchronized void commitLabels(int[] labels) {
        this.labels = labels;
    }

    @Override
    protected Property noProperty(int key) {
        return Property.noNodeProperty(this.getId(), key);
    }

    private void ensureAllRelationshipsAreLoaded(RelationshipLoader relationshipLoader, CacheUpdateListener cacheUpdateListener) {
        this.ensureRelationshipMapNotNull(relationshipLoader, cacheUpdateListener);
        while (this.hasMoreRelationshipsToLoad()) {
            this.getMoreRelationships(relationshipLoader, RelIdArray.DirectionWrapper.BOTH, NO_RELATIONSHIP_TYPES, cacheUpdateListener);
        }
    }

    public int getDegree(RelationshipLoader relationshipLoader) {
        return relationshipLoader.getRelationshipCount(this.getId(), -1, RelIdArray.DirectionWrapper.BOTH);
    }

    public int getDegree(RelationshipLoader relationshipLoader, int type, CacheUpdateListener cacheUpdateListener) {
        return this.getDegree(relationshipLoader, type, Direction.BOTH, cacheUpdateListener);
    }

    public int getDegree(RelationshipLoader relationshipLoader, Direction direction, CacheUpdateListener cacheUpdateListener) {
        if (direction == Direction.BOTH) {
            return this.getDegree(relationshipLoader);
        }
        return this.getDegreeByDirection(relationshipLoader, RelIdArray.wrap(direction), cacheUpdateListener);
    }

    private int getDegreeByDirection(RelationshipLoader relationshipLoader, RelIdArray.DirectionWrapper direction, CacheUpdateListener cacheUpdateListener) {
        this.ensureAllRelationshipsAreLoaded(relationshipLoader, cacheUpdateListener);
        int count = 0;
        if (this.relationships != null) {
            for (RelIdArray ids : this.relationships) {
                count += ids.length(direction);
            }
        }
        return count;
    }

    public int getDegree(RelationshipLoader relationshipLoader, int typeId, Direction direction, CacheUpdateListener cacheUpdateListener) {
        this.ensureAllRelationshipsAreLoaded(relationshipLoader, cacheUpdateListener);
        RelIdArray ids = this.getRelationshipIds(typeId);
        return ids != null ? ids.length(RelIdArray.wrap(direction)) : 0;
    }

    public Iterator<Integer> getRelationshipTypes(RelationshipLoader relationshipLoader, CacheUpdateListener cacheUpdateListener) {
        this.ensureAllRelationshipsAreLoaded(relationshipLoader, cacheUpdateListener);
        HashSet<Integer> types = new HashSet<Integer>();
        for (RelIdArray ids : this.relationships) {
            types.add(ids.getType());
        }
        return types.iterator();
    }

    public void visitDegrees(RelationshipLoader relationshipLoader, DegreeVisitor visitor, CacheUpdateListener cacheUpdateListener) {
        RelIdArray[] relationships;
        this.ensureAllRelationshipsAreLoaded(relationshipLoader, cacheUpdateListener);
        for (RelIdArray byType : relationships = this.relationships) {
            int outgoing = byType.length(RelIdArray.DirectionWrapper.OUTGOING);
            int incoming = byType.length(RelIdArray.DirectionWrapper.INCOMING);
            visitor.visitDegree(byType.getType(), outgoing, incoming);
        }
    }

    static enum LoadStatus {
        NOTHING(false, false),
        LOADED_END(true, false),
        LOADED_MORE(true, true);

        private final boolean loaded;
        private final boolean more;

        private LoadStatus(boolean loaded, boolean more) {
            this.loaded = loaded;
            this.more = more;
        }

        public boolean loaded() {
            return this.loaded;
        }

        public boolean hasMoreToLoad() {
            return this.more;
        }
    }
}

