/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.AnnotationBasedConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.logging.BufferingLogger;

public class Config
implements DiagnosticsProvider {
    private final List<ConfigurationChangeListener> listeners = new CopyOnWriteArrayList<ConfigurationChangeListener>();
    private final Map<String, String> params = new ConcurrentHashMap<String, String>();
    private final Function<String, String> settingsFunction;
    private StringLogger log = new BufferingLogger();
    private Iterable<Class<?>> settingsClasses = Collections.emptyList();
    private ConfigurationMigrator migrator;
    private ConfigurationValidator validator;

    public Config() {
        this(new HashMap<String, String>(), Collections.emptyList());
    }

    public Config(Map<String, String> inputParams) {
        this(inputParams, Collections.emptyList());
    }

    public Config(Map<String, String> inputParams, Class<?> ... settingsClasses) {
        this(inputParams, Arrays.asList(settingsClasses));
    }

    public Config(Map<String, String> inputParams, Iterable<Class<?>> settingsClasses) {
        this.settingsFunction = Functions.map(this.params);
        this.params.putAll(inputParams);
        this.registerSettingsClasses(settingsClasses);
    }

    public Config registerSettingsClasses(Iterable<Class<?>> settingsClasses) {
        this.settingsClasses = Iterables.concat(settingsClasses, this.settingsClasses);
        this.migrator = new AnnotationBasedConfigurationMigrator(settingsClasses);
        this.validator = new ConfigurationValidator(settingsClasses);
        this.applyChanges(this.getParams());
        return this;
    }

    public Map<String, String> getParams() {
        return new HashMap<String, String>(this.params);
    }

    public <T> T get(Setting<T> setting) {
        return (T)setting.apply(this.settingsFunction);
    }

    @Deprecated
    public Config setProperty(String key, Object value) {
        this.params.put(key, value.toString());
        this.applyChanges(new HashMap<String, String>(this.params));
        return this;
    }

    public synchronized void applyChanges(Map<String, String> newConfiguration) {
        newConfiguration = this.migrator.apply(newConfiguration, this.log);
        this.validator.validate(newConfiguration);
        if (this.listeners.isEmpty()) {
            this.params.clear();
            this.params.putAll(newConfiguration);
        } else {
            ArrayList<ConfigurationChange> configurationChanges = new ArrayList<ConfigurationChange>();
            for (Map.Entry<String, String> stringStringEntry : newConfiguration.entrySet()) {
                String oldValue = this.params.get(stringStringEntry.getKey());
                String newValue = stringStringEntry.getValue();
                if (oldValue == null && newValue == null || oldValue != null && newValue != null && oldValue.equals(newValue)) continue;
                configurationChanges.add(new ConfigurationChange(stringStringEntry.getKey(), oldValue, newValue));
            }
            if (configurationChanges.isEmpty()) {
                return;
            }
            this.params.clear();
            for (Map.Entry<String, String> entry : newConfiguration.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                this.params.put(entry.getKey(), value);
            }
            for (ConfigurationChangeListener listener : this.listeners) {
                listener.notifyConfigurationChanges(configurationChanges);
            }
        }
    }

    public Iterable<Class<?>> getSettingsClasses() {
        return this.settingsClasses;
    }

    public void setLogger(StringLogger log) {
        if (this.log instanceof BufferingLogger) {
            ((BufferingLogger)this.log).replayInto(log);
        }
        this.log = log;
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeConfigurationChangeListener(ConfigurationChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, StringLogger log) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            log.logLongMessage("Neo4j Kernel properties:", Iterables.map(new Function<Map.Entry<String, String>, String>(){

                public String apply(Map.Entry<String, String> stringStringEntry) {
                    return stringStringEntry.getKey() + "=" + stringStringEntry.getValue();
                }
            }, this.params.entrySet()));
        }
    }

    public String toString() {
        ArrayList<String> keys = new ArrayList<String>(this.params.keySet());
        Collections.sort(keys);
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (String key : keys) {
            output.put(key, this.params.get(key));
        }
        return output.toString();
    }

    public static long parseLongWithUnit(String numberWithPotentialUnit) {
        int firstNonDigitIndex = Config.findFirstNonDigit(numberWithPotentialUnit);
        String number = numberWithPotentialUnit.substring(0, firstNonDigitIndex);
        long multiplier = 1L;
        if (firstNonDigitIndex < numberWithPotentialUnit.length()) {
            String unit = numberWithPotentialUnit.substring(firstNonDigitIndex);
            if (unit.equalsIgnoreCase("k")) {
                multiplier = 1024L;
            } else if (unit.equalsIgnoreCase("m")) {
                multiplier = 0x100000L;
            } else if (unit.equalsIgnoreCase("g")) {
                multiplier = 0x40000000L;
            } else {
                throw new IllegalArgumentException("Illegal unit '" + unit + "' for number '" + numberWithPotentialUnit + "'");
            }
        }
        return Long.parseLong(number) * multiplier;
    }

    private static int findFirstNonDigit(String numberWithPotentialUnit) {
        int firstNonDigitIndex = numberWithPotentialUnit.length();
        for (int i = 0; i < numberWithPotentialUnit.length(); ++i) {
            if (Character.isDigit(numberWithPotentialUnit.charAt(i))) continue;
            firstNonDigitIndex = i;
            break;
        }
        return firstNonDigitIndex;
    }

    public Config with(Map<String, String> additionalConfig) {
        Map<String, String> newParams = this.getParams();
        newParams.putAll(additionalConfig);
        return new Config(newParams);
    }
}

