/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;

public class OffHeapIntArray
extends OffHeapNumberArray
implements IntArray {
    private final int defaultValue;
    private long highestSetIndex = -1L;
    private long size;

    public OffHeapIntArray(long length, int defaultValue) {
        super(length, 2);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public int get(long index) {
        return unsafe.getInt(this.addressOf(index));
    }

    @Override
    public void set(long index, int value) {
        long address = this.addressOf(index);
        if (unsafe.getInt(address) == this.defaultValue) {
            ++this.size;
        }
        unsafe.putInt(address, value);
        if (index > this.highestSetIndex) {
            this.highestSetIndex = index;
        }
    }

    @Override
    public long highestSetIndex() {
        return this.highestSetIndex;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            unsafe.setMemory(this.address, this.length << this.shift, (byte)this.defaultValue);
        } else {
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                unsafe.putInt(adr, this.defaultValue);
                ++i;
                adr += (long)this.stride;
            }
        }
        this.highestSetIndex = -1L;
        this.size = 0L;
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        long fromAddress = this.addressOf(fromIndex);
        long toAddress = this.addressOf(toIndex);
        int i = 0;
        while (i < numberOfEntries) {
            int fromValue = unsafe.getInt(fromAddress);
            unsafe.putInt(fromAddress, unsafe.getInt(toAddress));
            unsafe.putInt(toAddress, fromValue);
            ++i;
            fromAddress += (long)this.stride;
            toAddress += (long)this.stride;
        }
    }
}

