/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

abstract class DynamicNumberArray<N extends NumberArray>
implements NumberArray {
    protected final NumberArrayFactory factory;
    private final long chunkSize;
    private NumberArray[] chunks = new NumberArray[0];

    DynamicNumberArray(NumberArrayFactory factory, long chunkSize) {
        this.factory = factory;
        this.chunkSize = chunkSize;
    }

    @Override
    public long length() {
        return (long)this.chunks.length * this.chunkSize;
    }

    @Override
    public long size() {
        long size = 0L;
        for (int i = 0; i < this.chunks.length; ++i) {
            size += this.chunks[i].size();
        }
        return size;
    }

    @Override
    public void clear() {
        for (NumberArray chunk : this.chunks) {
            chunk.clear();
        }
    }

    @Override
    public long highestSetIndex() {
        for (int i = this.chunks.length - 1; i >= 0; --i) {
            NumberArray chunk = this.chunks[i];
            long highestSetInChunk = chunk.highestSetIndex();
            if (highestSetInChunk <= -1L) continue;
            return (long)i * this.chunkSize + highestSetInChunk;
        }
        return -1L;
    }

    @Override
    public void visitMemoryStats(MemoryStatsVisitor visitor) {
        for (NumberArray chunk : this.chunks) {
            chunk.visitMemoryStats(visitor);
        }
    }

    protected N ensureChunkAt(long index) {
        while (index >= this.length()) {
            this.chunks = Arrays.copyOf(this.chunks, this.chunks.length + 1);
            this.chunks[this.chunks.length - 1] = this.addChunk(this.chunkSize);
        }
        return (N)this.chunks[this.chunkIndex(index)];
    }

    protected abstract N addChunk(long var1);

    protected N chunkAt(long index) {
        int chunkIndex = this.chunkIndex(index);
        return (N)(chunkIndex < this.chunks.length ? this.chunks[chunkIndex] : null);
    }

    private int chunkIndex(long index) {
        return (int)(index / this.chunkSize);
    }

    protected long index(long index) {
        return index % this.chunkSize;
    }

    @Override
    public void close() {
        for (NumberArray chunk : this.chunks) {
            chunk.close();
        }
    }
}

