/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public abstract class NodeStoreProcessorStep
extends LonelyProcessingStep {
    protected final NodeStore nodeStore;

    protected NodeStoreProcessorStep(StageControl control, String name, Configuration config, NodeStore nodeStore) {
        super(control, name, config.batchSize(), config.movingAverageSize());
        this.nodeStore = nodeStore;
    }

    @Override
    protected final void process() {
        long highId = this.nodeStore.getHighestPossibleIdInUse();
        NodeRecord heavilyReusedRecord = new NodeRecord(-1L);
        for (long nodeId = highId; nodeId >= 0L; --nodeId) {
            NodeRecord node = this.nodeStore.loadRecord(nodeId, heavilyReusedRecord);
            if (node != null && this.process(node)) {
                this.nodeStore.updateRecord(heavilyReusedRecord);
            }
            this.itemProcessed();
        }
        this.nodeStore.flush();
    }

    protected abstract boolean process(NodeRecord var1);
}

