/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.core.DenseNodeImpl;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class CacheLoaders {
    public static AutoLoadingCache.Loader<NodeImpl> nodeLoader(final NodeStore nodeStore) {
        return new AutoLoadingCache.Loader<NodeImpl>(){

            @Override
            public NodeImpl loadById(long id) {
                NodeRecord record = nodeStore.loadRecord(id, new NodeRecord(id));
                if (record == null) {
                    return null;
                }
                return record.isDense() ? new DenseNodeImpl(id) : new NodeImpl(id);
            }
        };
    }

    public static AutoLoadingCache.Loader<RelationshipImpl> relationshipLoader(final RelationshipStore relationshipStore) {
        return new AutoLoadingCache.Loader<RelationshipImpl>(){

            @Override
            public RelationshipImpl loadById(long id) {
                RelationshipRecord record = new RelationshipRecord(id);
                if (!relationshipStore.fillRecord(id, record, RecordLoad.CHECK)) {
                    return null;
                }
                return new RelationshipImpl(id, record.getFirstNode(), record.getSecondNode(), record.getType());
            }
        };
    }

    private CacheLoaders() {
    }
}

