/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.concurrent.locks.LockSupport;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.NeoStore;

public class LogRotationControl {
    private final NeoStore neoStore;
    private final IndexingService indexingService;
    private final LabelScanStore labelScanStore;
    private final Iterable<IndexImplementation> indexProviders;

    public LogRotationControl(NeoStore neoStore, IndexingService indexingService, LabelScanStore labelScanStore, Iterable<IndexImplementation> indexProviders) {
        this.neoStore = neoStore;
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.indexProviders = indexProviders;
    }

    public void awaitAllTransactionsClosed() {
        while (!this.neoStore.closedTransactionIdIsOnParWithCommittedTransactionId()) {
            LockSupport.parkNanos(1000000L);
        }
    }

    public void forceEverything() {
        this.indexingService.flushAll();
        this.labelScanStore.force();
        for (IndexImplementation index : this.indexProviders) {
            index.force();
        }
        this.neoStore.flush();
    }
}

