/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.ParkStrategy;
import org.neo4j.kernel.impl.util.DebugUtil;

class BatchingForceThread
extends Thread {
    private volatile boolean run = true;
    private final Operation operation;
    private final ParkStrategy waitStrategy;
    private volatile IOException failure;

    BatchingForceThread(Operation operation, ParkStrategy waitStrategy) {
        super("BatchingWrites thread" + DebugUtil.trackTest());
        this.operation = operation;
        this.waitStrategy = waitStrategy;
        this.setDaemon(true);
    }

    public void halt() {
        this.run = false;
    }

    @Override
    public void run() {
        while (this.run) {
            try {
                if (this.operation.perform()) continue;
                this.waitStrategy.park(this);
            }
            catch (IOException e) {
                this.failure = e;
                break;
            }
        }
    }

    boolean checkHealth() throws IOException {
        if (this.failure != null) {
            throw new IOException("An earlier force has failed", this.failure);
        }
        return true;
    }

    public static interface Operation {
        public boolean perform() throws IOException;
    }
}

