/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicatePropertyRemover;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;

class IndexConsultedPropertyBlockSweeper
implements PrimitiveLongVisitor<IOException> {
    private int propertyKeyId;
    private final IndexLookup.Index index;
    private final NodeRecord nodeRecord;
    boolean foundExact;
    private PropertyStore propertyStore;
    private DuplicatePropertyRemover propertyRemover;

    public IndexConsultedPropertyBlockSweeper(int propertyKeyId, IndexLookup.Index index, NodeRecord nodeRecord, PropertyStore propertyStore, DuplicatePropertyRemover propertyRemover) {
        this.propertyKeyId = propertyKeyId;
        this.index = index;
        this.nodeRecord = nodeRecord;
        this.propertyStore = propertyStore;
        this.propertyRemover = propertyRemover;
        this.foundExact = false;
    }

    public boolean visited(long propRecordId) throws IOException {
        PropertyRecord record = this.propertyStore.getRecord(propRecordId);
        boolean changed = false;
        List<PropertyBlock> blocks = record.getPropertyBlocks();
        Iterator<PropertyBlock> it = blocks.iterator();
        while (it.hasNext()) {
            PropertyBlock block = it.next();
            if (block.getKeyIndexId() != this.propertyKeyId) continue;
            Object propertyValue = this.propertyStore.getValue(block);
            if (!this.foundExact && this.index.contains(this.nodeRecord.getId(), propertyValue)) {
                this.foundExact = true;
                continue;
            }
            it.remove();
            changed = true;
        }
        if (changed) {
            if (blocks.isEmpty()) {
                this.propertyRemover.fixUpPropertyLinksAroundUnusedRecord(this.nodeRecord, record);
            }
            this.propertyStore.updateRecord(record);
        }
        return false;
    }
}

