/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.pagecache.StandalonePageCache;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.counts.CountsStore;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class DumpCountsStore {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.out.println("one argument describing the path to the store");
            System.exit(1);
        }
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        File storeFile = new File(args[0]);
        try (StandalonePageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, "counts-store-dump");){
            CountsStore counts = CountsStore.open((FileSystemAbstraction)fs, pageCache, storeFile);
            System.out.println("Counts Store: " + counts.file());
            System.out.println("\ttxId: " + counts.lastTxId());
            System.out.println("\tminor version: " + counts.minorVersion());
            System.out.println("\tentries: " + counts.totalRecordsStored());
            System.out.println("Entries:");
            counts.accept(new KeyValueRecordVisitor<CountsKey, Register.CopyableDoubleLongRegister>(){
                private final Register.DoubleLongRegister tmp = Registers.newDoubleLongRegister();

                @Override
                public void visit(CountsKey key, Register.CopyableDoubleLongRegister register) {
                    register.copyTo((Register.DoubleLong.Out)this.tmp);
                    System.out.println("\t" + key + ": (" + this.tmp.readFirst() + ", " + this.tmp.readSecond() + ")");
                }
            }, Registers.newDoubleLongRegister());
        }
    }
}

