/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;

public class CommunityLockClient
implements Locks.Client {
    private final LockManagerImpl manager;
    private final LockTransaction lockTransaction = new LockTransaction();
    private final Map<Locks.ResourceType, Map<Long, LockResource>> sharedLocks = new HashMap<Locks.ResourceType, Map<Long, LockResource>>();
    private final Map<Locks.ResourceType, Map<Long, LockResource>> exclusiveLocks = new HashMap<Locks.ResourceType, Map<Long, LockResource>>();

    public CommunityLockClient(LockManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public void acquireShared(Locks.ResourceType resourceType, long ... resourceIds) {
        Map<Long, LockResource> localLocks = this.localShared(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                continue;
            }
            resource = new LockResource(resourceType, resourceId);
            this.manager.getReadLock(resource, this.lockTransaction);
            localLocks.put(resourceId, resource);
        }
    }

    @Override
    public void acquireExclusive(Locks.ResourceType resourceType, long ... resourceIds) {
        Map<Long, LockResource> localLocks = this.localExclusive(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                continue;
            }
            resource = new LockResource(resourceType, resourceId);
            this.manager.getWriteLock(resource, this.lockTransaction);
            localLocks.put(resourceId, resource);
        }
    }

    @Override
    public boolean tryExclusiveLock(Locks.ResourceType resourceType, long ... resourceIds) {
        Map<Long, LockResource> localLocks = this.localExclusive(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                continue;
            }
            resource = new LockResource(resourceType, resourceId);
            if (this.manager.tryWriteLock(resource, this.lockTransaction)) {
                localLocks.put(resourceId, resource);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean trySharedLock(Locks.ResourceType resourceType, long ... resourceIds) {
        Map<Long, LockResource> localLocks = this.localShared(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                continue;
            }
            resource = new LockResource(resourceType, resourceId);
            if (this.manager.tryReadLock(resource, this.lockTransaction)) {
                localLocks.put(resourceId, resource);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public void releaseShared(Locks.ResourceType resourceType, long ... resourceIds) {
        Map<Long, LockResource> localLocks = this.localShared(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = localLocks.get(resourceId);
            if (resource.releaseReference() != 0) continue;
            localLocks.remove(resourceId);
            this.manager.releaseReadLock(new LockResource(resourceType, resourceId), this.lockTransaction);
        }
    }

    @Override
    public void releaseExclusive(Locks.ResourceType resourceType, long ... resourceIds) {
        Map<Long, LockResource> localLocks = this.localExclusive(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = localLocks.get(resourceId);
            if (resource.releaseReference() != 0) continue;
            localLocks.remove(resourceId);
            this.manager.releaseWriteLock(new LockResource(resourceType, resourceId), this.lockTransaction);
        }
    }

    @Override
    public void releaseAllShared() {
        for (Map<Long, LockResource> map : this.sharedLocks.values()) {
            for (LockResource resource : map.values()) {
                this.manager.releaseReadLock(resource, this.lockTransaction);
            }
        }
        this.sharedLocks.clear();
    }

    @Override
    public void releaseAllExclusive() {
        for (Map<Long, LockResource> map : this.exclusiveLocks.values()) {
            for (LockResource resource : map.values()) {
                this.manager.releaseWriteLock(resource, this.lockTransaction);
            }
        }
        this.exclusiveLocks.clear();
    }

    @Override
    public void releaseAll() {
        this.releaseAllExclusive();
        this.releaseAllShared();
    }

    @Override
    public void close() {
        this.releaseAll();
    }

    @Override
    public int getLockSessionId() {
        return this.lockTransaction.getId();
    }

    private Map<Long, LockResource> localShared(Locks.ResourceType resourceType) {
        Map<Long, LockResource> map = this.sharedLocks.get(resourceType);
        if (map == null) {
            map = new HashMap<Long, LockResource>();
            this.sharedLocks.put(resourceType, map);
        }
        return map;
    }

    private Map<Long, LockResource> localExclusive(Locks.ResourceType resourceType) {
        Map<Long, LockResource> map = this.exclusiveLocks.get(resourceType);
        if (map == null) {
            map = new HashMap<Long, LockResource>();
            this.exclusiveLocks.put(resourceType, map);
        }
        return map;
    }
}

