/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.record.SchemaRule;

public class BridgingCacheAccess
implements CacheAccessBackDoor {
    private final SchemaCache schemaCache;
    private final SchemaState schemaState;
    private final PersistenceCache persistenceCache;

    public BridgingCacheAccess(SchemaCache schemaCache, SchemaState schemaState, PersistenceCache persistenceCache) {
        this.schemaCache = schemaCache;
        this.schemaState = schemaState;
        this.persistenceCache = persistenceCache;
    }

    @Override
    public void removeNodeFromCache(long nodeId) {
        if (nodeId != -1L) {
            this.persistenceCache.evictNode(nodeId);
        }
    }

    @Override
    public void removeRelationshipFromCache(long id) {
        this.persistenceCache.evictRelationship(id);
    }

    @Override
    public void removeRelationshipTypeFromCache(int id) {
        this.persistenceCache.evictRelationshipType(id);
    }

    @Override
    public void removePropertyKeyFromCache(int id) {
        this.persistenceCache.evictPropertyKey(id);
    }

    @Override
    public void removeLabelFromCache(int id) {
        this.persistenceCache.evictLabel(id);
    }

    @Override
    public void removeGraphPropertiesFromCache() {
        this.persistenceCache.evictGraphProperties();
    }

    @Override
    public void addSchemaRule(SchemaRule rule) {
        this.schemaCache.addSchemaRule(rule);
    }

    @Override
    public void removeSchemaRuleFromCache(long id) {
        this.schemaCache.removeSchemaRule(id);
        this.schemaState.clear();
    }

    @Override
    public void addRelationshipTypeToken(Token type) {
        this.persistenceCache.cacheRelationshipType(type);
    }

    @Override
    public void addLabelToken(Token label) {
        this.persistenceCache.cacheLabel(label);
    }

    @Override
    public void addPropertyKeyToken(Token propertyKey) {
        this.persistenceCache.cachePropertyKey(propertyKey);
    }

    @Override
    public void patchDeletedRelationshipNodes(long relId, int type, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNodeNextRelId) {
        this.persistenceCache.patchDeletedRelationshipNodes(relId, type, firstNodeId, firstNodeNextRelId, secondNodeId, secondNodeNextRelId);
    }

    @Override
    public void applyLabelUpdates(Collection<NodeLabelUpdate> labelUpdates) {
        this.persistenceCache.apply(labelUpdates);
    }
}

