/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionHook;
import org.neo4j.kernel.api.txstate.ReadableTxState;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.TxStateTransactionDataSnapshot;
import org.neo4j.kernel.lifecycle.Lifecycle;

@Deprecated
public class TransactionEventHandlers
implements Lifecycle,
TransactionHook<TransactionHandlerState> {
    protected final Collection<TransactionEventHandler> transactionEventHandlers = new CopyOnWriteArraySet<TransactionEventHandler>();
    private final NodeProxy.NodeLookup nodeLookup;
    private final RelationshipProxy.RelationshipLookups relationshipLookups;
    private final ThreadToStatementContextBridge bridge;
    private static final TransactionData EMPTY_DATA = new TransactionData(){

        @Override
        public Iterable<Node> createdNodes() {
            return Iterables.empty();
        }

        @Override
        public Iterable<Node> deletedNodes() {
            return Iterables.empty();
        }

        @Override
        public boolean isDeleted(Node node) {
            return false;
        }

        @Override
        public Iterable<PropertyEntry<Node>> assignedNodeProperties() {
            return Iterables.empty();
        }

        @Override
        public Iterable<PropertyEntry<Node>> removedNodeProperties() {
            return Iterables.empty();
        }

        @Override
        public Iterable<LabelEntry> assignedLabels() {
            return Iterables.empty();
        }

        @Override
        public Iterable<LabelEntry> removedLabels() {
            return Iterables.empty();
        }

        @Override
        public Iterable<Relationship> createdRelationships() {
            return Iterables.empty();
        }

        @Override
        public Iterable<Relationship> deletedRelationships() {
            return Iterables.empty();
        }

        @Override
        public boolean isDeleted(Relationship relationship) {
            return false;
        }

        @Override
        public Iterable<PropertyEntry<Relationship>> assignedRelationshipProperties() {
            return Iterables.empty();
        }

        @Override
        public Iterable<PropertyEntry<Relationship>> removedRelationshipProperties() {
            return Iterables.empty();
        }
    };

    public TransactionEventHandlers(NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups, ThreadToStatementContextBridge bridge) {
        this.nodeLookup = nodeLookup;
        this.relationshipLookups = relationshipLookups;
        this.bridge = bridge;
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
    }

    @Override
    public void stop() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.transactionEventHandlers.add(handler);
        return handler;
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.unregisterHandler(this.transactionEventHandlers, handler);
    }

    private <T> T unregisterHandler(Collection<?> setOfHandlers, T handler) {
        if (!setOfHandlers.remove(handler)) {
            throw new IllegalStateException(handler + " isn't registered");
        }
        return handler;
    }

    public boolean hasHandlers() {
        return !this.transactionEventHandlers.isEmpty();
    }

    @Override
    public TransactionHandlerState beforeCommit(ReadableTxState state, KernelTransaction transaction, StoreReadLayer storeReadLayer) {
        if (this.transactionEventHandlers.isEmpty()) {
            return null;
        }
        TransactionData txData = state == null ? EMPTY_DATA : new TxStateTransactionDataSnapshot(state, this.nodeLookup, this.relationshipLookups, this.bridge, storeReadLayer);
        TransactionHandlerState handlerStates = new TransactionHandlerState(txData);
        for (TransactionEventHandler handler : this.transactionEventHandlers) {
            try {
                handlerStates.add(handler, handler.beforeCommit(txData));
            }
            catch (Throwable t) {
                handlerStates.failed(t);
            }
        }
        return handlerStates;
    }

    @Override
    public void afterCommit(ReadableTxState state, KernelTransaction transaction, TransactionHandlerState handlerState) {
        if (this.transactionEventHandlers.isEmpty()) {
            return;
        }
        for (HandlerAndState handlerAndState : handlerState.states) {
            handlerAndState.handler.afterCommit(handlerState.txData, handlerAndState.state);
        }
    }

    @Override
    public void afterRollback(ReadableTxState state, KernelTransaction transaction, TransactionHandlerState handlerState) {
        if (this.transactionEventHandlers.isEmpty()) {
            return;
        }
        if (handlerState == null) {
            return;
        }
        for (HandlerAndState handlerAndState : handlerState.states) {
            handlerAndState.handler.afterRollback(handlerState.txData, handlerAndState.state);
        }
    }

    public static class TransactionHandlerState
    implements TransactionHook.Outcome {
        private final TransactionData txData;
        private final List<HandlerAndState> states = new LinkedList<HandlerAndState>();
        private Throwable error;

        public TransactionHandlerState(TransactionData txData) {
            this.txData = txData;
        }

        public void failed(Throwable error) {
            this.error = error;
        }

        @Override
        public boolean isSuccessful() {
            return this.error == null;
        }

        @Override
        public Throwable failure() {
            return this.error;
        }

        public void add(TransactionEventHandler<?> handler, Object state) {
            this.states.add(new HandlerAndState(handler, state));
        }
    }

    public static class HandlerAndState {
        private final TransactionEventHandler handler;
        private final Object state;

        public HandlerAndState(TransactionEventHandler<?> handler, Object state) {
            this.handler = handler;
            this.state = state;
        }
    }
}

