/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class StepStats
implements StatsProvider {
    private final String name;
    private final boolean stillWorking;
    private final Collection<StatsProvider> providers;

    public StepStats(String name, boolean stillWorking, Collection<StatsProvider> providers) {
        this.name = name;
        this.stillWorking = stillWorking;
        this.providers = new ArrayList<StatsProvider>(providers);
    }

    public boolean stillWorking() {
        return this.stillWorking;
    }

    @Override
    public Key[] keys() {
        Key[] keys = null;
        for (StatsProvider provider : this.providers) {
            Key[] providerKeys = provider.keys();
            if (keys == null) {
                keys = providerKeys;
                continue;
            }
            for (Key providerKey : providerKeys) {
                if (this.arrayContains(keys, providerKey)) continue;
                keys = Arrays.copyOf(keys, keys.length + 1);
                keys[keys.length - 1] = providerKey;
            }
        }
        return keys;
    }

    private <T> boolean arrayContains(T[] array, T item) {
        for (T arrayItem : array) {
            if (!arrayItem.equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Stat stat(Key key) {
        for (StatsProvider provider : this.providers) {
            Stat stat = provider.stat(key);
            if (stat == null) continue;
            return stat;
        }
        return null;
    }

    public String toString() {
        return this.toString(DetailLevel.IMPORTANT);
    }

    public String toString(DetailLevel detailLevel) {
        StringBuilder builder = new StringBuilder();
        if (!this.stillWorking && detailLevel == DetailLevel.BASIC) {
            builder.append(" DONE");
        }
        for (Key key : this.keys()) {
            Stat stat = this.stat(key);
            if (detailLevel.ordinal() < stat.detailLevel().ordinal()) continue;
            builder.append(" " + key.shortName() + ":" + stat);
        }
        return this.name + (builder.length() > 0 ? ":" + builder : "");
    }
}

