/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public abstract class RelationshipStoreProcessorStep
extends LonelyProcessingStep {
    private final RelationshipStore relationshipStore;

    protected RelationshipStoreProcessorStep(StageControl control, String name, int batchSize, RelationshipStore relationshipStore) {
        super(control, name, batchSize);
        this.relationshipStore = relationshipStore;
    }

    @Override
    protected final void process() {
        long highId = this.relationshipStore.getHighestPossibleIdInUse();
        RelationshipRecord heavilyReusedRecord = new RelationshipRecord(-1L);
        for (long i = highId; i >= 0L; --i) {
            if (this.relationshipStore.fillRecord(i, heavilyReusedRecord, RecordLoad.CHECK) && this.process(heavilyReusedRecord)) {
                this.relationshipStore.updateRecord(heavilyReusedRecord);
            }
            this.itemProcessed();
        }
    }

    protected abstract boolean process(RelationshipRecord var1);
}

