/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyLogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategyFactory;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;

public class ReadOnlyTransactionStore
extends LifecycleAdapter
implements LogicalTransactionStore {
    private final LifeSupport life = new LifeSupport();
    private final LogicalTransactionStore physicalStore;

    public ReadOnlyTransactionStore(FileSystemAbstraction fs, File fromPath, Monitors monitors) {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(fromPath, fs);
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache(10, 100);
        ReadOnlyTransactionIdStore transactionIdStore = new ReadOnlyTransactionIdStore(fs, fromPath);
        PhysicalLogFile logFile = this.life.add(new PhysicalLogFile(fs, logFiles, 0L, LogPruneStrategyFactory.NO_PRUNING, transactionIdStore, new ReadOnlyLogVersionRepository(fs, fromPath), monitors.newMonitor(PhysicalLogFile.Monitor.class, new String[0]), LogRotationControl.NO_ROTATION_CONTROL, transactionMetadataCache, new Visitor<ReadableVersionableLogChannel, IOException>(){

            @Override
            public boolean visit(ReadableVersionableLogChannel readableLogChannel) throws IOException {
                return true;
            }
        }));
        this.physicalStore = this.life.add(new PhysicalLogicalTransactionStore(logFile, transactionMetadataCache, transactionIdStore, IdOrderingQueue.BYPASS, false));
    }

    @Override
    public TransactionAppender getAppender() {
        throw new UnsupportedOperationException("Read-only transaction store");
    }

    @Override
    public IOCursor<CommittedTransactionRepresentation> getTransactions(long transactionIdToStartFrom) throws NoSuchTransactionException, IOException {
        return this.physicalStore.getTransactions(transactionIdToStartFrom);
    }

    @Override
    public TransactionMetadataCache.TransactionMetadata getMetadataFor(long transactionId) throws NoSuchTransactionException, IOException {
        return this.physicalStore.getMetadataFor(transactionId);
    }

    @Override
    public void init() throws Throwable {
        this.life.init();
    }

    @Override
    public void start() throws Throwable {
        this.life.start();
    }

    @Override
    public void stop() throws Throwable {
        this.life.stop();
    }

    @Override
    public void shutdown() throws Throwable {
        this.life.shutdown();
    }
}

