/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.state.LazyIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class IndexTransactionApplier
extends NeoCommandHandler.Adapter {
    private static final Comparator<NodeLabelUpdate> nodeLabelUpdateComparator = new Comparator<NodeLabelUpdate>(){

        @Override
        public int compare(NodeLabelUpdate o1, NodeLabelUpdate o2) {
            return Long.compare(o1.getNodeId(), o2.getNodeId());
        }
    };
    private final Map<Long, Command.NodeCommand> nodeCommands = new HashMap<Long, Command.NodeCommand>();
    private final Map<Long, List<Command.PropertyCommand>> propertyCommands = new HashMap<Long, List<Command.PropertyCommand>>();
    private final List<NodeLabelUpdate> labelUpdates = new ArrayList<NodeLabelUpdate>();
    private final IndexingService indexingService;
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final LabelScanStore labelScanStore;
    private final CacheAccessBackDoor cacheAccess;
    private final PropertyLoader propertyLoader;
    private final long transactionId;
    private final TransactionApplicationMode mode;

    public IndexTransactionApplier(IndexingService indexingService, LabelScanStore labelScanStore, NodeStore nodeStore, PropertyStore propertyStore, CacheAccessBackDoor cacheAccess, PropertyLoader propertyLoader, long transactionId, TransactionApplicationMode mode) {
        this.indexingService = indexingService;
        this.labelScanStore = labelScanStore;
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.cacheAccess = cacheAccess;
        this.propertyLoader = propertyLoader;
        this.transactionId = transactionId;
        this.mode = mode;
    }

    @Override
    public void apply() {
        if (!this.labelUpdates.isEmpty()) {
            this.updateLabelScanStore();
            this.cacheAccess.applyLabelUpdates(this.labelUpdates);
        }
        if (!this.nodeCommands.isEmpty() || !this.propertyCommands.isEmpty()) {
            this.updateIndexes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexes() {
        LazyIndexUpdates updates = new LazyIndexUpdates(this.nodeStore, this.propertyStore, this.propertyCommands, this.nodeCommands, this.propertyLoader);
        IndexingService indexingService = this.indexingService;
        synchronized (indexingService) {
            this.indexingService.updateIndexes(updates, this.transactionId, this.mode.needsIdempotencyChecks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabelScanStore() {
        Collections.sort(this.labelUpdates, nodeLabelUpdateComparator);
        LabelScanStore labelScanStore = this.labelScanStore;
        synchronized (labelScanStore) {
            try (LabelScanWriter writer = this.labelScanStore.newWriter();){
                for (NodeLabelUpdate update : this.labelUpdates) {
                    writer.write(update);
                }
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        this.nodeCommands.put(command.getKey(), command);
        NodeRecord before = command.getBefore();
        NodeRecord after = command.getAfter();
        NodeLabels labelFieldBefore = NodeLabelsField.parseLabelsField(before);
        NodeLabels labelFieldAfter = NodeLabelsField.parseLabelsField(after);
        if (!labelFieldBefore.isInlined() || !labelFieldAfter.isInlined() || before.getLabelField() != after.getLabelField()) {
            long[] labelsBefore = labelFieldBefore.getIfLoaded();
            long[] labelsAfter = labelFieldAfter.getIfLoaded();
            if (labelsBefore != null && labelsAfter != null) {
                this.labelUpdates.add(NodeLabelUpdate.labelChanges(command.getKey(), labelsBefore, labelsAfter));
            }
        }
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
        PropertyRecord record = command.getAfter();
        if (record.isNodeSet()) {
            long nodeId = command.getAfter().getNodeId();
            List<Command.PropertyCommand> group = this.propertyCommands.get(nodeId);
            if (group == null) {
                group = new ArrayList<Command.PropertyCommand>();
                this.propertyCommands.put(nodeId, group);
            }
            group.add(command);
        }
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
        if (command.getSchemaRule() instanceof IndexRule) {
            switch (command.getMode()) {
                case UPDATE: {
                    if (!((IndexRule)command.getSchemaRule()).isConstraintIndex()) break;
                    try {
                        this.indexingService.activateIndex(command.getSchemaRule().getId());
                        break;
                    }
                    catch (IndexActivationFailedKernelException | IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                        throw new IllegalStateException("Unable to enable constraint, backing index is not online.", e);
                    }
                }
                case CREATE: {
                    this.indexingService.createIndex((IndexRule)command.getSchemaRule());
                    break;
                }
                case DELETE: {
                    this.indexingService.dropIndex((IndexRule)command.getSchemaRule());
                    break;
                }
                default: {
                    throw new IllegalStateException(command.getMode().name());
                }
            }
        }
        return false;
    }
}

