/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.store.StoreId;

public class NeoStoreUtil {
    private final long creationTime;
    private final long randomId;
    private final long txId;
    private final long logVersion;
    private final long storeVersion;
    private final long firstGraphProp;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Supply one argument which is the store directory of a neo4j graph database");
            System.exit(1);
        }
        System.out.println(new NeoStoreUtil(new File(args[0])));
    }

    public static boolean neoStoreExists(FileSystemAbstraction fs, File storeDir) {
        return fs.fileExists(NeoStoreUtil.neoStoreFile(storeDir));
    }

    public NeoStoreUtil(File storeDir) {
        this(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public NeoStoreUtil(File storeDir, FileSystemAbstraction fs) {
        try (StoreChannel channel = fs.open(NeoStoreUtil.neoStoreFile(storeDir), "r");){
            int recordsToRead = 6;
            ByteBuffer buf = ByteBuffer.allocate(recordsToRead * 9);
            int readBytes = channel.read(buf);
            if (readBytes != recordsToRead * 9) {
                throw new RuntimeException(String.format("Unable to read neo store header information. Wanted to read %d records, %d bytes each, but could only read %d bytes i.e. %f records", recordsToRead, 9, readBytes, (double)(readBytes / 9)));
            }
            buf.flip();
            this.creationTime = this.nextRecord(buf);
            this.randomId = this.nextRecord(buf);
            this.logVersion = this.nextRecord(buf);
            this.txId = this.nextRecord(buf);
            this.storeVersion = this.nextRecord(buf);
            this.firstGraphProp = this.nextRecord(buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long nextRecord(ByteBuffer buf) {
        buf.get();
        return buf.getLong();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getStoreId() {
        return this.randomId;
    }

    public long getLastCommittedTx() {
        return this.txId;
    }

    public long getLogVersion() {
        return this.logVersion;
    }

    public long getStoreVersion() {
        return this.storeVersion;
    }

    public long getFirstGraphProp() {
        return this.firstGraphProp;
    }

    public String toString() {
        return String.format("Neostore contents:%n0: creation time: %s%n1: random id: %s%n2: log version: %s%n3: tx id: %s%n4: store version: %s%n5: first graph prop: %s%n => store id: %s", this.creationTime, this.randomId, this.logVersion, this.txId, this.storeVersion, this.firstGraphProp, new StoreId(this.creationTime, this.randomId, this.storeVersion, -1L, -1L));
    }

    public static boolean storeExists(File storeDir) {
        return NeoStoreUtil.storeExists(storeDir, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public static boolean storeExists(File storeDir, FileSystemAbstraction fs) {
        return fs.fileExists(NeoStoreUtil.neoStoreFile(storeDir));
    }

    private static File neoStoreFile(File storeDir) {
        return new File(storeDir, "neostore");
    }
}

