/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordSerializer;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStoreHeader;

public abstract class SortedKeyValueStore<K extends Comparable<K>, VR>
implements Closeable {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final File file;
    private final PagedFile pages;
    private final SortedKeyValueStoreHeader header;
    private final int totalRecords;
    private final KeyValueRecordSerializer<K, VR> recordSerializer;
    private final int recordSize;
    private final WriterFactory<K, VR> writerFactory;

    public SortedKeyValueStore(FileSystemAbstraction fs, PageCache pageCache, File file, PagedFile pages, SortedKeyValueStoreHeader header, KeyValueRecordSerializer<K, VR> recordSerializer, int recordSize, WriterFactory<K, VR> writerFactory) {
        this.fs = fs;
        this.pageCache = pageCache;
        this.file = file;
        this.pages = pages;
        this.header = header;
        this.recordSerializer = recordSerializer;
        this.recordSize = recordSize;
        this.writerFactory = writerFactory;
        this.totalRecords = header.dataRecords();
    }

    public String toString() {
        return String.format("%s[file=%s,%s]", this.getClass().getSimpleName(), this.file, this.header);
    }

    public void get(K key, VR value) {
        int min = this.header.headerRecords();
        int max = min + this.totalRecords - 1;
        try (PageCursor cursor = this.pages.io(0L, 1);){
            while (min <= max) {
                int mid = min + (max - min) / 2;
                int cmp = this.compareKeyAndReadValue(cursor, key, mid, value);
                if (cmp == 0) {
                    return;
                }
                if (cmp < 0) {
                    max = mid - 1;
                    continue;
                }
                min = mid + 1;
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        this.recordSerializer.writeDefaultValue(value);
    }

    private int compareKeyAndReadValue(PageCursor cursor, K target, int record, VR count) throws IOException {
        int pageId = record * this.recordSize / this.pages.pageSize();
        int offset = record * this.recordSize % this.pages.pageSize();
        if ((long)pageId == cursor.getCurrentPageId() || cursor.next((long)pageId)) {
            K key = this.recordSerializer.readRecord(cursor, offset, count);
            return target.compareTo(key);
        }
        throw new IllegalStateException("Could not fetch page: " + pageId);
    }

    public File file() {
        return this.file;
    }

    public long lastTxId() {
        return this.header.lastTxId();
    }

    public long minorVersion() {
        return this.header.minorVersion();
    }

    public long totalRecordsStored() {
        return this.header.dataRecords();
    }

    public void accept(KeyValueRecordVisitor<K, VR> visitor, VR register) {
        try (InputStream in = this.fs.openAsInputStream(this.file);){
            int read;
            int read2;
            for (long bytes = (long)(this.header.headerRecords() * this.recordSize); bytes > 0L && (read2 = in.read()) != -1; --bytes) {
            }
            byte[] record = new byte[this.recordSize];
            ByteBuffer buffer = ByteBuffer.wrap(record);
            boolean readNext = true;
            int offset = 0;
            while (readNext && (read = in.read(record, offset, record.length - offset)) != -1) {
                if (read != record.length) {
                    offset = read;
                    continue;
                }
                buffer.position(0);
                readNext = this.recordSerializer.visitRecord(buffer, visitor, register);
                offset = 0;
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public Writer<K, VR> newWriter(File targetFile, long lastCommittedTxId) throws IOException {
        return this.writerFactory.create(this.fs, this.pageCache, this.header, targetFile, lastCommittedTxId);
    }

    @Override
    public void close() throws IOException {
        this.pageCache.unmap(this.file);
    }

    public static interface WriterFactory<K extends Comparable<K>, VR> {
        public Writer<K, VR> create(FileSystemAbstraction var1, PageCache var2, SortedKeyValueStoreHeader var3, File var4, long var5) throws IOException;
    }

    public static interface Writer<K extends Comparable<K>, VR>
    extends KeyValueRecordVisitor<K, VR>,
    Closeable {
        public SortedKeyValueStore<K, VR> openForReading() throws IOException;
    }
}

