/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.locking.LockWrapper;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.ConcurrentCountsTrackerState;
import org.neo4j.kernel.impl.store.counts.CountsStore;
import org.neo4j.kernel.impl.store.counts.CountsTrackerState;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStoreHeader;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class CountsTracker
implements CountsVisitor.Visitable,
AutoCloseable,
CountsAccessor {
    public static final String STORE_DESCRIPTOR = SortedKeyValueStore.class.getSimpleName();
    public static final String ALPHA = ".alpha";
    public static final String BETA = ".beta";
    private final File alphaFile;
    private final File betaFile;
    private final ReadWriteLock updateLock = new ReentrantReadWriteLock(true);
    private final StringLogger logger;
    private volatile CountsTrackerState state;

    public CountsTracker(StringLogger logger, FileSystemAbstraction fs, PageCache pageCache, File storeFileBase, long neoStoreTxId) {
        this.logger = logger;
        this.alphaFile = CountsTracker.storeFile(storeFileBase, ALPHA);
        this.betaFile = CountsTracker.storeFile(storeFileBase, BETA);
        CountsStore store = CountsTracker.openStore(logger, fs, pageCache, this.alphaFile, this.betaFile);
        if (store.lastTxId() < neoStoreTxId) {
            IOException exOnClose = this.safelyCloseTheStore(store);
            throw new UnderlyingStorageException("Counts store seems to be out of date ( last count store txid is " + store.lastTxId() + " but database wide last txid is " + neoStoreTxId + " ). Please shut down the database and manually delete the counts store files " + "to have the database recreate them on next startup", exOnClose);
        }
        this.state = new ConcurrentCountsTrackerState(store);
    }

    private static CountsStore openStore(StringLogger logger, FileSystemAbstraction fs, PageCache pageCache, File alpha, File beta) {
        try {
            boolean isBetaCorrupted;
            CountsStore alphaStore = CountsTracker.openVerifiedCountsStore(fs, pageCache, alpha);
            CountsStore betaStore = CountsTracker.openVerifiedCountsStore(fs, pageCache, beta);
            boolean isAlphaCorrupted = alphaStore == null;
            boolean bl = isBetaCorrupted = betaStore == null;
            if (isAlphaCorrupted && isBetaCorrupted) {
                throw new UnderlyingStorageException("Neither of the two store files could be properly opened. Please shut down the database and delete them to have the database recreate the counts store on next startup");
            }
            if (isAlphaCorrupted) {
                logger.debug("CountsStore picked beta store file since alpha store file could not be opened (txId=" + betaStore.lastTxId() + ", minorVersion=" + betaStore.minorVersion() + ")");
                return betaStore;
            }
            if (isBetaCorrupted) {
                logger.debug("CountsStore picked alpha store file since beta store file could not be opened (txId=" + alphaStore.lastTxId() + ", minorVersion=" + alphaStore.minorVersion() + ")");
                return alphaStore;
            }
            if (CountsTracker.isAlphaStoreMoreRecent(alphaStore, betaStore)) {
                logger.debug("CountsStore picked alpha store file (txId=" + alphaStore.lastTxId() + ", minorVersion=" + alphaStore.minorVersion() + "), against beta (txId=" + betaStore.lastTxId() + ", minorVersion=" + betaStore.minorVersion() + ")");
                betaStore.close();
                return alphaStore;
            }
            logger.debug("CountsStore picked beta store file (txId=" + betaStore.lastTxId() + ", minorVersion=" + betaStore.minorVersion() + "), against alpha (txId=" + alphaStore.lastTxId() + ", minorVersion=" + alphaStore.minorVersion() + ")");
            alphaStore.close();
            return betaStore;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    private static CountsStore openVerifiedCountsStore(FileSystemAbstraction fs, PageCache pageCache, File file) throws IOException {
        if (!fs.fileExists(file)) {
            throw new UnderlyingStorageException("Expected counts store file " + file + " to exist. You may recreate the counts store by shutting down " + "the database first, deleting the counts store files manually and then restarting the database");
        }
        try {
            return CountsStore.open(fs, pageCache, file);
        }
        catch (IOException | UnderlyingStorageException ex) {
            return null;
        }
    }

    public static boolean countsStoreExists(FileSystemAbstraction fs, File storeFileBase) {
        File alpha = CountsTracker.storeFile(storeFileBase, ALPHA);
        File beta = CountsTracker.storeFile(storeFileBase, BETA);
        return fs.fileExists(alpha) || fs.fileExists(beta);
    }

    private static boolean isAlphaStoreMoreRecent(CountsStore alphaStore, CountsStore betaStore) {
        long alphaTxId = alphaStore.lastTxId();
        long betaTxId = betaStore.lastTxId();
        long alphaVersion = alphaStore.minorVersion();
        long betaVersion = betaStore.minorVersion();
        if (alphaTxId == betaTxId) {
            if (alphaVersion == betaVersion) {
                throw new UnderlyingStorageException("Found two storage files with same tx id and minor version");
            }
            return alphaVersion > betaVersion;
        }
        return alphaTxId > betaTxId;
    }

    public static void createEmptyCountsStore(PageCache pageCache, File file, String storeVersion) {
        File alpha = CountsTracker.storeFile(file, ALPHA);
        CountsStore.createEmpty(pageCache, alpha, SortedKeyValueStoreHeader.with(32, storeVersion, 1L, 2L));
        File beta = CountsTracker.storeFile(file, BETA);
        CountsStore.createEmpty(pageCache, beta, SortedKeyValueStoreHeader.with(32, storeVersion, 1L, 1L));
    }

    public boolean acceptTx(long txId) {
        return this.state.lastTxId() < txId;
    }

    @Override
    public Register.DoubleLongRegister nodeCount(int labelId, Register.DoubleLongRegister target) {
        return this.state.nodeCount(CountsKeyFactory.nodeKey(labelId), target);
    }

    @Override
    public void incrementNodeCount(int labelId, long delta) {
        try (LockWrapper _ = new LockWrapper(this.updateLock.readLock());){
            this.state.incrementNodeCount(CountsKeyFactory.nodeKey(labelId), delta);
        }
    }

    @Override
    public Register.DoubleLongRegister relationshipCount(int startLabelId, int relTypeId, int endLabelId, Register.DoubleLongRegister target) {
        return this.state.relationshipCount(CountsKeyFactory.relationshipKey(startLabelId, relTypeId, endLabelId), target);
    }

    @Override
    public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
        try (LockWrapper _ = new LockWrapper(this.updateLock.readLock());){
            this.state.incrementRelationshipCount(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId), delta);
        }
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(int labelId, int propertyKeyId, Register.DoubleLongRegister target) {
        return this.state.indexUpdatesAndSize(CountsKeyFactory.indexCountsKey(labelId, propertyKeyId), target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(int labelId, int propertyKeyId, Register.DoubleLongRegister target) {
        return this.state.indexSample(CountsKeyFactory.indexSampleKey(labelId, propertyKeyId), target);
    }

    @Override
    public void replaceIndexUpdateAndSize(int labelId, int propertyKeyId, long updates, long size) {
        try (LockWrapper _ = new LockWrapper(this.updateLock.readLock());){
            this.state.replaceIndexUpdatesAndSize(CountsKeyFactory.indexCountsKey(labelId, propertyKeyId), updates, size);
        }
    }

    @Override
    public void incrementIndexUpdates(int labelId, int propertyKeyId, long delta) {
        try (LockWrapper _ = new LockWrapper(this.updateLock.readLock());){
            this.state.incrementIndexUpdates(CountsKeyFactory.indexCountsKey(labelId, propertyKeyId), delta);
        }
    }

    @Override
    public void replaceIndexSample(int labelId, int propertyKeyId, long unique, long size) {
        try (LockWrapper _ = new LockWrapper(this.updateLock.readLock());){
            this.state.replaceIndexSample(CountsKeyFactory.indexSampleKey(labelId, propertyKeyId), unique, size);
        }
    }

    @Override
    public void accept(final CountsVisitor visitor) {
        this.state.accept(new KeyValueRecordVisitor<CountsKey, Register.CopyableDoubleLongRegister>(){
            private final Register.DoubleLongRegister target = Registers.newDoubleLongRegister();

            @Override
            public void visit(CountsKey key, Register.CopyableDoubleLongRegister register) {
                register.copyTo((Register.DoubleLong.Out)this.target);
                key.accept(visitor, this.target.readFirst(), this.target.readSecond());
            }
        });
    }

    @Override
    public void close() {
        try {
            if (this.state.hasChanges()) {
                throw new IllegalStateException("Cannot close with memory-state!");
            }
            this.state.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public void rotate(long lastCommittedTxId) throws IOException {
        block25: {
            try (LockWrapper _ = new LockWrapper(this.updateLock.writeLock());){
                CountsTrackerState state = this.state;
                long stateTxId = state.lastTxId();
                if (stateTxId > lastCommittedTxId) {
                    throw new IllegalStateException(String.format("Ask to rotate on an already used txId, storeTxId=%d and got lastTxId=%d", stateTxId, lastCommittedTxId));
                }
                if (!state.hasChanges() && stateTxId >= lastCommittedTxId) break block25;
                this.logger.debug("Start writing new counts store with txId=" + lastCommittedTxId);
                try (SortedKeyValueStore.Writer<CountsKey, Register.CopyableDoubleLongRegister> writer = this.nextWriter(state, lastCommittedTxId);){
                    state.accept(writer);
                    this.state = new ConcurrentCountsTrackerState(writer.openForReading());
                }
                this.logger.debug("Completed writing of counts store with txId=" + lastCommittedTxId);
                state.close();
            }
        }
    }

    SortedKeyValueStore.Writer<CountsKey, Register.CopyableDoubleLongRegister> nextWriter(CountsTrackerState state, long lastTxId) throws IOException {
        if (this.alphaFile.equals(state.storeFile())) {
            return state.newWriter(this.betaFile, lastTxId);
        }
        return state.newWriter(this.alphaFile, lastTxId);
    }

    File storeFile() {
        return this.state.storeFile();
    }

    private static File storeFile(File base, String version) {
        return new File(base.getParentFile(), base.getName() + version);
    }

    private IOException safelyCloseTheStore(CountsStore store) {
        try {
            store.close();
            return null;
        }
        catch (IOException ex) {
            return ex;
        }
    }
}

