/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.CountsStore;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.SortedKeyValueStoreHeader;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class CountsStoreWriter
implements SortedKeyValueStore.Writer<CountsKey, Register.CopyableDoubleLongRegister>,
CountsVisitor {
    private final FileSystemAbstraction fs;
    private final PageCache pageCache;
    private final SortedKeyValueStoreHeader oldHeader;
    private final PagedFile pagedFile;
    private final File targetFile;
    private final long txId;
    private final long minorVersion;
    private final Register.DoubleLongRegister visitTargetRegister = Registers.newDoubleLongRegister((long)0L, (long)0L);
    private int totalRecords;
    private PageCursor page;

    CountsStoreWriter(FileSystemAbstraction fs, PageCache pageCache, SortedKeyValueStoreHeader oldHeader, File targetFile, long lastCommittedTxId) throws IOException {
        this.fs = fs;
        this.pageCache = pageCache;
        int pageSize = pageCache.pageSize();
        this.oldHeader = oldHeader;
        this.targetFile = targetFile;
        this.txId = lastCommittedTxId;
        this.minorVersion = this.txId == oldHeader.lastTxId() ? oldHeader.minorVersion() + 1L : 1L;
        try (StoreChannel channel = fs.open(targetFile, "rw");){
            channel.truncate(0L).force(true);
        }
        if (pageSize % 32 != 0) {
            throw new IllegalStateException("page size must a multiple of the record size");
        }
        this.pagedFile = pageCache.map(targetFile, pageSize);
        this.page = this.pagedFile.io(0L, 2);
        if (!this.page.next()) {
            throw new IOException("Could not acquire page.");
        }
        this.page.setOffset(this.oldHeader.headerRecords() * 32);
    }

    @Override
    public void visit(CountsKey key, Register.CopyableDoubleLongRegister register) {
        if (!register.hasValues(0L, 0L)) {
            register.copyTo((Register.DoubleLong.Out)this.visitTargetRegister);
            ++this.totalRecords;
            key.accept(this, this.visitTargetRegister.readFirst(), this.visitTargetRegister.readSecond());
        }
    }

    @Override
    public void visitNodeCount(int labelId, long count) {
        assert (count > 0L) : String.format("visitNodeCount(labelId=%d, count=%d) - count must be positive", labelId, count);
        this.write(CountsKeyType.ENTITY_NODE, 0, 0, labelId, 0L, count);
    }

    @Override
    public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
        assert (count > 0L) : String.format("visitRelationshipCount(startLabelId=%d, typeId=%d, endLabelId=%d, count=%d) - count must be positive", startLabelId, typeId, endLabelId, count);
        this.write(CountsKeyType.ENTITY_RELATIONSHIP, startLabelId, typeId, endLabelId, 0L, count);
    }

    @Override
    public void visitIndexCounts(int labelId, int propertyKeyId, long updates, long size) {
        assert (updates >= 0L) : String.format("visitIndexSizeCount(labelId=%d, propertyKeyId=%d, updates=%d, size=%d) - updates must be positive or zero", labelId, propertyKeyId, updates, size);
        assert (size >= 0L) : String.format("visitIndexSizeCount(labelId=%d, propertyKeyId=%d, updates=%d, size=%d) - size must be positive or zero", labelId, propertyKeyId, updates, size);
        this.write(CountsKeyType.INDEX_COUNTS, 0, propertyKeyId, labelId, updates, size);
    }

    @Override
    public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
        assert (unique >= 0L) : String.format("visitIndexSampleCount(labelId=%d, propertyKeyId=%d, unique=%d, size=%d) - unique must be zero or positive", labelId, propertyKeyId, unique, size);
        assert (size >= 0L) : String.format("visitIndexSampleCount(labelId=%d, propertyKeyId=%d, unique=%d, size=%d) - size must be zero or positive", labelId, propertyKeyId, unique, size);
        assert (unique <= size) : String.format("visitIndexSampleCount(labelId=%d, propertyKeyId=%d, unique=%d, size=%d) - unique must be less than or equal to size", labelId, propertyKeyId, unique, size);
        this.write(CountsKeyType.INDEX_SAMPLE, 0, propertyKeyId, labelId, unique, size);
    }

    private void write(CountsKeyType keyType, int firstId, int secondId, int thirdId, long first, long second) {
        try {
            int offset = this.page.getOffset();
            if (offset >= this.pagedFile.pageSize()) {
                if (!this.page.next()) {
                    throw new IOException("Could not acquire next page.");
                }
                offset = 0;
            }
            do {
                this.page.setOffset(offset);
                this.page.putByte(keyType.code);
                this.page.putByte((byte)0);
                this.page.putInt(firstId);
                this.page.putByte((byte)0);
                this.page.putInt(secondId);
                this.page.putByte((byte)0);
                this.page.putInt(thirdId);
                this.page.putLong(first);
                this.page.putLong(second);
            } while (this.page.shouldRetry());
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    public CountsStore openForReading() throws IOException {
        return new CountsStore(this.fs, this.pageCache, this.targetFile, this.pagedFile, this.newHeader());
    }

    @Override
    public void close() throws IOException {
        this.zeroPadding(this.pagedFile, this.page);
        if (!this.page.next(0L)) {
            throw new IOException("Could not update header.");
        }
        this.newHeader().write(this.page);
        this.page.close();
        this.page = null;
        this.pagedFile.flush();
    }

    private void zeroPadding(PagedFile pagedFile, PageCursor page) throws IOException {
        long lastPageId = pagedFile.getLastPageId();
        int pageSize = pagedFile.pageSize();
        while (page.getCurrentPageId() < lastPageId || page.getOffset() < pageSize) {
            this.write(CountsKeyType.EMPTY, 0, 0, 0, 0L, 0L);
        }
    }

    private SortedKeyValueStoreHeader newHeader() {
        return this.oldHeader.update(this.totalRecords, this.txId, this.minorVersion);
    }

    public static class Factory
    implements SortedKeyValueStore.WriterFactory<CountsKey, Register.CopyableDoubleLongRegister> {
        public CountsStoreWriter create(FileSystemAbstraction fs, PageCache pageCache, SortedKeyValueStoreHeader header, File targetFile, long lastCommittedTxId) throws IOException {
            return new CountsStoreWriter(fs, pageCache, header, targetFile, lastCommittedTxId);
        }
    }
}

