/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.RelationshipData;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;

public class RelationshipProxy
implements Relationship {
    private final long relId;
    private final RelationshipLookups relationshipLookups;
    private final ThreadToStatementContextBridge statementContextProvider;

    public RelationshipProxy(long relId, RelationshipLookups relationshipLookups, ThreadToStatementContextBridge statementContextProvider) {
        this.relId = relId;
        this.relationshipLookups = relationshipLookups;
        this.statementContextProvider = statementContextProvider;
    }

    @Override
    public long getId() {
        return this.relId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.relationshipLookups.getGraphDatabaseService();
    }

    @Override
    public void delete() {
        try (Statement statement = this.statementContextProvider.instance();){
            statement.dataWriteOperations().relationshipDelete(this.getId());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Unable to delete relationship[" + this.relId + "] since it is already deleted.");
        }
    }

    @Override
    public Node[] getNodes() {
        this.assertInUnterminatedTransaction();
        RelationshipData data = this.relationshipLookups.getRelationshipData(this.relId);
        return new Node[]{this.relationshipLookups.newNodeProxy(data.getStartNode()), this.relationshipLookups.newNodeProxy(data.getEndNode())};
    }

    @Override
    public Node getOtherNode(Node node) {
        this.assertInUnterminatedTransaction();
        RelationshipData data = this.relationshipLookups.getRelationshipData(this.relId);
        if (data.getStartNode() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(data.getEndNode());
        }
        if (data.getEndNode() == node.getId()) {
            return this.relationshipLookups.newNodeProxy(data.getStartNode());
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public Node getStartNode() {
        this.assertInUnterminatedTransaction();
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.getRelationshipData(this.relId).getStartNode());
    }

    @Override
    public Node getEndNode() {
        this.assertInUnterminatedTransaction();
        return this.relationshipLookups.newNodeProxy(this.relationshipLookups.getRelationshipData(this.relId).getEndNode());
    }

    @Override
    public RelationshipType getType() {
        this.assertInUnterminatedTransaction();
        int type = this.relationshipLookups.getRelationshipData(this.relId).getType();
        return this.relationshipLookups.getRelationshipTypeById(type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.statementContextProvider.instance();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<DefinedProperty> properties = statement.readOperations().relationshipGetAllProperties(this.getId());
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Relationship not found", e);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
        }
    }

    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.readOperations().relationshipGetProperty(this.relId, propertyId).value();
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            Object object = statement.readOperations().relationshipGetProperty(this.relId, propertyId).value(defaultValue);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = propertyId != -1 && statement.readOperations().relationshipGetProperty(this.relId, propertyId).isDefined();
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            statement.dataWriteOperations().relationshipSetProperty(this.relId, Property.property(propertyKeyId, value));
        }
        catch (IllegalArgumentException e) {
            this.statementContextProvider.getKernelTransactionBoundToThisThread(true).failure();
            throw e;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        try (Statement statement = this.statementContextProvider.instance();){
            int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().relationshipRemoveProperty(this.relId, propertyId).value(null);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isType(RelationshipType type) {
        this.assertInUnterminatedTransaction();
        int typeId = this.relationshipLookups.getRelationshipData(this.relId).getType();
        return this.relationshipLookups.getRelationshipTypeById(typeId).name().equals(type.name());
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.relId >>> 32 ^ this.relId);
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }

    private void assertInUnterminatedTransaction() {
        this.statementContextProvider.assertInUnterminatedTransaction();
    }

    public static interface RelationshipLookups {
        public Node newNodeProxy(long var1);

        public RelationshipData getRelationshipData(long var1);

        public RelationshipType getRelationshipTypeById(int var1);

        public GraphDatabaseService getGraphDatabaseService();
    }
}

