/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.RelationshipChainLoader;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;

public class RelationshipLoader {
    private final LockService lockService;
    private final Cache<RelationshipImpl> relationshipCache;
    private final RelationshipChainLoader chainLoader;

    public RelationshipLoader(LockService lockService, Cache<RelationshipImpl> relationshipCache, RelationshipChainLoader chainLoader) {
        this.lockService = lockService;
        this.relationshipCache = relationshipCache;
        this.chainLoader = chainLoader;
    }

    public Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, RelationshipLoadingPosition> getMoreRelationships(NodeImpl node, RelIdArray.DirectionWrapper direction, int[] types) {
        boolean hasLoops;
        long nodeId = node.getId();
        RelationshipLoadingPosition position = node.getRelChainPosition();
        Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, RelationshipLoadingPosition> rels = this.chainLoader.getMoreRelationships(nodeId, position, direction, types);
        ArrayMap<Integer, RelIdArray> newRelationshipMap = new ArrayMap<Integer, RelIdArray>();
        ArrayList<RelationshipImpl> relsList = new ArrayList<RelationshipImpl>(150);
        Iterable<RelationshipRecord> loops = rels.first().get((Object)RelIdArray.DirectionWrapper.BOTH);
        boolean bl = hasLoops = loops != null;
        if (hasLoops) {
            this.populateLoadedRelationships(loops, relsList, RelIdArray.DirectionWrapper.BOTH, true, newRelationshipMap);
        }
        this.populateLoadedRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.OUTGOING), relsList, RelIdArray.DirectionWrapper.OUTGOING, hasLoops, newRelationshipMap);
        this.populateLoadedRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.INCOMING), relsList, RelIdArray.DirectionWrapper.INCOMING, hasLoops, newRelationshipMap);
        return Triplet.of(newRelationshipMap, relsList, rels.other());
    }

    private void populateLoadedRelationships(Iterable<RelationshipRecord> loadedRelationshipRecords, List<RelationshipImpl> relsList, RelIdArray.DirectionWrapper dir, boolean hasLoops, ArrayMap<Integer, RelIdArray> loadedRelationshipsOutputParameter) {
        for (RelationshipRecord rel : loadedRelationshipRecords) {
            long relId = rel.getId();
            RelationshipImpl relImpl = this.getOrCreateRelationshipFromCache(relsList, rel, relId);
            this.getOrCreateRelationships(hasLoops, relImpl.getTypeId(), loadedRelationshipsOutputParameter).add(relId, dir);
        }
    }

    private RelIdArray getOrCreateRelationships(boolean hasLoops, int typeId, ArrayMap<Integer, RelIdArray> loadedRelationships) {
        RelIdArray relIdArray = loadedRelationships.get(typeId);
        if (relIdArray != null) {
            return relIdArray;
        }
        RelIdArray loadedRelIdArray = hasLoops ? new RelIdArrayWithLoops(typeId) : new RelIdArray(typeId);
        loadedRelationships.put(typeId, loadedRelIdArray);
        return loadedRelIdArray;
    }

    private RelationshipImpl getOrCreateRelationshipFromCache(List<RelationshipImpl> newlyCreatedRelationships, RelationshipRecord rel, long relId) {
        RelationshipImpl relImpl = this.relationshipCache.get(relId);
        if (relImpl != null) {
            return relImpl;
        }
        RelationshipImpl loadedRelImpl = new RelationshipImpl(relId, rel.getFirstNode(), rel.getSecondNode(), rel.getType());
        newlyCreatedRelationships.add(loadedRelImpl);
        return loadedRelImpl;
    }

    public void putAllInRelCache(Collection<RelationshipImpl> relationships) {
        this.relationshipCache.putAll(relationships);
    }

    public int getRelationshipCount(long id, int i, RelIdArray.DirectionWrapper direction) {
        return this.chainLoader.getRelationshipCount(id, i, direction);
    }

    public void visitRelationshipCounts(long nodeId, DegreeVisitor visitor) {
        this.chainLoader.visitRelationshipCounts(nodeId, visitor);
    }

    public Integer[] getRelationshipTypes(long id) {
        return this.chainLoader.getRelationshipTypes(id);
    }

    public RelationshipLoadingPosition getRelationshipChainPosition(long id) {
        return this.chainLoader.getRelationshipChainPosition(id);
    }

    public Lock lowLevelNodeReadLock(long nodeId) {
        return this.lockService.acquireNodeLock(nodeId, LockService.LockType.READ_LOCK);
    }
}

