/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.TxState;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.RecordStateForCacheAccessor;
import org.neo4j.kernel.impl.api.state.RelationshipChangesForNode;
import org.neo4j.kernel.impl.api.store.CacheLoader;
import org.neo4j.kernel.impl.api.store.CacheUpdateListener;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.core.EntityFactory;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;

public class PersistenceCache {
    private final CacheUpdateListener NODE_CACHE_SIZE_LISTENER = new CacheUpdateListener(){

        @Override
        public void newSize(Primitive entity, int size) {
            PersistenceCache.this.nodeCache.updateSize((NodeImpl)entity, size);
        }
    };
    private final CacheUpdateListener RELATIONSHIP_CACHE_SIZE_LISTENER = new CacheUpdateListener(){

        @Override
        public void newSize(Primitive entity, int size) {
            PersistenceCache.this.relationshipCache.updateSize((RelationshipImpl)entity, size);
        }
    };
    private final AutoLoadingCache<NodeImpl> nodeCache;
    private final AutoLoadingCache<RelationshipImpl> relationshipCache;
    private GraphPropertiesImpl graphProperties;
    private final RelationshipLoader relationshipLoader;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final EntityFactory entityFactory;
    private final NodeManager nodeManager;

    public PersistenceCache(AutoLoadingCache<NodeImpl> nodeCache, AutoLoadingCache<RelationshipImpl> relationshipCache, EntityFactory entityFactory, RelationshipLoader relationshipLoader, PropertyKeyTokenHolder propertyKeyTokenHolder, RelationshipTypeTokenHolder relationshipTypeTokenHolder, LabelTokenHolder labelTokenHolder, NodeManager nodeManager) {
        this.nodeCache = nodeCache;
        this.relationshipCache = relationshipCache;
        this.entityFactory = entityFactory;
        this.nodeManager = nodeManager;
        this.graphProperties = entityFactory.newGraphProperties();
        this.relationshipLoader = relationshipLoader;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.relationshipTypeTokenHolder = relationshipTypeTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
    }

    public boolean nodeHasLabel(long nodeId, int labelId, CacheLoader<int[]> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).hasLabel(labelId, cacheLoader);
    }

    public int[] nodeGetLabels(long nodeId, CacheLoader<int[]> loader) throws EntityNotFoundException {
        return this.getNode(nodeId).getLabels(loader);
    }

    public NodeImpl getNode(long nodeId) throws EntityNotFoundException {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node == null) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId);
        }
        return node;
    }

    public RelationshipImpl getRelationship(long relationshipId) throws EntityNotFoundException {
        RelationshipImpl relationship = this.relationshipCache.get(relationshipId);
        if (relationship == null) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        return relationship;
    }

    public void apply(TxState txState, final RecordStateForCacheAccessor recordState) {
        txState.accept(new TxState.VisitorAdapter(){

            @Override
            public void visitCreatedNode(long id) {
            }

            @Override
            public void visitDeletedNode(long id) {
                PersistenceCache.this.evictNode(id);
            }

            @Override
            public void visitDeletedRelationship(long id, int type, long startNode, long endNode) {
                PersistenceCache.this.evictRelationship(id);
            }

            @Override
            public void visitNodePropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                NodeImpl node = (NodeImpl)PersistenceCache.this.nodeCache.getIfCached(id);
                if (node != null) {
                    node.commitPropertyMaps((PrimitiveIntObjectMap)this.translateAddedAndChangedProperties(added, changed), (Iterator)removed);
                }
            }

            @Override
            public void visitNodeRelationshipChanges(long id, RelationshipChangesForNode added, RelationshipChangesForNode removed) {
                NodeImpl node = (NodeImpl)PersistenceCache.this.nodeCache.getIfCached(id);
                if (node != null && node.commitRelationshipMaps(this.translateAddedRelationships(added), this.translateRemovedRelationships(removed), recordState.firstRelationshipIdsOf(id), recordState.isDense(id))) {
                    PersistenceCache.this.evictNode(id);
                }
            }

            @Override
            public void visitRelPropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                RelationshipImpl relationship = (RelationshipImpl)PersistenceCache.this.relationshipCache.getIfCached(id);
                if (relationship != null) {
                    relationship.commitPropertyMaps((PrimitiveIntObjectMap)this.translateAddedAndChangedProperties(added, changed), (Iterator)removed);
                }
            }

            @Override
            public void visitGraphPropertyChanges(Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
                PersistenceCache.this.graphProperties.commitPropertyMaps(this.translateAddedAndChangedProperties(added, changed), removed);
            }

            private PrimitiveIntObjectMap<DefinedProperty> translateAddedAndChangedProperties(Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed) {
                if (added == null && changed == null) {
                    return null;
                }
                PrimitiveIntObjectMap result = org.neo4j.collection.primitive.Primitive.intObjectMap();
                this.translateProperties(added, (PrimitiveIntObjectMap<DefinedProperty>)result);
                this.translateProperties(changed, (PrimitiveIntObjectMap<DefinedProperty>)result);
                return result;
            }

            private void translateProperties(Iterator<DefinedProperty> properties, PrimitiveIntObjectMap<DefinedProperty> result) {
                if (properties != null) {
                    while (properties.hasNext()) {
                        DefinedProperty property = properties.next();
                        result.put(property.propertyKeyId(), (Object)property);
                    }
                }
            }

            private PrimitiveIntObjectMap<RelIdArray> translateAddedRelationships(RelationshipChangesForNode added) {
                if (added == null) {
                    return null;
                }
                PrimitiveIntObjectMap result = org.neo4j.collection.primitive.Primitive.intObjectMap();
                PrimitiveIntIterator types = added.getTypesChanged();
                while (types.hasNext()) {
                    int type = types.next();
                    Iterator<Long> loopsChanges = added.loopsChanges(type);
                    RelIdArray ids = loopsChanges == null ? new RelIdArray(type) : new RelIdArrayWithLoops(type);
                    this.addIds(ids, added.outgoingChanges(type), RelIdArray.DirectionWrapper.OUTGOING);
                    this.addIds(ids, added.incomingChanges(type), RelIdArray.DirectionWrapper.INCOMING);
                    this.addIds(ids, loopsChanges, RelIdArray.DirectionWrapper.BOTH);
                    result.put(type, (Object)ids);
                }
                return result;
            }

            private void addIds(RelIdArray idArray, Iterator<Long> ids, RelIdArray.DirectionWrapper direction) {
                if (ids != null) {
                    while (ids.hasNext()) {
                        idArray.add(ids.next(), direction);
                    }
                }
            }

            private PrimitiveIntObjectMap<PrimitiveLongSet> translateRemovedRelationships(RelationshipChangesForNode removed) {
                if (removed == null) {
                    return null;
                }
                PrimitiveIntObjectMap result = org.neo4j.collection.primitive.Primitive.intObjectMap();
                PrimitiveIntIterator types = removed.getTypesChanged();
                while (types.hasNext()) {
                    int type = types.next();
                    PrimitiveLongSet ids = org.neo4j.collection.primitive.Primitive.longSet();
                    this.addIds(ids, removed.outgoingChanges(type));
                    this.addIds(ids, removed.incomingChanges(type));
                    this.addIds(ids, removed.loopsChanges(type));
                    result.put(type, (Object)ids);
                }
                return result;
            }

            private void addIds(PrimitiveLongSet set, Iterator<Long> ids) {
                if (ids != null) {
                    while (ids.hasNext()) {
                        set.add(ids.next().longValue());
                    }
                }
            }
        });
    }

    public void apply(Collection<NodeLabelUpdate> updates) {
        for (NodeLabelUpdate update : updates) {
            NodeImpl node = this.nodeCache.getIfCached(update.getNodeId());
            if (node == null) continue;
            long[] labelsAfter = update.getLabelsAfter();
            int[] labels = new int[labelsAfter.length];
            for (int i = 0; i < labels.length; ++i) {
                labels[i] = (int)labelsAfter[i];
            }
            node.commitLabels(labels);
        }
    }

    public void evictNode(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public void evictRelationship(long relId) {
        this.relationshipCache.remove(relId);
    }

    public void evictGraphProperties() {
        this.graphProperties = this.entityFactory.newGraphProperties();
    }

    public void evictPropertyKey(int id) {
        this.propertyKeyTokenHolder.removeToken(id);
    }

    public void evictRelationshipType(int id) {
        this.relationshipTypeTokenHolder.removeToken(id);
    }

    public void evictLabel(int id) {
        this.labelTokenHolder.removeToken(id);
    }

    public Iterator<DefinedProperty> nodeGetProperties(long nodeId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getProperties(cacheLoader, this.NODE_CACHE_SIZE_LISTENER);
    }

    public PrimitiveLongIterator nodeGetPropertyKeys(long nodeId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getPropertyKeys(cacheLoader, this.NODE_CACHE_SIZE_LISTENER);
    }

    public Property nodeGetProperty(long nodeId, int propertyKeyId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getNode(nodeId).getProperty(cacheLoader, this.NODE_CACHE_SIZE_LISTENER, propertyKeyId);
    }

    public Iterator<DefinedProperty> relationshipGetProperties(long relationshipId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getProperties(cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER);
    }

    public Property relationshipGetProperty(long relationshipId, int propertyKeyId, CacheLoader<Iterator<DefinedProperty>> cacheLoader) throws EntityNotFoundException {
        return this.getRelationship(relationshipId).getProperty(cacheLoader, this.RELATIONSHIP_CACHE_SIZE_LISTENER, propertyKeyId);
    }

    public Iterator<DefinedProperty> graphGetProperties(CacheLoader<Iterator<DefinedProperty>> cacheLoader) {
        return this.graphProperties.getProperties(cacheLoader, CacheUpdateListener.NO_UPDATES);
    }

    public PrimitiveLongIterator graphGetPropertyKeys(CacheLoader<Iterator<DefinedProperty>> cacheLoader) {
        return this.graphProperties.getPropertyKeys(cacheLoader, CacheUpdateListener.NO_UPDATES);
    }

    public Property graphGetProperty(CacheLoader<Iterator<DefinedProperty>> cacheLoader, int propertyKeyId) {
        return this.graphProperties.getProperty(cacheLoader, CacheUpdateListener.NO_UPDATES, propertyKeyId);
    }

    public PrimitiveLongIterator nodeGetRelationships(long node, Direction direction, int[] relTypes) throws EntityNotFoundException {
        return this.getNode(node).getRelationships(this.relationshipLoader, direction, relTypes, this.NODE_CACHE_SIZE_LISTENER);
    }

    public PrimitiveLongIterator nodeGetRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        return this.getNode(nodeId).getRelationships(this.relationshipLoader, direction, this.NODE_CACHE_SIZE_LISTENER);
    }

    public int nodeGetDegree(long nodeId, Direction direction) throws EntityNotFoundException {
        return this.getNode(nodeId).getDegree(this.relationshipLoader, direction, this.NODE_CACHE_SIZE_LISTENER);
    }

    public int nodeGetDegree(long nodeId, int type, Direction direction) throws EntityNotFoundException {
        return this.getNode(nodeId).getDegree(this.relationshipLoader, type, direction, this.NODE_CACHE_SIZE_LISTENER);
    }

    public boolean nodeVisitDegrees(long nodeId, DegreeVisitor visitor) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            node.visitDegrees(this.relationshipLoader, visitor, this.NODE_CACHE_SIZE_LISTENER);
            return true;
        }
        return false;
    }

    public PrimitiveIntIterator nodeGetRelationshipTypes(long nodeId) throws EntityNotFoundException {
        return PrimitiveIntCollections.toPrimitiveIterator(this.getNode(nodeId).getRelationshipTypes(this.relationshipLoader, this.NODE_CACHE_SIZE_LISTENER));
    }

    public void cachePropertyKey(Token token) {
        this.propertyKeyTokenHolder.addToken(token);
    }

    public void cacheRelationshipType(Token token) {
        this.relationshipTypeTokenHolder.addToken(token);
    }

    public void cacheLabel(Token token) {
        this.labelTokenHolder.addToken(token);
    }

    public void patchDeletedRelationshipNodes(long relId, int type, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNodeNextRelId) {
        boolean loop = firstNodeId == secondNodeId;
        this.invalidateNode(firstNodeId, loop ? RelIdArray.DirectionWrapper.BOTH : RelIdArray.DirectionWrapper.OUTGOING, type, relId, firstNodeNextRelId);
        if (!loop) {
            this.invalidateNode(secondNodeId, RelIdArray.DirectionWrapper.INCOMING, type, relId, secondNodeNextRelId);
        }
    }

    private void invalidateNode(long nodeId, RelIdArray.DirectionWrapper direction, int type, long relIdDeleted, long nextRelId) {
        NodeImpl node = this.nodeCache.getIfCached(nodeId);
        if (node != null) {
            node.updateRelationshipChainPosition(direction, type, relIdDeleted, nextRelId);
        }
    }

    public void invalidate(TxState txState) {
        txState.accept(new TxState.VisitorAdapter(){

            @Override
            public void visitCreatedNode(long id) {
                PersistenceCache.this.nodeCache.remove(id);
            }
        });
    }
}

