/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.operations;

import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;

public interface EntityReadOperations {
    public boolean nodeExists(KernelStatement var1, long var2);

    public boolean relationshipExists(KernelStatement var1, long var2);

    public PrimitiveLongIterator nodesGetForLabel(KernelStatement var1, int var2);

    public PrimitiveLongIterator nodesGetFromIndexLookup(KernelStatement var1, IndexDescriptor var2, Object var3) throws IndexNotFoundKernelException;

    public long nodeGetUniqueFromIndexLookup(KernelStatement var1, IndexDescriptor var2, Object var3) throws IndexNotFoundKernelException, IndexBrokenKernelException;

    public boolean nodeHasLabel(KernelStatement var1, long var2, int var4) throws EntityNotFoundException;

    public PrimitiveIntIterator nodeGetLabels(KernelStatement var1, long var2) throws EntityNotFoundException;

    public Property nodeGetProperty(KernelStatement var1, long var2, int var4) throws EntityNotFoundException;

    public Property relationshipGetProperty(KernelStatement var1, long var2, int var4) throws EntityNotFoundException;

    public Property graphGetProperty(KernelStatement var1, int var2);

    public PrimitiveLongIterator nodeGetPropertyKeys(KernelStatement var1, long var2) throws EntityNotFoundException;

    public Iterator<DefinedProperty> nodeGetAllProperties(KernelStatement var1, long var2) throws EntityNotFoundException;

    public PrimitiveLongIterator relationshipGetPropertyKeys(KernelStatement var1, long var2) throws EntityNotFoundException;

    public Iterator<DefinedProperty> relationshipGetAllProperties(KernelStatement var1, long var2) throws EntityNotFoundException;

    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement var1);

    public Iterator<DefinedProperty> graphGetAllProperties(KernelStatement var1);

    public PrimitiveLongIterator nodeGetRelationships(KernelStatement var1, long var2, Direction var4, int[] var5) throws EntityNotFoundException;

    public PrimitiveLongIterator nodeGetRelationships(KernelStatement var1, long var2, Direction var4) throws EntityNotFoundException;

    public int nodeGetDegree(KernelStatement var1, long var2, Direction var4, int var5) throws EntityNotFoundException;

    public int nodeGetDegree(KernelStatement var1, long var2, Direction var4) throws EntityNotFoundException;

    public PrimitiveIntIterator nodeGetRelationshipTypes(KernelStatement var1, long var2) throws EntityNotFoundException;

    public PrimitiveLongIterator nodesGetAll(KernelStatement var1);

    public PrimitiveLongIterator relationshipsGetAll(KernelStatement var1);

    public <EXCEPTION extends Exception> void relationshipVisit(KernelStatement var1, long var2, RelationshipVisitor<EXCEPTION> var4) throws EntityNotFoundException, EXCEPTION;

    public Cursor expand(KernelStatement var1, Cursor var2, NeoRegister.Node.In var3, Register.Object.In<int[]> var4, Register.Object.In<Direction> var5, NeoRegister.Relationship.Out var6, NeoRegister.RelType.Out var7, Register.Object.Out<Direction> var8, NeoRegister.Node.Out var9, NeoRegister.Node.Out var10);
}

