/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;

public class IndexSamplingConfig {
    private final int bufferSize;
    private final double updateRatio;
    private final boolean backgroundSampling;

    public IndexSamplingConfig(Config config) {
        this.bufferSize = config.get(GraphDatabaseSettings.index_sampling_buffer_size).intValue();
        this.updateRatio = (double)config.get(GraphDatabaseSettings.index_sampling_update_percentage).intValue() / 100.0;
        this.backgroundSampling = config.get(GraphDatabaseSettings.index_background_sampling_enabled);
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public double updateRatio() {
        return this.updateRatio;
    }

    public int jobLimit() {
        return 1;
    }

    public boolean backgroundSampling() {
        return this.backgroundSampling;
    }
}

