/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.util.TimeZone;
import javax.transaction.xa.Xid;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public abstract class LogEntry {
    public static final byte CURRENT_LOG_VERSION = 4;
    public static final byte CURRENT_LOG_ENTRY_VERSION = -1;
    public static final byte EMPTY = 0;
    public static final byte TX_START = 1;
    public static final byte TX_PREPARE = 2;
    public static final byte COMMAND = 3;
    public static final byte DONE = 4;
    public static final byte TX_1P_COMMIT = 5;
    public static final byte TX_2P_COMMIT = 6;
    private int identifier;
    private final byte type;
    private final byte version;

    LogEntry(byte type, int identifier, byte version) {
        this.type = type;
        this.identifier = identifier;
        this.version = version;
    }

    public abstract void accept(LogHandler var1) throws IOException;

    public int getIdentifier() {
        return this.identifier;
    }

    public byte getType() {
        return this.type;
    }

    public byte getVersion() {
        return this.version;
    }

    public String toString(TimeZone timeZone) {
        return this.toString();
    }

    public LogEntry reset(int newXidIdentifier) {
        this.identifier = newXidIdentifier;
        return this;
    }

    public String timestamp(long timeWritten, TimeZone timeZone) {
        return Format.date(timeWritten, timeZone) + "/" + timeWritten;
    }

    public static class Command
    extends LogEntry {
        private final XaCommand command;

        public Command(int identifier, XaCommand command) {
            this(identifier, -1, command);
        }

        public Command(int identifier, byte version, XaCommand command) {
            super((byte)3, identifier, version);
            this.command = command;
        }

        public XaCommand getXaCommand() {
            return this.command;
        }

        public String toString() {
            return "Command[" + this.getIdentifier() + ", " + this.command + "]";
        }

        @Override
        public void accept(LogHandler handler) throws IOException {
            handler.commandEntry(this);
        }
    }

    public static class Done
    extends LogEntry {
        public Done(int identifier) {
            this(identifier, -1);
        }

        public Done(int identifier, byte version) {
            super((byte)4, identifier, version);
        }

        @Override
        public void accept(LogHandler handler) throws IOException {
            handler.doneEntry(this);
        }

        public String toString() {
            return "Done[" + this.getIdentifier() + "]";
        }
    }

    public static class TwoPhaseCommit
    extends Commit {
        public TwoPhaseCommit(int identifier, long txId, long timeWritten) {
            this(identifier, -1, txId, timeWritten);
        }

        public TwoPhaseCommit(int identifier, byte version, long txId, long timeWritten) {
            super((byte)6, identifier, version, txId, timeWritten, "2PC");
        }

        @Override
        public void accept(LogHandler handler) throws IOException {
            handler.twoPhaseCommitEntry(this);
        }
    }

    public static class OnePhaseCommit
    extends Commit {
        public OnePhaseCommit(int identifier, long txId, long timeWritten) {
            this(identifier, -1, txId, timeWritten);
        }

        public OnePhaseCommit(int identifier, byte version, long txId, long timeWritten) {
            super((byte)5, identifier, version, txId, timeWritten, "1PC");
        }

        @Override
        public void accept(LogHandler handler) throws IOException {
            handler.onePhaseCommitEntry(this);
        }
    }

    public static abstract class Commit
    extends LogEntry {
        private final long txId;
        private final long timeWritten;
        protected final String name;

        Commit(byte type, int identifier, byte version, long txId, long timeWritten, String name) {
            super(type, identifier, version);
            this.txId = txId;
            this.timeWritten = timeWritten;
            this.name = name;
        }

        public long getTxId() {
            return this.txId;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }

        public String toString() {
            return this.toString(Format.DEFAULT_TIME_ZONE);
        }

        @Override
        public String toString(TimeZone timeZone) {
            return this.name + "[" + this.getIdentifier() + ", txId=" + this.getTxId() + ", " + this.timestamp(this.getTimeWritten(), timeZone) + "]";
        }
    }

    public static class Prepare
    extends LogEntry {
        private final long timeWritten;

        public Prepare(int identifier, long timeWritten) {
            this(identifier, -1, timeWritten);
        }

        public Prepare(int identifier, byte version, long timeWritten) {
            super((byte)2, identifier, version);
            this.timeWritten = timeWritten;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }

        public String toString() {
            return this.toString(Format.DEFAULT_TIME_ZONE);
        }

        @Override
        public void accept(LogHandler handler) throws IOException {
            handler.prepareEntry(this);
        }

        @Override
        public String toString(TimeZone timeZone) {
            return "Prepare[" + this.getIdentifier() + ", " + this.timestamp(this.timeWritten, timeZone) + "]";
        }
    }

    public static class Start
    extends LogEntry {
        private final Xid xid;
        private final int masterId;
        private final int myId;
        private final long timeWritten;
        private final long lastCommittedTxWhenTransactionStarted;
        private long startPosition;

        public Start(Xid xid, int identifier, int masterId, int myId, long startPosition, long timeWritten, long lastCommittedTxWhenTransactionStarted) {
            this(xid, identifier, -1, masterId, myId, startPosition, timeWritten, lastCommittedTxWhenTransactionStarted);
        }

        public Start(Xid xid, int identifier, byte version, int masterId, int myId, long startPosition, long timeWritten, long lastCommittedTxWhenTransactionStarted) {
            super((byte)1, identifier, version);
            this.xid = xid;
            this.masterId = masterId;
            this.myId = myId;
            this.startPosition = startPosition;
            this.timeWritten = timeWritten;
            this.lastCommittedTxWhenTransactionStarted = lastCommittedTxWhenTransactionStarted;
        }

        public Xid getXid() {
            return this.xid;
        }

        public int getMasterId() {
            return this.masterId;
        }

        public int getLocalId() {
            return this.myId;
        }

        public long getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(long position) {
            this.startPosition = position;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }

        public long getLastCommittedTxWhenTransactionStarted() {
            return this.lastCommittedTxWhenTransactionStarted;
        }

        public long getChecksum() {
            long lowBits = this.xid.hashCode();
            long highBits = this.masterId * 37 + this.myId;
            return highBits << 32 | lowBits & 0xFFFFFFFFL;
        }

        public String toString() {
            return this.toString(Format.DEFAULT_TIME_ZONE);
        }

        @Override
        public void accept(LogHandler handler) throws IOException {
            handler.startEntry(this);
        }

        @Override
        public String toString(TimeZone timeZone) {
            return "Start[" + this.getIdentifier() + ",xid=" + this.xid + ",master=" + this.masterId + ",me=" + this.myId + ",time=" + this.timestamp(this.timeWritten, timeZone) + ",lastCommittedTxWhenTransactionStarted=" + this.lastCommittedTxWhenTransactionStarted + "]";
        }
    }
}

