/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.Transaction;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.core.WritableTransactionState;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.logging.Logging;

public class TransactionStateFactory {
    protected Locks locks;
    protected NodeManager nodeManager;
    protected final Logging logging;
    protected RemoteTxHook txHook;
    protected TxIdGenerator txIdGenerator;

    public TransactionStateFactory(Logging logging) {
        this.logging = logging;
    }

    public void setDependencies(Locks lockManager, NodeManager nodeManager, RemoteTxHook txHook, TxIdGenerator txIdGenerator) {
        this.locks = lockManager;
        this.nodeManager = nodeManager;
        this.txHook = txHook;
        this.txIdGenerator = txIdGenerator;
    }

    public TransactionState create(Transaction tx) {
        Locks.Client lockClient = this.locks.newClient();
        lockClient.setTx(tx);
        WritableTransactionState transactionState = new WritableTransactionState(lockClient, this.nodeManager, this.txHook, this.txIdGenerator);
        return transactionState;
    }

    public static TransactionStateFactory noStateFactory(Logging logging) {
        return new TransactionStateFactory(logging){

            @Override
            public TransactionState create(Transaction tx) {
                return TransactionState.NO_STATE;
            }
        };
    }
}

