/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.FirstRelationshipIds;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.TransactionDataImpl;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.RemoteTxHook;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class WritableTransactionState
implements TransactionState {
    private final Locks.Client locks;
    private final NodeManager nodeManager;
    private final RemoteTxHook txHook;
    private final TxIdGenerator txIdGenerator;
    private PrimitiveElement primitiveElement;
    private PersistenceManager.ResourceHolder neoStoreTransaction;
    private boolean isRemotelyInitialized = false;

    public WritableTransactionState(Locks.Client locks, NodeManager nodeManager, RemoteTxHook txHook, TxIdGenerator txIdGenerator) {
        this.locks = locks;
        this.nodeManager = nodeManager;
        this.txHook = txHook;
        this.txIdGenerator = txIdGenerator;
    }

    @Override
    public Locks.Client locks() {
        return this.locks;
    }

    @Override
    public ArrayMap<Integer, SetAndDirectionCounter> getCowRelationshipRemoveMap(NodeImpl node) {
        ArrayMap cowElements;
        CowNodeElement element;
        if (this.primitiveElement != null && (element = (CowNodeElement)(cowElements = this.primitiveElement.nodes).get(node.getId())) != null) {
            return element.relationshipRemoveMap;
        }
        return null;
    }

    @Override
    public SetAndDirectionCounter getOrCreateCowRelationshipRemoveMap(NodeImpl node, int type) {
        return this.getPrimitiveElement(true).nodeElement(node.getId(), true).getRelationshipRemoveMap(type, true);
    }

    @Override
    public void setFirstIds(long nodeId, boolean dense, long firstRel, long firstProp) {
        CowNodeElement nodeElement = this.getPrimitiveElement(true).nodeElement(nodeId, true);
        nodeElement.firstProp = firstProp;
        nodeElement.firstRel = firstRel;
        nodeElement.dense = dense;
    }

    @Override
    public void addRelationshipGroupChange(long nodeId, RelationshipGroupRecord group) {
        CowNodeElement nodeElement = this.getPrimitiveElement(true).nodeElement(nodeId, true);
        nodeElement.addRelationshipGroupChange(group);
    }

    @Override
    public ArrayMap<Integer, RelIdArray> getCowRelationshipAddMap(NodeImpl node) {
        PrimitiveElement primitiveElement = this.getPrimitiveElement(false);
        if (primitiveElement == null) {
            return null;
        }
        CowNodeElement element = primitiveElement.nodeElement(node.getId(), false);
        return element != null ? element.relationshipAddMap : null;
    }

    @Override
    public RelIdArray getOrCreateCowRelationshipAddMap(NodeImpl node, int type) {
        return this.getPrimitiveElement(true).nodeElement(node.getId(), true).getRelationshipAddMap(type, true);
    }

    @Override
    public void commit() {
        this.locks.close();
    }

    @Override
    public void commitCows(CacheAccessBackDoor cacheAccess) {
        this.applyTransactionStateToCache(3, cacheAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            this.applyTransactionStateToCache(4, null);
        }
        finally {
            this.locks.close();
        }
    }

    private void applyTransactionStateToCache(int param, CacheAccessBackDoor cacheAccess) {
        if (this.primitiveElement == null) {
            return;
        }
        ArrayMap cowNodeElements = this.primitiveElement.nodes;
        Set nodeEntrySet = cowNodeElements.entrySet();
        for (Map.Entry entry : nodeEntrySet) {
            NodeImpl node = this.nodeManager.getNodeIfCached((Long)entry.getKey());
            if (node == null) continue;
            CowNodeElement nodeElement = (CowNodeElement)entry.getValue();
            if (param == 3) {
                if (node.commitRelationshipMaps(nodeElement.relationshipAddMap, nodeElement.relationshipRemoveMap, nodeElement, nodeElement.dense)) {
                    cacheAccess.removeNodeFromCache(node.getId());
                }
                node.commitPropertyMaps(nodeElement.propertyAddMap, nodeElement.propertyRemoveMap, nodeElement.firstProp);
            } else if (param != 4) {
                throw new TransactionFailureException("Unknown transaction status: " + param);
            }
            int sizeAfter = node.sizeOfObjectInBytesIncludingOverhead();
            this.nodeManager.updateCacheSize(node, sizeAfter);
        }
        ArrayMap cowRelElements = this.primitiveElement.relationships;
        Set relEntrySet = cowRelElements.entrySet();
        for (Map.Entry entry : relEntrySet) {
            RelationshipImpl rel = this.nodeManager.getRelIfCached((Long)entry.getKey());
            if (rel == null) continue;
            CowRelElement relElement = (CowRelElement)entry.getValue();
            if (param == 3) {
                rel.commitPropertyMaps(relElement.propertyAddMap, relElement.propertyRemoveMap, Record.NO_NEXT_PROPERTY.intValue());
            } else if (param != 4) {
                throw new TransactionFailureException("Unknown transaction status: " + param);
            }
            int sizeAfter = rel.sizeOfObjectInBytesIncludingOverhead();
            this.nodeManager.updateCacheSize(rel, sizeAfter);
        }
        if (this.primitiveElement.graph != null && param == 3) {
            this.nodeManager.getGraphProperties().commitPropertyMaps(this.primitiveElement.graph.getPropertyAddMap(false), this.primitiveElement.graph.getPropertyRemoveMap(false), Record.NO_NEXT_PROPERTY.intValue());
        }
    }

    @Override
    public ArrayMap<Integer, DefinedProperty> getCowPropertyRemoveMap(Primitive primitive) {
        if (this.primitiveElement == null) {
            return null;
        }
        CowEntityElement element = primitive.getEntityElement(this.primitiveElement, false);
        return element != null ? element.getPropertyRemoveMap(false) : null;
    }

    @Override
    public ArrayMap<Integer, DefinedProperty> getCowPropertyAddMap(Primitive primitive) {
        if (this.primitiveElement == null) {
            return null;
        }
        CowEntityElement element = primitive.getEntityElement(this.primitiveElement, false);
        return element != null ? element.getPropertyAddMap(false) : null;
    }

    private PrimitiveElement getPrimitiveElement(boolean create) {
        if (this.primitiveElement == null && create) {
            this.primitiveElement = new PrimitiveElement();
        }
        return this.primitiveElement;
    }

    @Override
    public ArrayMap<Integer, DefinedProperty> getOrCreateCowPropertyAddMap(Primitive primitive) {
        return primitive.getEntityElement(this.getPrimitiveElement(true), true).getPropertyAddMap(true);
    }

    @Override
    public ArrayMap<Integer, DefinedProperty> getOrCreateCowPropertyRemoveMap(Primitive primitive) {
        return primitive.getEntityElement(this.getPrimitiveElement(true), true).getPropertyRemoveMap(true);
    }

    @Override
    public void createNode(long id) {
        this.getPrimitiveElement(true).createdNodes.add(id);
    }

    @Override
    public void createRelationship(long id) {
        this.getPrimitiveElement(true).createdRelationships.add(id);
    }

    @Override
    public void deleteNode(long id) {
        PrimitiveElement element = this.getPrimitiveElement(true);
        element.nodeElement(id, true).setDeleted();
    }

    @Override
    public void deleteRelationship(long id) {
        PrimitiveElement element = this.getPrimitiveElement(true);
        element.relationshipElement(id, true).setDeleted();
    }

    @Override
    public TransactionData getTransactionData() {
        TransactionDataImpl result = new TransactionDataImpl();
        this.populateCreatedNodes(this.primitiveElement, result);
        if (this.primitiveElement == null) {
            return result;
        }
        this.populateNodeRelEvent(this.primitiveElement, result);
        this.populateRelationshipPropertyEvents(this.primitiveElement, result);
        return result;
    }

    private void populateRelationshipPropertyEvents(PrimitiveElement element, TransactionDataImpl result) {
        Iterator i$ = element.relationships.keySet().iterator();
        while (i$.hasNext()) {
            Object oldValue;
            String key;
            long relId = (Long)i$.next();
            CowRelElement relElement = (CowRelElement)element.relationships.get(relId);
            RelationshipProxy rel = this.nodeManager.newRelationshipProxyById(relId);
            RelationshipImpl relImpl = this.nodeManager.getRelationshipForProxy(relId);
            if (relElement.isDeleted() && this.primitiveElement.createdRelationships.contains(relId)) continue;
            if (relElement.propertyAddMap != null && !relElement.isDeleted()) {
                for (DefinedProperty data : relElement.propertyAddMap.values()) {
                    key = this.nodeManager.getKeyForProperty(data);
                    oldValue = relImpl.getCommittedPropertyValue(this.nodeManager, key);
                    Object newValue = data.value();
                    result.assignedProperty(rel, key, newValue, oldValue);
                }
            }
            if (relElement.propertyRemoveMap == null) continue;
            for (DefinedProperty data : relElement.propertyRemoveMap.values()) {
                key = this.nodeManager.getKeyForProperty(data);
                oldValue = data.value();
                if (oldValue != null && !relElement.isDeleted()) {
                    relImpl.getCommittedPropertyValue(this.nodeManager, key);
                }
                result.removedProperty(rel, key, oldValue);
            }
        }
    }

    private void populateNodeRelEvent(PrimitiveElement element, TransactionDataImpl result) {
        Iterator i$ = element.nodes.keySet().iterator();
        while (i$.hasNext()) {
            Object oldValue;
            String key;
            long nodeId = (Long)i$.next();
            CowNodeElement nodeElement = (CowNodeElement)element.nodes.get(nodeId);
            NodeProxy node = this.nodeManager.newNodeProxyById(nodeId);
            NodeImpl nodeImpl = this.nodeManager.getNodeForProxy(nodeId);
            if (nodeElement.isDeleted()) {
                if (this.primitiveElement.createdNodes.contains(nodeId)) continue;
                result.deleted(node);
            }
            if (nodeElement.relationshipAddMap != null && !nodeElement.isDeleted()) {
                for (Integer type : nodeElement.relationshipAddMap.keySet()) {
                    RelIdArray createdRels = (RelIdArray)nodeElement.relationshipAddMap.get(type);
                    this.populateNodeRelEvent(element, result, nodeId, createdRels);
                }
            }
            if (nodeElement.relationshipRemoveMap != null) {
                for (Integer type : nodeElement.relationshipRemoveMap.keySet()) {
                    SetAndDirectionCounter deletedRels = (SetAndDirectionCounter)nodeElement.relationshipRemoveMap.get(type);
                    for (long relId : deletedRels.set) {
                        RelationshipProxy rel;
                        if (this.primitiveElement.createdRelationships.contains(relId) || (rel = this.nodeManager.newRelationshipProxyById(relId)).getStartNode().getId() != nodeId) continue;
                        result.deleted(this.nodeManager.newRelationshipProxyById(relId));
                    }
                }
            }
            if (nodeElement.propertyAddMap != null && !nodeElement.isDeleted()) {
                for (DefinedProperty data : nodeElement.propertyAddMap.values()) {
                    key = this.nodeManager.getKeyForProperty(data);
                    oldValue = nodeImpl.getCommittedPropertyValue(this.nodeManager, key);
                    Object newValue = data.value();
                    result.assignedProperty(node, key, newValue, oldValue);
                }
            }
            if (nodeElement.propertyRemoveMap == null) continue;
            for (DefinedProperty data : nodeElement.propertyRemoveMap.values()) {
                key = this.nodeManager.getKeyForProperty(data);
                oldValue = data.value();
                if (oldValue == null && !nodeElement.isDeleted()) {
                    nodeImpl.getCommittedPropertyValue(this.nodeManager, key);
                }
                result.removedProperty(node, key, oldValue);
            }
        }
    }

    private void populateNodeRelEvent(PrimitiveElement element, TransactionDataImpl result, long nodeId, RelIdArray createdRels) {
        RelIdIterator iterator = createdRels.iterator(RelIdArray.DirectionWrapper.BOTH);
        while (iterator.hasNext()) {
            RelationshipProxy rel;
            long relId = iterator.next();
            CowRelElement relElement = (CowRelElement)element.relationships.get(relId);
            if (relElement != null && relElement.isDeleted() || (rel = this.nodeManager.newRelationshipProxyById(relId)).getStartNode().getId() != nodeId) continue;
            result.created(this.nodeManager.newRelationshipProxyById(relId));
        }
    }

    private void populateCreatedNodes(PrimitiveElement element, TransactionDataImpl result) {
        for (Long nodeId : this.getCreatedNodes()) {
            CowNodeElement nodeElement;
            if (element != null && (nodeElement = (CowNodeElement)element.nodes.get(nodeId)) != null && nodeElement.isDeleted()) continue;
            result.created(this.nodeManager.newNodeProxyById(nodeId));
        }
    }

    @Override
    public Set<Long> getCreatedNodes() {
        return this.primitiveElement != null ? this.primitiveElement.createdNodes : Collections.emptySet();
    }

    @Override
    public Set<Long> getCreatedRelationships() {
        return this.primitiveElement != null ? this.primitiveElement.createdRelationships : Collections.emptySet();
    }

    @Override
    public Iterable<CowNodeElement> getChangedNodes() {
        if (this.primitiveElement == null) {
            return Iterables.empty();
        }
        return this.primitiveElement.nodes.values();
    }

    @Override
    public boolean nodeIsDeleted(long nodeId) {
        if (this.primitiveElement == null) {
            return false;
        }
        CowNodeElement nodeElement = this.primitiveElement.nodeElement(nodeId, false);
        return nodeElement != null && nodeElement.isDeleted();
    }

    @Override
    public boolean relationshipIsDeleted(long relationshipId) {
        if (this.primitiveElement == null) {
            return false;
        }
        CowRelElement relationshipElement = this.primitiveElement.relationshipElement(relationshipId, false);
        return relationshipElement != null && relationshipElement.isDeleted();
    }

    @Override
    public boolean hasChanges() {
        return this.primitiveElement != null;
    }

    @Override
    public RemoteTxHook getTxHook() {
        return this.txHook;
    }

    @Override
    public TxIdGenerator getTxIdGenerator() {
        return this.txIdGenerator;
    }

    @Override
    public boolean isRemotelyInitialized() {
        return this.isRemotelyInitialized;
    }

    @Override
    public void markAsRemotelyInitialized() {
        this.isRemotelyInitialized = true;
    }

    @Override
    public PersistenceManager.ResourceHolder getNeoStoreTransaction() {
        return this.neoStoreTransaction;
    }

    @Override
    public void setNeoStoreTransaction(PersistenceManager.ResourceHolder neoStoreTransaction) {
        this.neoStoreTransaction = neoStoreTransaction;
    }

    public static class CowGraphElement
    extends CowEntityElement {
        CowGraphElement() {
            super(-1L);
        }

        public String toString() {
            return "Graph";
        }
    }

    public static class CowRelElement
    extends CowEntityElement {
        CowRelElement(long id) {
            super(id);
        }

        public String toString() {
            return "Relationship[" + this.id + "]";
        }
    }

    public static class CowNodeElement
    extends CowEntityElement
    implements FirstRelationshipIds {
        private long firstProp = Record.NO_NEXT_PROPERTY.intValue();
        private long firstRel = Record.NO_NEXT_RELATIONSHIP.intValue();
        private PrimitiveIntObjectMap<RelationshipGroupRecord> addedGroups;
        private ArrayMap<Integer, RelIdArray> relationshipAddMap;
        private ArrayMap<Integer, SetAndDirectionCounter> relationshipRemoveMap;
        public boolean dense;

        CowNodeElement(long id) {
            super(id);
        }

        public ArrayMap<Integer, RelIdArray> getRelationshipAddMap(boolean create) {
            if (this.relationshipAddMap == null && create) {
                this.relationshipAddMap = new ArrayMap();
            }
            return this.relationshipAddMap;
        }

        public RelIdArray getRelationshipAddMap(int type, boolean create) {
            ArrayMap<Integer, RelIdArray> map = this.getRelationshipAddMap(create);
            if (map == null) {
                return null;
            }
            RelIdArray result = map.get(type);
            if (result == null && create) {
                result = new RelIdArrayWithLoops(type);
                map.put(type, result);
            }
            return result;
        }

        public ArrayMap<Integer, SetAndDirectionCounter> getRelationshipRemoveMap(boolean create) {
            if (this.relationshipRemoveMap == null && create) {
                this.relationshipRemoveMap = new ArrayMap();
            }
            return this.relationshipRemoveMap;
        }

        public SetAndDirectionCounter getRelationshipRemoveMap(int type, boolean create) {
            ArrayMap<Integer, SetAndDirectionCounter> map = this.getRelationshipRemoveMap(create);
            if (map == null) {
                return null;
            }
            SetAndDirectionCounter result = map.get(type);
            if (result == null && create) {
                result = new SetAndDirectionCounter();
                map.put(type, result);
            }
            return result;
        }

        public void addRelationshipGroupChange(RelationshipGroupRecord group) {
            if (group.inUse()) {
                if (this.addedGroups == null) {
                    this.addedGroups = org.neo4j.collection.primitive.Primitive.intObjectMap();
                }
                this.addedGroups.put(group.getType(), (Object)group);
            }
        }

        @Override
        public long firstIdOf(int type, RelIdArray.DirectionWrapper direction) {
            if (!this.dense) {
                return this.firstRel;
            }
            RelationshipGroupRecord group = (RelationshipGroupRecord)this.addedGroups.get(type);
            if (group == null) {
                return Record.NO_NEXT_RELATIONSHIP.intValue();
            }
            return direction.getNextRel(group);
        }

        public String toString() {
            return "Node[" + this.id + "\n" + "+" + this.relationshipAddMap + "\n" + "-" + this.relationshipRemoveMap + "]";
        }
    }

    static class CowEntityElement {
        protected long id;
        protected boolean deleted;
        protected ArrayMap<Integer, DefinedProperty> propertyAddMap;
        protected ArrayMap<Integer, DefinedProperty> propertyRemoveMap;

        CowEntityElement(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public ArrayMap<Integer, DefinedProperty> getPropertyAddMap(boolean create) {
            this.assertNotDeleted();
            if (this.propertyAddMap == null && create) {
                this.propertyAddMap = new ArrayMap();
            }
            return this.propertyAddMap;
        }

        private void assertNotDeleted() {
            if (this.isDeleted()) {
                throw new IllegalStateException(this + " has been deleted in this tx");
            }
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted() {
            this.deleted = true;
        }

        public ArrayMap<Integer, DefinedProperty> getPropertyRemoveMap(boolean create) {
            if (this.propertyRemoveMap == null && create) {
                this.propertyRemoveMap = new ArrayMap();
            }
            return this.propertyRemoveMap;
        }
    }

    public static class PrimitiveElement {
        private final ArrayMap<Long, CowNodeElement> nodes = new ArrayMap();
        private final ArrayMap<Long, CowRelElement> relationships = new ArrayMap();
        private final Set<Long> createdNodes = new HashSet<Long>();
        private final Set<Long> createdRelationships = new HashSet<Long>();
        private CowGraphElement graph;

        PrimitiveElement() {
        }

        public CowNodeElement nodeElement(long id, boolean create) {
            CowNodeElement result = this.nodes.get(id);
            if (result == null && create) {
                result = new CowNodeElement(id);
                this.nodes.put(id, result);
            }
            return result;
        }

        public CowRelElement relationshipElement(long id, boolean create) {
            CowRelElement result = this.relationships.get(id);
            if (result == null && create) {
                result = new CowRelElement(id);
                this.relationships.put(id, result);
            }
            return result;
        }

        public CowGraphElement graphElement(boolean create) {
            if (this.graph == null && create) {
                this.graph = new CowGraphElement();
            }
            return this.graph;
        }
    }

    public static class SetAndDirectionCounter {
        final Collection<Long> set = new HashSet<Long>();
        final MutableInteger totalCount = new MutableInteger();
        private final Map<Direction, MutableInteger> counters = new EnumMap<Direction, MutableInteger>(Direction.class);

        public SetAndDirectionCounter() {
            this.counters.put(Direction.OUTGOING, new MutableInteger());
            this.counters.put(Direction.INCOMING, new MutableInteger());
            this.counters.put(Direction.BOTH, new MutableInteger());
        }

        void add(long id, Direction direction) {
            this.set.add(id);
            ++this.counters.get((Object)((Object)direction)).value;
            ++this.totalCount.value;
        }

        int getCount(Direction direction) {
            return direction == Direction.BOTH ? this.totalCount.value : this.counters.get((Object)((Object)direction)).value + this.counters.get((Object)((Object)Direction.BOTH)).value;
        }

        public int totalCount() {
            return this.totalCount.value;
        }
    }

    private static class MutableInteger {
        int value;

        private MutableInteger() {
        }
    }
}

