/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.EntityWithSizeObject;
import org.neo4j.kernel.impl.cache.HitCounter;

public class StrongReferenceCache<E extends EntityWithSizeObject>
implements Cache<E> {
    private final ConcurrentHashMap<Long, E> cache = new ConcurrentHashMap();
    private final String name;
    private final HitCounter counter = new HitCounter();

    public StrongReferenceCache(String name) {
        this.name = name;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public E get(long key) {
        return (E)((EntityWithSizeObject)this.counter.count(this.cache.get(key)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public E put(E value) {
        EntityWithSizeObject old = (EntityWithSizeObject)this.cache.put(value.getId(), value);
        return (E)(old == null ? value : old);
    }

    @Override
    public void putAll(List<E> list) {
        for (EntityWithSizeObject entity : list) {
            this.cache.put(entity.getId(), entity);
        }
    }

    @Override
    public E remove(long key) {
        return (E)((EntityWithSizeObject)this.cache.remove(key));
    }

    @Override
    public long hitCount() {
        return this.counter.getHitsCount();
    }

    @Override
    public long missCount() {
        return this.counter.getMissCount();
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public void putAll(Collection<E> values) {
        for (EntityWithSizeObject entity : values) {
            this.cache.put(entity.getId(), entity);
        }
    }

    @Override
    public void updateSize(E entity, int newSize) {
    }

    @Override
    public void printStatistics() {
    }
}

