/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.transaction.xa.Xid;
import org.neo4j.kernel.impl.nioneo.xa.TransactionWriter;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class LogEntryVerifyingOutput
implements TransactionWriter.Output {
    private final List<LogEntry> otherEntriesToVerify;
    private final List<XaCommand> commandsToVerify;

    public LogEntryVerifyingOutput(List<LogEntry> entriesToVerify) {
        this.commandsToVerify = this.pullOutCommands(entriesToVerify);
        this.otherEntriesToVerify = this.pullOutOtherEntries(entriesToVerify);
    }

    private List<LogEntry> pullOutOtherEntries(List<LogEntry> entriesToVerify) {
        ArrayList<LogEntry> otherEntries = new ArrayList<LogEntry>();
        for (LogEntry entry : entriesToVerify) {
            if (entry instanceof LogEntry.Command) continue;
            otherEntries.add(entry);
        }
        return otherEntries;
    }

    private List<XaCommand> pullOutCommands(List<LogEntry> entriesToVerify) {
        ArrayList<XaCommand> commands = new ArrayList<XaCommand>();
        for (LogEntry entry : entriesToVerify) {
            if (!(entry instanceof LogEntry.Command)) continue;
            commands.add(((LogEntry.Command)entry).getXaCommand());
        }
        return commands;
    }

    @Override
    public void writeStart(Xid xid, int identifier, int masterId, int myId, long startTimestamp, long latestCommittedTxWhenTxStarted) throws IOException {
    }

    @Override
    public void writeCommand(int identifier, XaCommand command) throws IOException {
        boolean removed = this.commandsToVerify.remove(command);
        assert (removed) : "Unexpected command " + command + ". I had these left to verify " + this.commandsToVerify;
    }

    @Override
    public void writePrepare(int identifier, long prepareTimestamp) throws IOException {
    }

    @Override
    public void writeCommit(int identifier, boolean twoPhase, long txId, long commitTimestamp) throws IOException {
    }

    @Override
    public void writeDone(int identifier) throws IOException {
    }

    public void done() {
        assert (Collections.emptyList().equals(this.commandsToVerify)) : "Unexpected commands found" + this.commandsToVerify;
    }
}

