/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import javax.transaction.xa.XAException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.store.UniquenessConstraintRule;

public class IntegrityValidator {
    private final NeoStore neoStore;
    private final IndexingService indexes;

    public IntegrityValidator(NeoStore neoStore, IndexingService indexes) {
        this.neoStore = neoStore;
        this.indexes = indexes;
    }

    public void validateNodeRecord(NodeRecord record) throws XAException {
        if (!record.inUse() && record.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            throw Exceptions.withCause(new XAException(103), new ConstraintViolationException("Node record " + record + " still has relationships"));
        }
    }

    public void validateTransactionStartKnowledge(long lastCommittedTxWhenTransactionStarted) throws XAException {
        long latestConstraintIntroducingTx = this.neoStore.getLatestConstraintIntroducingTx();
        if (lastCommittedTxWhenTransactionStarted < latestConstraintIntroducingTx) {
            throw Exceptions.withCause(new XAException(103), new ConstraintViolationException(String.format("Database constraints have changed (txId=%d) after this transaction (txId=%d) started, which is not yet supported. Please retry your transaction to ensure all constraints are executed.", latestConstraintIntroducingTx, lastCommittedTxWhenTransactionStarted)));
        }
    }

    public void validateSchemaRule(SchemaRule schemaRule) throws XAException {
        if (schemaRule instanceof UniquenessConstraintRule) {
            try {
                this.indexes.validateIndex(((UniquenessConstraintRule)schemaRule).getOwnedIndex());
            }
            catch (ConstraintVerificationFailedKernelException e) {
                throw Exceptions.withCause(new XAException(103), e);
            }
            catch (IndexNotFoundKernelException | IndexPopulationFailedKernelException e) {
                throw Exceptions.withCause(new XAException(-3), e);
            }
        }
    }
}

