/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v20;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyLogIoUtil;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class Legacy20CommandReader
implements LegacyLogIoUtil.CommandReader {
    private static final DynamicRecordAdder<PropertyBlock> PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyBlock>(){

        @Override
        public void add(PropertyBlock target, DynamicRecord record) {
            record.setCreated();
            target.addValueRecord(record);
        }
    };
    private static final byte NONE = 0;
    private static final byte NODE_COMMAND = 1;
    private static final byte PROP_COMMAND = 2;
    private static final byte REL_COMMAND = 3;
    private static final byte REL_TYPE_COMMAND = 4;
    private static final byte PROP_INDEX_COMMAND = 5;
    private static final byte NEOSTORE_COMMAND = 6;
    private static final byte SCHEMA_RULE_COMMAND = 7;
    private static final byte LABEL_KEY_COMMAND = 8;
    private static final DynamicRecordAdder<PropertyRecord> PROPERTY_DELETED_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyRecord>(){

        @Override
        public void add(PropertyRecord target, DynamicRecord record) {
            assert (!record.inUse()) : record + " is kinda weird";
            target.addDeletedRecord(record);
        }
    };
    private static final DynamicRecordAdder<PropertyKeyTokenRecord> PROPERTY_INDEX_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<PropertyKeyTokenRecord>(){

        @Override
        public void add(PropertyKeyTokenRecord target, DynamicRecord record) {
            target.addNameRecord(record);
        }
    };
    private static final DynamicRecordAdder<Collection<DynamicRecord>> COLLECTION_DYNAMIC_RECORD_ADDER = new DynamicRecordAdder<Collection<DynamicRecord>>(){

        @Override
        public void add(Collection<DynamicRecord> target, DynamicRecord record) {
            target.add(record);
        }
    };

    private static PropertyBlock readPropertyBlock(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
            return null;
        }
        byte blockSize = buffer.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, blockSize)) {
            return null;
        }
        long[] blocks = Legacy20CommandReader.readLongs(buffer, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyType(blocks[0], false).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + (Object)((Object)PropertyType.getPropertyType(blocks[0], false));
        toReturn.setValueBlocks(blocks);
        if (!Legacy20CommandReader.readDynamicRecords(byteChannel, buffer, toReturn, PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER)) {
            return null;
        }
        return toReturn;
    }

    private static <T> boolean readDynamicRecords(ReadableByteChannel byteChannel, ByteBuffer buffer, T target, DynamicRecordAdder<T> adder) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 4)) {
            return false;
        }
        int numberOfRecords = buffer.getInt();
        assert (numberOfRecords >= 0);
        while (numberOfRecords-- > 0) {
            DynamicRecord read = Legacy20CommandReader.readDynamicRecord(byteChannel, buffer);
            if (read == null) {
                return false;
            }
            adder.add(target, read);
        }
        return true;
    }

    private static DynamicRecord readDynamicRecord(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 13)) {
            return null;
        }
        long id = buffer.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            record.setStartRecord((inUseFlag & Record.FIRST_IN_CHAIN.byteValue()) != 0);
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 12)) {
                return null;
            }
            int nrOfBytes = buffer.getInt();
            assert (nrOfBytes >= 0 && nrOfBytes < 0xFFFFFF) : nrOfBytes + " is not valid for a number of bytes field of a dynamic record";
            long nextBlock = buffer.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, nrOfBytes)) {
                return null;
            }
            byte[] data = new byte[nrOfBytes];
            buffer.get(data);
            record.setData(data);
        }
        return record;
    }

    private static long[] readLongs(ByteBuffer buffer, int count) {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = buffer.getLong();
        }
        return result;
    }

    @Override
    public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
            return null;
        }
        byte commandType = buffer.get();
        switch (commandType) {
            case 1: {
                return Legacy20CommandReader.readNodeCommand(byteChannel, buffer);
            }
            case 2: {
                return Legacy20CommandReader.readPropertyCommand(byteChannel, buffer);
            }
            case 5: {
                return Legacy20CommandReader.readPropertyKeyTokenCommand(byteChannel, buffer);
            }
            case 3: {
                return Legacy20CommandReader.readRelationshipCommand(byteChannel, buffer);
            }
            case 4: {
                return Legacy20CommandReader.readRelationshipTypeTokenCommand(byteChannel, buffer);
            }
            case 8: {
                return Legacy20CommandReader.readLabelTokenCommand(byteChannel, buffer);
            }
            case 6: {
                return Legacy20CommandReader.readNeoStoreCommand(byteChannel, buffer);
            }
            case 7: {
                return Legacy20CommandReader.readSchemaRuleCommand(byteChannel, buffer);
            }
            case 0: {
                return null;
            }
        }
        throw new IOException("Unknown command type[" + commandType + "]");
    }

    private static Command readNodeCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 8)) {
            return null;
        }
        long id = buffer.getLong();
        NodeRecord before = Legacy20CommandReader.readNodeRecord(id, byteChannel, buffer);
        if (before == null) {
            return null;
        }
        NodeRecord after = Legacy20CommandReader.readNodeRecord(id, byteChannel, buffer);
        if (after == null) {
            return null;
        }
        if (!before.inUse() && after.inUse()) {
            after.setCreated();
        }
        return new Command.NodeCommand().init(before, after);
    }

    private static NodeRecord readNodeRecord(long id, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        NodeRecord record;
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
            return null;
        }
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if (inUseFlag == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        if (inUse) {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 24)) {
                return null;
            }
            record = new NodeRecord(id, false, buffer.getLong(), buffer.getLong());
            long labelField = buffer.getLong();
            ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
            Legacy20CommandReader.readDynamicRecords(byteChannel, buffer, dynamicLabelRecords, COLLECTION_DYNAMIC_RECORD_ADDER);
            record.setLabelField(labelField, dynamicLabelRecords);
        } else {
            record = new NodeRecord(id, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue());
        }
        record.setInUse(inUse);
        return record;
    }

    private static Command readPropertyCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 8)) {
            return null;
        }
        long id = buffer.getLong();
        PropertyRecord before = Legacy20CommandReader.readPropertyRecord(id, byteChannel, buffer);
        if (before == null) {
            return null;
        }
        PropertyRecord after = Legacy20CommandReader.readPropertyRecord(id, byteChannel, buffer);
        if (after == null) {
            return null;
        }
        return new Command.PropertyCommand().init(before, after);
    }

    private static PropertyRecord readPropertyRecord(long id, ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        long primitiveId;
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 25)) {
            return null;
        }
        PropertyRecord record = new PropertyRecord(id);
        byte inUseFlag = buffer.get();
        long nextProp = buffer.getLong();
        long prevProp = buffer.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        }
        boolean nodeProperty = true;
        if ((inUseFlag & Record.REL_PROPERTY.byteValue()) == Record.REL_PROPERTY.byteValue()) {
            nodeProperty = false;
        }
        if ((primitiveId = buffer.getLong()) != -1L && nodeProperty) {
            record.setNodeId(primitiveId);
        } else if (primitiveId != -1L) {
            record.setRelId(primitiveId);
        }
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
            return null;
        }
        int nrPropBlocks = buffer.get();
        assert (nrPropBlocks >= 0);
        if (nrPropBlocks > 0) {
            record.setInUse(true);
        }
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = Legacy20CommandReader.readPropertyBlock(byteChannel, buffer);
            if (block == null) {
                return null;
            }
            record.addPropertyBlock(block);
        }
        if (!Legacy20CommandReader.readDynamicRecords(byteChannel, buffer, record, PROPERTY_DELETED_DYNAMIC_RECORD_ADDER)) {
            return null;
        }
        buffer.flip();
        int deletedRecords = buffer.getInt();
        assert (deletedRecords >= 0);
        while (deletedRecords-- > 0) {
            DynamicRecord read = Legacy20CommandReader.readDynamicRecord(byteChannel, buffer);
            if (read == null) {
                return null;
            }
            record.addDeletedRecord(read);
        }
        if (inUse && !record.inUse() || !inUse && record.inUse()) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
        }
        return record;
    }

    private static Command readPropertyKeyTokenCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 13)) {
            return null;
        }
        int id = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(buffer.getInt());
        record.setNameId(buffer.getInt());
        if (!Legacy20CommandReader.readDynamicRecords(byteChannel, buffer, record, PROPERTY_INDEX_DYNAMIC_RECORD_ADDER)) {
            return null;
        }
        return new Command.PropertyKeyTokenCommand().init(record);
    }

    private static Command readRelationshipCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        RelationshipRecord record;
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 9)) {
            return null;
        }
        long id = buffer.getLong();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if ((inUseFlag & Record.IN_USE.byteValue()) != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        if (inUse) {
            if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 60)) {
                return null;
            }
            record = new RelationshipRecord(id, buffer.getLong(), buffer.getLong(), buffer.getInt());
            record.setInUse(inUse);
            record.setFirstPrevRel(buffer.getLong());
            record.setFirstNextRel(buffer.getLong());
            record.setSecondPrevRel(buffer.getLong());
            record.setSecondNextRel(buffer.getLong());
            record.setNextProp(buffer.getLong());
        } else {
            record = new RelationshipRecord(id, -1L, -1L, -1);
            record.setInUse(false);
        }
        return new Command.RelationshipCommand().init(record);
    }

    private static Command readRelationshipTypeTokenCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 13)) {
            return null;
        }
        int id = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(buffer.getInt());
        int nrTypeRecords = buffer.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = Legacy20CommandReader.readDynamicRecord(byteChannel, buffer);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return new Command.RelationshipTypeTokenCommand().init(record);
    }

    private static Command readLabelTokenCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 13)) {
            return null;
        }
        int id = buffer.getInt();
        byte inUseFlag = buffer.get();
        boolean inUse = false;
        if ((inUseFlag & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
        } else if (inUseFlag != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + inUseFlag);
        }
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(buffer.getInt());
        int nrTypeRecords = buffer.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = Legacy20CommandReader.readDynamicRecord(byteChannel, buffer);
            if (dr == null) {
                return null;
            }
            record.addNameRecord(dr);
        }
        return new Command.LabelTokenCommand().init(record);
    }

    private static Command readNeoStoreCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 8)) {
            return null;
        }
        long nextProp = buffer.getLong();
        NeoStoreRecord record = new NeoStoreRecord();
        record.setNextProp(nextProp);
        return new Command.NeoStoreCommand().init(record);
    }

    private static Command readSchemaRuleCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
        ArrayList<DynamicRecord> recordsBefore = new ArrayList<DynamicRecord>();
        Legacy20CommandReader.readDynamicRecords(byteChannel, buffer, recordsBefore, COLLECTION_DYNAMIC_RECORD_ADDER);
        ArrayList<DynamicRecord> recordsAfter = new ArrayList<DynamicRecord>();
        Legacy20CommandReader.readDynamicRecords(byteChannel, buffer, recordsAfter, COLLECTION_DYNAMIC_RECORD_ADDER);
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 1)) {
            throw new IllegalStateException("Missing SchemaRule.isCreated flag in deserialization");
        }
        byte isCreated = buffer.get();
        if (1 == isCreated) {
            for (DynamicRecord record : recordsAfter) {
                record.setCreated();
            }
        }
        if (!IoPrimitiveUtils.readAndFlip(byteChannel, buffer, 8)) {
            throw new IllegalStateException("Missing SchemaRule.txId in deserialization");
        }
        long txId = buffer.getLong();
        SchemaRule rule = ((DynamicRecord)IteratorUtil.first(recordsAfter)).inUse() ? Legacy20CommandReader.readSchemaRule(recordsAfter) : Legacy20CommandReader.readSchemaRule(recordsBefore);
        return new Command.SchemaRuleCommand().init(recordsBefore, recordsAfter, rule, txId);
    }

    private static SchemaRule readSchemaRule(Collection<DynamicRecord> recordsBefore) {
        SchemaRule rule;
        assert (IteratorUtil.first(recordsBefore).inUse()) : "Asked to deserialize schema records that were not in use.";
        ByteBuffer deserialized = AbstractDynamicStore.concatData(recordsBefore, new byte[100]);
        try {
            rule = SchemaRule.Kind.deserialize(IteratorUtil.first(recordsBefore).getId(), deserialized);
        }
        catch (MalformedSchemaRuleException e) {
            throw new IllegalStateException(e);
        }
        return rule;
    }

    private static interface DynamicRecordAdder<T> {
        public void add(T var1, DynamicRecord var2);
    }
}

