/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;

public class DropIndexFailureException
extends SchemaKernelException {
    private final IndexDescriptor indexDescriptor;
    private static final String message = "Unable to drop index on %s: %s";

    public DropIndexFailureException(IndexDescriptor indexDescriptor, SchemaKernelException cause) {
        super((Status)Status.Schema.IndexDropFailure, String.format(message, indexDescriptor, cause.getMessage()), cause);
        this.indexDescriptor = indexDescriptor;
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format(message, this.indexDescriptor.userDescription(tokenNameLookup), ((KernelException)this.getCause()).getUserMessage(tokenNameLookup));
    }
}

