/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.io.IOException;
import javax.transaction.xa.XAException;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.nioneo.xa.command.LogWriter;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriter;

public class MasterLogWriter
extends LogHandler.Filter {
    private LogBuffer writeBuffer;
    private LogEntry.Start startEntry;
    private final LogWriter.SPI spi;
    private final InjectedTransactionValidator injectedTxValidator;
    private final LogEntryWriter logEntryWriter;

    public MasterLogWriter(LogHandler handler, LogWriter.SPI spi, InjectedTransactionValidator injectedTxValidator, LogEntryWriter logEntryWriter) {
        super(handler);
        this.spi = spi;
        this.injectedTxValidator = injectedTxValidator;
        this.logEntryWriter = logEntryWriter;
    }

    @Override
    public void startLog() {
        this.writeBuffer = this.spi.getWriteBuffer();
        super.startLog();
    }

    @Override
    public void startEntry(LogEntry.Start startEntry) throws IOException {
        this.startEntry = startEntry;
        try {
            this.injectedTxValidator.assertInjectionAllowed(startEntry.getLastCommittedTxWhenTransactionStarted());
        }
        catch (XAException e) {
            throw new IOException(e);
        }
        startEntry.setStartPosition(this.writeBuffer.getFileChannelPosition());
        super.startEntry(startEntry);
        this.logEntryWriter.writeLogEntry(startEntry, this.writeBuffer);
    }

    @Override
    public void prepareEntry(LogEntry.Prepare prepareEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(prepareEntry, this.writeBuffer);
        super.prepareEntry(prepareEntry);
    }

    @Override
    public void onePhaseCommitEntry(LogEntry.OnePhaseCommit onePhaseCommitEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(onePhaseCommitEntry, this.writeBuffer);
        this.writeBuffer.writeOut();
        super.onePhaseCommitEntry(onePhaseCommitEntry);
    }

    @Override
    public void twoPhaseCommitEntry(LogEntry.TwoPhaseCommit twoPhaseCommitEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(twoPhaseCommitEntry, this.writeBuffer);
        this.writeBuffer.writeOut();
        super.twoPhaseCommitEntry(twoPhaseCommitEntry);
    }

    @Override
    public void doneEntry(LogEntry.Done doneEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(doneEntry, this.writeBuffer);
        super.doneEntry(doneEntry);
    }

    @Override
    public void commandEntry(LogEntry.Command commandEntry) throws IOException {
        this.logEntryWriter.writeLogEntry(commandEntry, this.writeBuffer);
        super.commandEntry(commandEntry);
    }

    @Override
    public void endLog(boolean success) throws IOException {
        this.spi.commitTransactionWithoutTxId(this.startEntry);
        super.endLog(success);
        this.startEntry = null;
        this.writeBuffer = null;
    }
}

