/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.Thunk;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.TransactionInterceptorProviders;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.Kernel;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.api.store.CacheLayer;
import org.neo4j.kernel.impl.api.store.DiskLayer;
import org.neo4j.kernel.impl.api.store.PersistenceCache;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.cache.BridgingCacheAccess;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.xa.DefaultSchemaIndexProviderMap;
import org.neo4j.kernel.impl.nioneo.xa.IntegrityValidator;
import org.neo4j.kernel.impl.nioneo.xa.InterceptingWriteTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreFileListing;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreProvider;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransaction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreTransactionContextSupplier;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaConnection;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.persistence.IdGenerationFailedException;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogBackedXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptor;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsExtractor;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;

public class NeoStoreXaDataSource
extends LogBackedXaDataSource
implements NeoStoreProvider {
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    private NeoStoreTransactionContextSupplier neoStoreTransactionContextSupplier;
    public static final byte[] BRANCH_ID = UTF8.encode("414141");
    public static final String LOGICAL_LOG_DEFAULT_NAME = "nioneo_logical.log";
    private final StringLogger msgLog;
    private final Logging logging;
    private final AbstractTransactionManager txManager;
    private final DependencyResolver dependencyResolver;
    private final TransactionStateFactory stateFactory;
    private final TransactionInterceptorProviders providers;
    private final TokenNameLookup tokenNameLookup;
    private final PropertyKeyTokenHolder propertyKeyTokens;
    private final LabelTokenHolder labelTokens;
    private final RelationshipTypeTokenHolder relationshipTypeTokens;
    private final PersistenceManager persistenceManager;
    private final SchemaWriteGuard schemaWriteGuard;
    private final TransactionEventHandlers transactionEventHandlers;
    private final StoreFactory storeFactory;
    private final XaFactory xaFactory;
    private final JobScheduler scheduler;
    private final UpdateableSchemaState updateableSchemaState;
    private final Config config;
    private final LockService locks;
    private LifeSupport life;
    private KernelAPI kernel;
    private NeoStore neoStore;
    private IndexingService indexingService;
    private SchemaIndexProvider indexProvider;
    private XaContainer xaContainer;
    private ArrayMap<Class<?>, Store> idGenerators;
    private IntegrityValidator integrityValidator;
    private NeoStoreFileListing fileListing;
    private File storeDir;
    private boolean readOnly;
    private CacheAccessBackDoor cacheAccess;
    private PersistenceCache persistenceCache;
    private SchemaCache schemaCache;
    private LabelScanStore labelScanStore;
    private final IndexingService.Monitor indexingServiceMonitor;
    private final FileSystemAbstraction fs;
    private Function<NeoStore, Function<List<LogEntry>, List<LogEntry>>> translatorFactory;
    private final StoreUpgrader storeMigrationProcess;

    public NeoStoreXaDataSource(Config config, LockService locks, StoreFactory sf, StringLogger stringLogger, XaFactory xaFactory, TransactionStateFactory stateFactory, TransactionInterceptorProviders providers, JobScheduler scheduler, Logging logging, UpdateableSchemaState updateableSchemaState, TokenNameLookup tokenNameLookup, DependencyResolver dependencyResolver, AbstractTransactionManager txManager, PropertyKeyTokenHolder propertyKeyTokens, LabelTokenHolder labelTokens, RelationshipTypeTokenHolder relationshipTypeTokens, PersistenceManager persistenceManager, SchemaWriteGuard schemaWriteGuard, TransactionEventHandlers transactionEventHandlers, IndexingService.Monitor indexingServiceMonitor, FileSystemAbstraction fs, Function<NeoStore, Function<List<LogEntry>, List<LogEntry>>> translatorFactory, StoreUpgrader storeMigrationProcess) {
        super(BRANCH_ID, DEFAULT_DATA_SOURCE_NAME);
        this.config = config;
        this.stateFactory = stateFactory;
        this.tokenNameLookup = tokenNameLookup;
        this.dependencyResolver = dependencyResolver;
        this.providers = providers;
        this.scheduler = scheduler;
        this.logging = logging;
        this.txManager = txManager;
        this.propertyKeyTokens = propertyKeyTokens;
        this.labelTokens = labelTokens;
        this.relationshipTypeTokens = relationshipTypeTokens;
        this.persistenceManager = persistenceManager;
        this.schemaWriteGuard = schemaWriteGuard;
        this.transactionEventHandlers = transactionEventHandlers;
        this.indexingServiceMonitor = indexingServiceMonitor;
        this.fs = fs;
        this.translatorFactory = translatorFactory;
        this.storeMigrationProcess = storeMigrationProcess;
        this.readOnly = config.get(Configuration.read_only);
        this.msgLog = stringLogger;
        this.storeFactory = sf;
        this.xaFactory = xaFactory;
        this.updateableSchemaState = updateableSchemaState;
        this.locks = locks;
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.life = new LifeSupport();
        this.readOnly = this.config.get(Configuration.read_only);
        this.storeDir = this.config.get(Configuration.store_dir);
        File store = this.config.get(Configuration.neo_store);
        this.storeFactory.ensureStoreExists();
        TransactionFactory tf = this.providers.shouldInterceptCommitting() ? new InterceptingTransactionFactory() : new TransactionFactory();
        this.indexProvider = this.dependencyResolver.resolveDependency(SchemaIndexProvider.class, SchemaIndexProvider.HIGHEST_PRIORITIZED_OR_NONE);
        this.storeMigrationProcess.addParticipant(this.indexProvider.storeMigrationParticipant());
        DefaultSchemaIndexProviderMap providerMap = new DefaultSchemaIndexProviderMap(this.indexProvider);
        this.storeMigrationProcess.migrateIfNeeded(store.getParentFile());
        this.neoStore = this.storeFactory.newNeoStore(store);
        this.neoStoreTransactionContextSupplier = new NeoStoreTransactionContextSupplier(this.neoStore);
        this.schemaCache = new SchemaCache(Collections.emptyList());
        final NodeManager nodeManager = this.dependencyResolver.resolveDependency(NodeManager.class);
        Iterator<Cache<?>> caches = nodeManager.caches().iterator();
        this.persistenceCache = new PersistenceCache((AutoLoadingCache)caches.next(), (AutoLoadingCache)caches.next(), new Thunk<GraphPropertiesImpl>(){

            @Override
            public GraphPropertiesImpl evaluate() {
                return nodeManager.getGraphProperties();
            }
        }, nodeManager);
        this.cacheAccess = new BridgingCacheAccess(nodeManager, this.schemaCache, this.updateableSchemaState, this.persistenceCache);
        try {
            this.indexingService = this.life.add(new IndexingService(this.scheduler, providerMap, new NeoStoreIndexStoreView(this.locks, this.neoStore), this.tokenNameLookup, this.updateableSchemaState, this.logging, this.indexingServiceMonitor));
            this.integrityValidator = new IntegrityValidator(this.neoStore, this.indexingService);
            this.xaContainer = this.xaFactory.newXaContainer(this, this.config.get(Configuration.logical_log), XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

                @Override
                public XaCommandWriter newInstance() {
                    return new PhysicalLogNeoXaCommandWriter();
                }
            }, new NeoStoreInjectedTransactionValidator(this.integrityValidator), tf, this.stateFactory, this.providers, this.readOnly, this.translatorFactory.apply(this.neoStore));
            this.labelScanStore = this.life.add(this.dependencyResolver.resolveDependency(LabelScanStoreProvider.class, LabelScanStoreProvider.HIGHEST_PRIORITIZED).getLabelScanStore());
            this.fileListing = new NeoStoreFileListing(this.xaContainer, this.storeDir, this.labelScanStore, this.indexingService);
            Provider<NeoStore> neoStoreProvider = new Provider<NeoStore>(){

                @Override
                public NeoStore instance() {
                    return NeoStoreXaDataSource.this.getNeoStore();
                }
            };
            this.kernel = this.life.add(new Kernel(this.txManager, this.propertyKeyTokens, this.labelTokens, this.relationshipTypeTokens, this.persistenceManager, this.updateableSchemaState, this.schemaWriteGuard, this.indexingService, nodeManager, neoStoreProvider, this.persistenceCache, this.schemaCache, providerMap, this.fs, this.config, this.labelScanStore, new CacheLayer(new DiskLayer(this.propertyKeyTokens, this.labelTokens, this.relationshipTypeTokens, new SchemaStorage(this.neoStore.getSchemaStore()), neoStoreProvider, this.indexingService), this.persistenceCache, this.indexingService, this.schemaCache, nodeManager), this.scheduler, this.readOnly));
            this.kernel.registerTransactionHook(this.transactionEventHandlers);
            this.life.init();
            if (!this.readOnly) {
                this.neoStore.setRecoveredStatus(true);
                try {
                    this.indexingService.initIndexes(this.loadIndexRules());
                    this.xaContainer.openLogicalLog();
                }
                finally {
                    this.neoStore.setRecoveredStatus(false);
                }
            }
            if (!this.xaContainer.getResourceManager().hasRecoveredTransactions()) {
                this.neoStore.makeStoreOk();
            } else {
                this.msgLog.debug("Waiting for TM to take care of recovered transactions.");
            }
            this.idGenerators = new ArrayMap(5, false, false);
            this.idGenerators.put(Node.class, this.neoStore.getNodeStore());
            this.idGenerators.put(Relationship.class, this.neoStore.getRelationshipStore());
            this.idGenerators.put(RelationshipType.class, this.neoStore.getRelationshipTypeStore());
            this.idGenerators.put(Label.class, this.neoStore.getLabelTokenStore());
            this.idGenerators.put(PropertyStore.class, this.neoStore.getPropertyStore());
            this.idGenerators.put(PropertyKeyTokenRecord.class, this.neoStore.getPropertyKeyTokenStore());
            this.setLogicalLogAtCreationTime(this.xaContainer.getLogicalLog());
            this.life.start();
        }
        catch (Throwable e) {
            try {
                this.neoStore.close();
            }
            catch (Exception closeException) {
                this.msgLog.logMessage("Couldn't close neostore after startup failure");
            }
            throw Exceptions.launderedException(e);
        }
    }

    public NeoStore getNeoStore() {
        return this.neoStore;
    }

    public IndexingService getIndexService() {
        return this.indexingService;
    }

    public SchemaIndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    public LockService getLockService() {
        return this.locks;
    }

    @Override
    public void stop() {
        super.stop();
        if (!this.readOnly) {
            this.forceEverything();
        }
        this.life.shutdown();
        this.xaContainer.close();
        this.neoStore.close();
        this.msgLog.info("NeoStore closed");
    }

    private void forceEverything() {
        this.neoStore.flushAll();
        this.indexingService.flushAll();
        this.labelScanStore.force();
    }

    @Override
    public void shutdown() {
    }

    public StoreId getStoreId() {
        return this.neoStore.getStoreId();
    }

    @Override
    public NeoStoreXaConnection getXaConnection() {
        return new NeoStoreXaConnection(this.neoStore, this.xaContainer.getResourceManager(), this.getBranchId());
    }

    public long nextId(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.nextId();
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getHighestPossibleIdInUse();
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        Store store = this.idGenerators.get(clazz);
        if (store == null) {
            throw new IdGenerationFailedException("No IdGenerator for: " + clazz);
        }
        return store.getNumberOfIdsInUse();
    }

    public String getStoreDir() {
        return this.storeDir.getPath();
    }

    @Override
    public long getCreationTime() {
        return this.neoStore.getCreationTime();
    }

    @Override
    public long getRandomIdentifier() {
        return this.neoStore.getRandomNumber();
    }

    @Override
    public long getCurrentLogVersion() {
        return this.neoStore.getVersion();
    }

    public long incrementAndGetLogVersion() {
        return this.neoStore.incrementVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastCommittedTxId(long txId) {
        this.neoStore.setRecoveredStatus(true);
        try {
            this.neoStore.setLastCommittedTx(txId);
        }
        finally {
            this.neoStore.setRecoveredStatus(false);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public List<WindowPoolStats> getWindowPoolStats() {
        return this.neoStore.getAllWindowPoolStats();
    }

    @Override
    public long getLastCommittedTxId() {
        return this.neoStore.getLastCommittedTx();
    }

    @Override
    public XaContainer getXaContainer() {
        return this.xaContainer;
    }

    public KernelAPI getKernel() {
        return this.kernel;
    }

    @Override
    public boolean setRecovered(boolean recovered) {
        boolean currentValue = this.neoStore.isInRecoveryMode();
        this.neoStore.setRecoveredStatus(true);
        return currentValue;
    }

    @Override
    public ResourceIterator<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        return this.fileListing.listStoreFiles(includeLogicalLogs);
    }

    @Override
    public ResourceIterator<File> listStoreFiles() throws IOException {
        return this.fileListing.listStoreFiles();
    }

    @Override
    public ResourceIterator<File> listLogicalLogs() throws IOException {
        return this.fileListing.listLogicalLogs();
    }

    public void registerDiagnosticsWith(DiagnosticsManager manager) {
        manager.registerAll(Diagnostics.class, this);
    }

    private Iterator<IndexRule> loadIndexRules() {
        return new SchemaStorage(this.neoStore.getSchemaStore()).allIndexRules();
    }

    @Override
    public NeoStore evaluate() {
        return this.neoStore;
    }

    @Override
    public void recoveryCompleted() throws IOException {
        this.indexingService.startIndexes();
    }

    @Override
    public LogBufferFactory createLogBufferFactory() {
        return this.xaContainer.getLogicalLog().createLogWriter(new Function<Config, File>(){

            @Override
            public File apply(Config config) {
                return config.get(Configuration.logical_log);
            }
        });
    }

    public void reloadSchemaCache() {
        ((Kernel)this.kernel).loadSchemaCache();
    }

    private class InterceptingTransactionFactory
    extends TransactionFactory {
        private InterceptingTransactionFactory() {
        }

        @Override
        public XaTransaction create(long lastCommittedTxWhenTransactionStarted, TransactionState state) {
            TransactionInterceptor first = NeoStoreXaDataSource.this.providers.resolveChain(NeoStoreXaDataSource.this);
            NeoStoreTransactionContext context = (NeoStoreTransactionContext)NeoStoreXaDataSource.this.neoStoreTransactionContextSupplier.acquire();
            context.bind(state);
            return new InterceptingWriteTransaction(lastCommittedTxWhenTransactionStarted, this.getLogicalLog(), NeoStoreXaDataSource.this.neoStore, NeoStoreXaDataSource.this.cacheAccess, NeoStoreXaDataSource.this.indexingService, NeoStoreXaDataSource.this.labelScanStore, first, NeoStoreXaDataSource.this.integrityValidator, (KernelTransactionImplementation)NeoStoreXaDataSource.this.kernel.newTransaction(), NeoStoreXaDataSource.this.locks, context);
        }
    }

    private class TransactionFactory
    extends XaTransactionFactory {
        private TransactionFactory() {
        }

        @Override
        public XaTransaction create(long lastCommittedTxWhenTransactionStarted, TransactionState state) {
            NeoStoreTransactionContext context = (NeoStoreTransactionContext)NeoStoreXaDataSource.this.neoStoreTransactionContextSupplier.acquire();
            context.bind(state);
            return new NeoStoreTransaction(lastCommittedTxWhenTransactionStarted, this.getLogicalLog(), NeoStoreXaDataSource.this.neoStore, NeoStoreXaDataSource.this.cacheAccess, NeoStoreXaDataSource.this.indexingService, NeoStoreXaDataSource.this.labelScanStore, NeoStoreXaDataSource.this.integrityValidator, (KernelTransactionImplementation)NeoStoreXaDataSource.this.kernel.newTransaction(), NeoStoreXaDataSource.this.locks, context);
        }

        @Override
        public void recoveryComplete() {
            NeoStoreXaDataSource.this.msgLog.debug("Recovery complete, all transactions have been resolved");
            NeoStoreXaDataSource.this.msgLog.debug("Rebuilding id generators as needed. This can take a while for large stores...");
            NeoStoreXaDataSource.this.forceEverything();
            NeoStoreXaDataSource.this.neoStore.makeStoreOk();
            NeoStoreXaDataSource.this.neoStore.setVersion(NeoStoreXaDataSource.this.xaContainer.getLogicalLog().getHighestLogVersion());
            NeoStoreXaDataSource.this.msgLog.debug("Rebuild of id generators complete.");
        }

        @Override
        public long getCurrentVersion() {
            return NeoStoreXaDataSource.this.neoStore.getVersion();
        }

        @Override
        public long getAndSetNewVersion() {
            return NeoStoreXaDataSource.this.neoStore.incrementVersion();
        }

        @Override
        public void setVersion(long version) {
            NeoStoreXaDataSource.this.neoStore.setVersion(version);
        }

        @Override
        public void flushAll() {
            NeoStoreXaDataSource.this.forceEverything();
        }

        @Override
        public long getLastCommittedTx() {
            return NeoStoreXaDataSource.this.neoStore.getLastCommittedTx();
        }
    }

    private static enum Diagnostics implements DiagnosticsExtractor<NeoStoreXaDataSource>
    {
        NEO_STORE_VERSIONS("Store versions:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logVersions(log);
            }
        }
        ,
        NEO_STORE_ID_USAGE("Id usage:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logIdUsage(log);
            }
        }
        ,
        PERSISTENCE_WINDOW_POOL_STATS("Persistence Window Pool stats:"){

            @Override
            void dump(NeoStoreXaDataSource source, StringLogger.LineLogger log) {
                source.neoStore.logAllWindowPoolStats(log);
            }

            @Override
            boolean applicable(DiagnosticsPhase phase) {
                return phase.isExplicitlyRequested();
            }
        };

        private final String message;

        private Diagnostics(String message) {
            this.message = message;
        }

        @Override
        public void dumpDiagnostics(final NeoStoreXaDataSource source, DiagnosticsPhase phase, StringLogger log) {
            if (this.applicable(phase)) {
                log.logLongMessage(this.message, new Visitor<StringLogger.LineLogger, RuntimeException>(){

                    @Override
                    public boolean visit(StringLogger.LineLogger logger) {
                        Diagnostics.this.dump(source, logger);
                        return false;
                    }
                }, true);
            }
        }

        boolean applicable(DiagnosticsPhase phase) {
            return phase.isInitialization() || phase.isExplicitlyRequested();
        }

        abstract void dump(NeoStoreXaDataSource var1, StringLogger.LineLogger var2);
    }

    public static abstract class Configuration
    extends LogBackedXaDataSource.Configuration {
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<File> store_dir = InternalAbstractGraphDatabase.Configuration.store_dir;
        public static final Setting<File> neo_store = InternalAbstractGraphDatabase.Configuration.neo_store;
        public static final Setting<File> logical_log = InternalAbstractGraphDatabase.Configuration.logical_log;
    }
}

