/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyChainVerifier;

class NoDuplicatesPropertyChainVerifier
implements PropertyChainVerifier {
    private final List<PropertyChainVerifier.Observer> observers = new ArrayList<PropertyChainVerifier.Observer>(1);

    NoDuplicatesPropertyChainVerifier() {
    }

    @Override
    public void verifySortedPropertyChain(DefinedProperty[] propertyChain, Primitive entity) {
        if (this.containsDuplicates(propertyChain)) {
            for (PropertyChainVerifier.Observer observer : this.observers) {
                observer.inconsistencyFound(entity);
            }
        }
    }

    @Override
    public void addObserver(PropertyChainVerifier.Observer o) {
        this.observers.add(o);
    }

    private boolean containsDuplicates(DefinedProperty[] propertyChain) {
        boolean foundDuplicates = false;
        int previousKeyId = -1;
        for (DefinedProperty property : propertyChain) {
            int keyId = property.propertyKeyId();
            if (keyId == previousKeyId) {
                foundDuplicates = true;
            }
            previousKeyId = keyId;
        }
        return foundDuplicates;
    }
}

