/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

public abstract class PollingExecutionMonitor
implements ExecutionMonitor {
    private final long interval;

    public PollingExecutionMonitor(long interval) {
        this.interval = interval;
    }

    @Override
    public void monitor(StageExecution ... executions) {
        long startTime = System.currentTimeMillis();
        this.start(executions);
        while (this.anyStillExecuting(executions)) {
            this.poll(executions);
            this.finishAwareSleep(executions);
        }
        this.end(executions, System.currentTimeMillis() - startTime);
    }

    private boolean anyStillExecuting(StageExecution[] executions) {
        for (StageExecution execution : executions) {
            if (!execution.stillExecuting()) continue;
            return true;
        }
        return false;
    }

    protected void end(StageExecution[] executions, long totalTimeMillis) {
    }

    protected void start(StageExecution[] executions) {
    }

    protected abstract void poll(StageExecution[] var1);

    private void finishAwareSleep(StageExecution[] executions) {
        long endTime = System.currentTimeMillis() + this.interval;
        while (System.currentTimeMillis() < endTime && this.anyStillExecuting(executions)) {
            try {
                Thread.sleep(Math.min(10L, Math.max(0L, endTime - System.currentTimeMillis())));
            }
            catch (InterruptedException e) {
                for (StageExecution execution : executions) {
                    execution.panic(e);
                }
            }
        }
    }
}

