/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.staging.PollingExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public class DetailedExecutionMonitor
extends PollingExecutionMonitor {
    private final PrintStream out;

    public DetailedExecutionMonitor(PrintStream out) {
        super(TimeUnit.SECONDS.toMillis(2L));
        this.out = out;
    }

    public DetailedExecutionMonitor() {
        this(System.out);
    }

    @Override
    protected void start(StageExecution[] executions) {
        StringBuilder names = new StringBuilder();
        for (StageExecution execution : executions) {
            names.append(names.length() > 0 ? ", " : "").append(execution.getStageName());
        }
        this.out.println(String.format("%n>>>>> EXECUTING STAGE(s) %s <<<<<%n", names));
    }

    @Override
    protected void end(StageExecution[] executions, long totalTimeMillis) {
        this.out.println("Stage total time " + Format.duration(totalTimeMillis));
    }

    @Override
    protected void poll(StageExecution[] executions) {
        boolean first = true;
        for (StageExecution execution : executions) {
            this.printStats(execution, first);
            first = false;
        }
    }

    @Override
    public void done(long totalTimeMillis) {
        this.out.println("IMPORT DONE. Took: " + Format.duration(totalTimeMillis));
    }

    private void printStats(StageExecution execution, boolean first) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (StepStats stats : execution.stats()) {
            builder.append(i > 0 ? String.format("%n  ", new Object[0]) : (first ? "--" : " -")).append(stats.toString());
            ++i;
        }
        String toPrint = builder.toString();
        this.printAndBackUpAgain(toPrint);
    }

    private void printAndBackUpAgain(String toPrint) {
        this.out.println(toPrint);
    }
}

