/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipStore;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.EntityStoreUpdaterStep;
import org.neo4j.unsafe.impl.batchimport.NodeEncoderStep;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipEncoderStep;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStep;
import org.neo4j.unsafe.impl.batchimport.cache.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.LongArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLink;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipLinkImpl;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.IteratorBatcherStep;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStore;
import org.neo4j.unsafe.impl.batchimport.store.BatchingWindowPoolFactory;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final String storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final IoMonitor writeMonitor;
    private final ExecutionMonitor executionMonitor;
    private final Logging logging;
    private final StringLogger logger;
    private final LifeSupport life = new LifeSupport();
    private final BatchingWindowPoolFactory.WriterFactory writerFactory;

    public ParallelBatchImporter(String storeDir, FileSystemAbstraction fileSystem, Configuration config, Logging logging, ExecutionMonitor executionMonitor, BatchingWindowPoolFactory.WriterFactory writerFactory) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logging = logging;
        this.logger = logging.getMessagesLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.writeMonitor = new IoMonitor();
        this.writerFactory = writerFactory;
        this.life.start();
    }

    public ParallelBatchImporter(String storeDir, FileSystemAbstraction fileSystem, Configuration config, Logging logging, ExecutionMonitor executionMonitor) {
        this(storeDir, fileSystem, config, logging, executionMonitor, BatchingWindowPoolFactory.SYNCHRONOUS);
    }

    @Override
    public void doImport(Iterable<InputNode> nodes, Iterable<InputRelationship> relationships, IdMapper idMapper) throws IOException {
        long startTime = System.currentTimeMillis();
        try (BatchingNeoStore neoStore = new BatchingNeoStore(this.fileSystem, this.storeDir, this.config, this.writeMonitor, this.logging, this.writerFactory);){
            NodeStage nodeStage = new NodeStage(idMapper.wrapNodes(nodes.iterator()), neoStore);
            NodeRelationshipLinkImpl nodeRelationshipLink = new NodeRelationshipLinkImpl(LongArrayFactory.AUTO, this.config.denseNodeThreshold());
            CalculateDenseNodesStage calculateDenseNodesStage = new CalculateDenseNodesStage(relationships.iterator(), nodeRelationshipLink);
            this.executeStages(nodeStage, calculateDenseNodesStage);
            this.executeStages(new RelationshipStage(idMapper.wrapRelationships(relationships.iterator()), neoStore, nodeRelationshipLink));
            this.writerFactory.awaitEverythingWritten();
            neoStore.switchToUpdateMode();
            this.executeStages(new NodeFirstRelationshipStage(neoStore, nodeRelationshipLink));
            nodeRelationshipLink.clearRelationships();
            this.executeStages(new RelationshipLinkbackStage(neoStore, nodeRelationshipLink));
            this.executionMonitor.done(System.currentTimeMillis() - startTime);
        }
        catch (Throwable t) {
            this.logger.error("Error during import", t);
            throw Exceptions.launderedException(IOException.class, t);
        }
        finally {
            this.writerFactory.shutdown();
        }
        this.logger.info("Import completed");
    }

    private synchronized void executeStages(Stage ... stages) throws Exception {
        StageExecution[] executions = new StageExecution[stages.length];
        for (int i = 0; i < stages.length; ++i) {
            executions[i] = stages[i].execute();
        }
        this.executionMonitor.monitor(executions);
    }

    @Override
    public void shutdown() {
        this.logger.debug("Importer shutting down");
        this.life.shutdown();
        this.logger.info("Importer shut down.");
    }

    public class RelationshipLinkbackStage
    extends Stage {
        public RelationshipLinkbackStage(BatchingNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super(ParallelBatchImporter.this.logging, "Relationship back link", ParallelBatchImporter.this.config);
            this.input(new RelationshipLinkbackStep(this.control(), ParallelBatchImporter.this.config.batchSize(), neoStore.getRelationshipStore(), nodeRelationshipLink));
        }
    }

    public class NodeFirstRelationshipStage
    extends Stage {
        public NodeFirstRelationshipStage(BatchingNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super(ParallelBatchImporter.this.logging, "Node first rel", ParallelBatchImporter.this.config);
            this.input(new NodeFirstRelationshipStep(this.control(), ParallelBatchImporter.this.config.batchSize(), neoStore.getNodeStore(), neoStore.getRelationshipGroupStore(), nodeRelationshipLink));
        }
    }

    public class RelationshipStage
    extends Stage {
        public RelationshipStage(Iterator<InputRelationship> input, BatchingNeoStore neoStore, NodeRelationshipLink nodeRelationshipLink) {
            super(ParallelBatchImporter.this.logging, "Relationships", ParallelBatchImporter.this.config);
            this.input(new IteratorBatcherStep<InputRelationship>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), input));
            RelationshipStore relationshipStore = neoStore.getRelationshipStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new RelationshipEncoderStep(this.control(), "ENCODER", ParallelBatchImporter.this.config.workAheadSize(), 1, neoStore.getPropertyKeyRepository(), neoStore.getRelationshipTypeRepository(), relationshipStore, propertyStore, nodeRelationshipLink));
            this.add(new EntityStoreUpdaterStep<RelationshipRecord>(this.control(), "WRITER", relationshipStore, propertyStore, ParallelBatchImporter.this.writeMonitor));
        }
    }

    public class CalculateDenseNodesStage
    extends Stage {
        public CalculateDenseNodesStage(Iterator<InputRelationship> input, NodeRelationshipLink nodeRelationshipLink) {
            super(ParallelBatchImporter.this.logging, "Calculate dense nodes", ParallelBatchImporter.this.config);
            this.input(new IteratorBatcherStep<InputRelationship>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), input));
            this.add(new CalculateDenseNodesStep(this.control(), ParallelBatchImporter.this.config.workAheadSize(), nodeRelationshipLink, ParallelBatchImporter.this.logger));
        }
    }

    public class NodeStage
    extends Stage {
        public NodeStage(Iterator<InputNode> input, BatchingNeoStore neoStore) {
            super(ParallelBatchImporter.this.logging, "Nodes", ParallelBatchImporter.this.config);
            this.input(new IteratorBatcherStep<InputNode>(this.control(), "INPUT", ParallelBatchImporter.this.config.batchSize(), input));
            NodeStore nodeStore = neoStore.getNodeStore();
            PropertyStore propertyStore = neoStore.getPropertyStore();
            this.add(new NodeEncoderStep(this.control(), "ENCODER", ParallelBatchImporter.this.config.workAheadSize(), 1, neoStore.getPropertyKeyRepository(), neoStore.getLabelRepository(), nodeStore, propertyStore));
            this.add(new EntityStoreUpdaterStep<NodeRecord>(this.control(), "WRITER", nodeStore, propertyStore, ParallelBatchImporter.this.writeMonitor));
        }
    }
}

