/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.LogReader;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryReader;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;

public class RecoveryLogDeserializer
implements LogReader<StoreChannel> {
    private final LogEntryReader logEntryReader;

    public RecoveryLogDeserializer(ByteBuffer scratch, XaCommandReaderFactory commandReaderFactory) {
        this.logEntryReader = new VersionAwareLogEntryReader(scratch, commandReaderFactory);
    }

    @Override
    public Cursor<LogEntry, IOException> cursor(StoreChannel channel) {
        return new RecoveryCursor(channel);
    }

    private class RecoveryCursor
    implements Cursor<LogEntry, IOException> {
        private final StoreChannel channel;

        private RecoveryCursor(StoreChannel channel) {
            this.channel = channel;
        }

        @Override
        public boolean next(Consumer<LogEntry, IOException> consumer) throws IOException {
            long position = this.channel.position();
            LogEntry entry = RecoveryLogDeserializer.this.logEntryReader.readLogEntry(this.channel);
            if (entry instanceof LogEntry.Start) {
                ((LogEntry.Start)entry).setStartPosition(position);
            } else if (entry == null) {
                return false;
            }
            consumer.accept(entry);
            return true;
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

