/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import org.neo4j.kernel.impl.nioneo.store.PrimitiveRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;

public class RelationshipRecord
extends PrimitiveRecord {
    private long firstNode;
    private long secondNode;
    private int type;
    private long firstPrevRel = 1L;
    private long firstNextRel = Record.NO_NEXT_RELATIONSHIP.intValue();
    private long secondPrevRel = 1L;
    private long secondNextRel = Record.NO_NEXT_RELATIONSHIP.intValue();
    private boolean firstInFirstChain = true;
    private boolean firstInSecondChain = true;

    public RelationshipRecord(long id, long firstNode, long secondNode, int type) {
        this(id);
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.type = type;
    }

    public RelationshipRecord(long id) {
        super(id, Record.NO_NEXT_PROPERTY.intValue());
    }

    public void setLinks(long firstNode, long secondNode, int type) {
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.type = type;
    }

    public long getFirstNode() {
        return this.firstNode;
    }

    public void setFirstNode(long firstNode) {
        this.firstNode = firstNode;
    }

    public long getSecondNode() {
        return this.secondNode;
    }

    public void setSecondNode(long secondNode) {
        this.secondNode = secondNode;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getFirstPrevRel() {
        return this.firstPrevRel;
    }

    public void setFirstPrevRel(long firstPrevRel) {
        this.firstPrevRel = firstPrevRel;
    }

    public long getFirstNextRel() {
        return this.firstNextRel;
    }

    public void setFirstNextRel(long firstNextRel) {
        this.firstNextRel = firstNextRel;
    }

    public long getSecondPrevRel() {
        return this.secondPrevRel;
    }

    public void setSecondPrevRel(long secondPrevRel) {
        this.secondPrevRel = secondPrevRel;
    }

    public long getSecondNextRel() {
        return this.secondNextRel;
    }

    public void setSecondNextRel(long secondNextRel) {
        this.secondNextRel = secondNextRel;
    }

    public boolean isFirstInFirstChain() {
        return this.firstInFirstChain;
    }

    public void setFirstInFirstChain(boolean firstInFirstChain) {
        this.firstInFirstChain = firstInFirstChain;
    }

    public boolean isFirstInSecondChain() {
        return this.firstInSecondChain;
    }

    public void setFirstInSecondChain(boolean firstInSecondChain) {
        this.firstInSecondChain = firstInSecondChain;
    }

    public String toString() {
        return "Relationship[" + this.getId() + ",used=" + this.inUse() + ",source=" + this.firstNode + ",target=" + this.secondNode + ",type=" + this.type + (this.firstInFirstChain ? ",sCount=" : ",sPrev=") + this.firstPrevRel + ",sNext=" + this.firstNextRel + (this.firstInSecondChain ? ",tCount=" : ",tPrev=") + this.secondPrevRel + ",tNext=" + this.secondNextRel + ",prop=" + this.getNextProp() + (this.firstInFirstChain ? ", sFirst" : ",!sFirst") + (this.firstInSecondChain ? ", tFirst" : ",!tFirst") + "]";
    }

    @Override
    public void setIdTo(PropertyRecord property) {
        property.setRelId(this.getId());
    }
}

