/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.SystemException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.PropertyTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.AutoLoadingCache;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.DenseNodeImpl;
import org.neo4j.kernel.impl.core.EntityFactory;
import org.neo4j.kernel.impl.core.GraphPropertiesImpl;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipLoader;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.locking.AcquireLockTimeoutException;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class NodeManager
implements Lifecycle,
EntityFactory {
    private final StringLogger logger;
    private final GraphDatabaseService graphDbService;
    private final AutoLoadingCache<NodeImpl> nodeCache;
    private final AutoLoadingCache<RelationshipImpl> relCache;
    private final CacheProvider cacheProvider;
    private final LockService locks;
    private final AbstractTransactionManager transactionManager;
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relTypeHolder;
    private final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private final XaDataSourceManager xaDsm;
    private final ThreadToStatementContextBridge statementCtxProvider;
    private final NodeProxy.NodeLookup nodeLookup;
    private final RelationshipProxy.RelationshipLookups relationshipLookups;
    private final RelationshipLoader relationshipLoader;
    private final List<PropertyTracker<Node>> nodePropertyTrackers;
    private final List<PropertyTracker<Relationship>> relationshipPropertyTrackers;
    private GraphPropertiesImpl graphProperties;
    private final AutoLoadingCache.Loader<NodeImpl> nodeLoader = new AutoLoadingCache.Loader<NodeImpl>(){

        @Override
        public NodeImpl loadById(long id) {
            NodeRecord record = NodeManager.this.persistenceManager.loadLightNode(id);
            if (record == null) {
                return null;
            }
            return record.isCommittedDense() ? new DenseNodeImpl(id) : new NodeImpl(id);
        }
    };
    private final AutoLoadingCache.Loader<RelationshipImpl> relLoader = new AutoLoadingCache.Loader<RelationshipImpl>(){

        @Override
        public RelationshipImpl loadById(long id) {
            RelationshipRecord data = NodeManager.this.persistenceManager.loadLightRelationship(id);
            if (data == null) {
                return null;
            }
            int typeId = data.getType();
            long startNodeId = data.getFirstNode();
            long endNodeId = data.getSecondNode();
            return new RelationshipImpl(id, startNodeId, endNodeId, typeId, false);
        }
    };

    public NodeManager(StringLogger logger, GraphDatabaseService graphDb, LockService locks, AbstractTransactionManager transactionManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, RelationshipTypeTokenHolder relationshipTypeTokenHolder, CacheProvider cacheProvider, PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache, XaDataSourceManager xaDsm, ThreadToStatementContextBridge statementCtxProvider) {
        this.logger = logger;
        this.graphDbService = graphDb;
        this.locks = locks;
        this.transactionManager = transactionManager;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.labelTokenHolder = labelTokenHolder;
        this.nodeLookup = nodeLookup;
        this.relationshipLookups = relationshipLookups;
        this.relTypeHolder = relationshipTypeTokenHolder;
        this.cacheProvider = cacheProvider;
        this.statementCtxProvider = statementCtxProvider;
        this.nodeCache = new AutoLoadingCache<NodeImpl>(nodeCache, this.nodeLoader);
        this.relCache = new AutoLoadingCache<RelationshipImpl>(relCache, this.relLoader);
        this.xaDsm = xaDsm;
        this.nodePropertyTrackers = new LinkedList<PropertyTracker<Node>>();
        this.relationshipPropertyTrackers = new LinkedList<PropertyTracker<Relationship>>();
        this.relationshipLoader = new RelationshipLoader(persistenceManager, relCache);
        this.graphProperties = this.instantiateGraphProperties();
    }

    public GraphDatabaseService getGraphDbService() {
        return this.graphDbService;
    }

    public CacheProvider getCacheType() {
        return this.cacheProvider;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
        for (XaDataSource ds : this.xaDsm.getAllRegisteredDataSources()) {
            if (!ds.getName().equals("nioneodb")) continue;
            NeoStore neoStore = ((NeoStoreXaDataSource)ds).getNeoStore();
            PropertyKeyTokenStore propTokens = neoStore.getPropertyKeyTokenStore();
            LabelTokenStore labelTokens = neoStore.getLabelTokenStore();
            RelationshipTypeTokenStore relTokens = neoStore.getRelationshipTypeStore();
            this.addRawRelationshipTypes(relTokens.getTokens(Integer.MAX_VALUE));
            this.addPropertyKeyTokens(propTokens.getTokens(Integer.MAX_VALUE));
            this.addLabelTokens(labelTokens.getTokens(Integer.MAX_VALUE));
        }
    }

    @Override
    public void stop() {
        this.clearCache();
    }

    @Override
    public void shutdown() {
        this.nodeCache.printStatistics();
        this.relCache.printStatistics();
        this.nodeCache.clear();
        this.relCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createNode() throws AcquireLockTimeoutException {
        long id = this.idGenerator.nextId(Node.class);
        NodeImpl node = new NodeImpl(id, true);
        TransactionState transactionState = this.getTransactionState();
        transactionState.locks().acquireExclusive(ResourceTypes.NODE, id);
        boolean success = false;
        try {
            this.persistenceManager.nodeCreate(id);
            transactionState.createNode(id);
            this.nodeCache.put(node);
            success = true;
            long l = id;
            return l;
        }
        finally {
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    @Override
    public NodeProxy newNodeProxyById(long id) {
        return new NodeProxy(id, this.nodeLookup, this.relationshipLookups, this.statementCtxProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, long relationshipTypeId) {
        if (startNode == null || endNode == null || relationshipTypeId > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Bad parameter, startNode=" + startNode + ", endNode=" + endNode + ", typeId=" + relationshipTypeId);
        }
        int typeId = (int)relationshipTypeId;
        long startNodeId = startNode.getId();
        long endNodeId = endNode.getId();
        NodeImpl secondNode = this.getLightNode(endNodeId);
        if (secondNode == null) {
            this.setRollbackOnly();
            throw new NotFoundException("Second node[" + endNode.getId() + "] deleted");
        }
        long id = this.idGenerator.nextId(Relationship.class);
        RelationshipImpl rel = new RelationshipImpl(id, startNodeId, endNodeId, typeId, true);
        TransactionState tx = this.getTransactionState();
        tx.locks().acquireExclusive(ResourceTypes.RELATIONSHIP, id);
        boolean success = false;
        try {
            tx.createRelationship(id);
            if (startNodeId == endNodeId) {
                tx.getOrCreateCowRelationshipAddMap(startNode, typeId).add(id, RelIdArray.DirectionWrapper.BOTH);
            } else {
                tx.getOrCreateCowRelationshipAddMap(startNode, typeId).add(id, RelIdArray.DirectionWrapper.OUTGOING);
                tx.getOrCreateCowRelationshipAddMap(secondNode, typeId).add(id, RelIdArray.DirectionWrapper.INCOMING);
            }
            this.relCache.put(rel);
            success = true;
            long l = id;
            return l;
        }
        finally {
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    public Node getNodeByIdOrNull(long nodeId) {
        this.transactionManager.assertInTransaction();
        NodeImpl node = this.getLightNode(nodeId);
        return node != null ? new NodeProxy(nodeId, this.nodeLookup, this.relationshipLookups, this.statementCtxProvider) : null;
    }

    public Node getNodeById(long nodeId) throws NotFoundException {
        Node node = this.getNodeByIdOrNull(nodeId);
        if (node == null) {
            throw new NotFoundException(String.format("Node %d not found", nodeId));
        }
        return node;
    }

    NodeImpl getLightNode(long nodeId) {
        return this.nodeCache.get(nodeId);
    }

    @Override
    public RelationshipProxy newRelationshipProxyById(long id) {
        return new RelationshipProxy(id, this.relationshipLookups, this.statementCtxProvider);
    }

    public Iterator<Node> getAllNodes() {
        PrefetchingIterator<Node> committedNodes = new PrefetchingIterator<Node>(){
            private long highId;
            private long currentId;
            {
                this.highId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            protected Node fetchNextOrNull() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            node = NodeManager.this.getNodeByIdOrNull(this.currentId);
                            if (node == null) ** GOTO lbl-1000
                            var2_3 = node;
                            return var2_3;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return null;
            }
        };
        final TransactionState txState = this.getTransactionState();
        if (!txState.hasChanges()) {
            return committedNodes;
        }
        final HashSet<Long> createdNodes = new HashSet<Long>(txState.getCreatedNodes());
        if (!createdNodes.isEmpty()) {
            committedNodes = new FilteringIterator<Node>(committedNodes, new Predicate<Node>(){

                @Override
                public boolean accept(Node node) {
                    return !createdNodes.contains(node.getId());
                }
            });
        }
        FilteringIterator<Node> filteredRemovedNodes = new FilteringIterator<Node>(committedNodes, new Predicate<Node>(){

            @Override
            public boolean accept(Node node) {
                return !txState.nodeIsDeleted(node.getId());
            }
        });
        return new CombiningIterator<Node>(Arrays.asList(filteredRemovedNodes, new IteratorWrapper<Node, Long>(createdNodes.iterator()){

            @Override
            protected Node underlyingObjectToObject(Long id) {
                return NodeManager.this.getNodeById(id);
            }
        }));
    }

    public NodeImpl getNodeForProxy(long nodeId) {
        NodeImpl node = this.getLightNode(nodeId);
        if (node == null) {
            throw new NotFoundException(String.format("Node %d not found", nodeId));
        }
        return node;
    }

    protected Relationship getRelationshipByIdOrNull(long relId) {
        this.transactionManager.assertInTransaction();
        RelationshipImpl relationship = this.relCache.get(relId);
        return relationship != null ? new RelationshipProxy(relId, this.relationshipLookups, this.statementCtxProvider) : null;
    }

    public Relationship getRelationshipById(long id) throws NotFoundException {
        Relationship relationship = this.getRelationshipByIdOrNull(id);
        if (relationship == null) {
            throw new NotFoundException(String.format("Relationship %d not found", id));
        }
        return relationship;
    }

    public Iterator<Relationship> getAllRelationships() {
        PrefetchingIterator<Relationship> committedRelationships = new PrefetchingIterator<Relationship>(){
            private long highId;
            private long currentId;
            {
                this.highId = NodeManager.this.getHighestPossibleIdInUse(Relationship.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            protected Relationship fetchNextOrNull() {
                while (true) lbl-1000:
                // 4 sources

                {
                    if (this.currentId <= this.highId) {
                        try {
                            relationship = NodeManager.this.getRelationshipByIdOrNull(this.currentId);
                            if (relationship == null) ** GOTO lbl-1000
                            var2_3 = relationship;
                            return var2_3;
                        }
                        finally {
                            ++this.currentId;
                        }
                        continue;
                    }
                    newHighId = NodeManager.this.getHighestPossibleIdInUse(Node.class);
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return null;
            }
        };
        final TransactionState txState = this.getTransactionState();
        if (!txState.hasChanges()) {
            return committedRelationships;
        }
        final HashSet<Long> createdRelationships = new HashSet<Long>(txState.getCreatedRelationships());
        if (!createdRelationships.isEmpty()) {
            committedRelationships = new FilteringIterator<Relationship>(committedRelationships, new Predicate<Relationship>(){

                @Override
                public boolean accept(Relationship relationship) {
                    return !createdRelationships.contains(relationship.getId());
                }
            });
        }
        FilteringIterator<Relationship> filteredRemovedRelationships = new FilteringIterator<Relationship>(committedRelationships, new Predicate<Relationship>(){

            @Override
            public boolean accept(Relationship relationship) {
                return !txState.relationshipIsDeleted(relationship.getId());
            }
        });
        return new CombiningIterator<Relationship>(Arrays.asList(filteredRemovedRelationships, new IteratorWrapper<Relationship, Long>(createdRelationships.iterator()){

            @Override
            protected Relationship underlyingObjectToObject(Long id) {
                return NodeManager.this.getRelationshipById(id);
            }
        }));
    }

    RelationshipType getRelationshipTypeById(int id) throws TokenNotFoundException {
        return (RelationshipType)this.relTypeHolder.getTokenById(id);
    }

    public RelationshipImpl getRelationshipForProxy(long relId) {
        RelationshipImpl rel = this.relCache.get(relId);
        if (rel == null) {
            throw new NotFoundException(String.format("Relationship %d not found", relId));
        }
        return rel;
    }

    public void removeNodeFromCache(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public void removeRelationshipFromCache(long id) {
        this.relCache.remove(id);
    }

    public void patchDeletedRelationshipNodes(long relId, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNodeNextRelId) {
        this.invalidateNode(firstNodeId, relId, firstNodeNextRelId);
        this.invalidateNode(secondNodeId, relId, secondNodeNextRelId);
    }

    private void invalidateNode(long nodeId, long relIdDeleted, long nextRelId) {
        RelationshipLoadingPosition position;
        NodeImpl node = this.nodeCache.getIfCached(nodeId);
        if (node != null && (position = node.getRelChainPosition()) != null) {
            position.compareAndAdvance(relIdDeleted, nextRelId);
        }
    }

    RelationshipLoadingPosition getRelationshipChainPosition(NodeImpl node) {
        return this.persistenceManager.getRelationshipChainPosition(node.getId());
    }

    void putAllInRelCache(Collection<RelationshipImpl> relationships) {
        this.relCache.putAll((Collection)relationships);
    }

    Iterator<DefinedProperty> loadGraphProperties(boolean light) {
        IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
        this.persistenceManager.graphLoadProperties(light, receiver);
        return receiver;
    }

    Iterator<DefinedProperty> loadProperties(NodeImpl node, boolean light) {
        IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
        this.persistenceManager.loadNodeProperties(node.getId(), light, receiver);
        return receiver;
    }

    Iterator<DefinedProperty> loadProperties(RelationshipImpl relationship, boolean light) {
        IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
        this.persistenceManager.loadRelProperties(relationship.getId(), light, receiver);
        return receiver;
    }

    public void clearCache() {
        this.nodeCache.clear();
        this.relCache.clear();
        this.graphProperties = this.instantiateGraphProperties();
    }

    public Iterable<? extends Cache<?>> caches() {
        return Arrays.asList(this.nodeCache, this.relCache);
    }

    public void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            this.logger.debug("Failed to set transaction rollback only", e);
        }
        catch (SystemException se) {
            this.logger.error("Failed to set transaction rollback only", se);
        }
    }

    public <T extends PropertyContainer> T indexPutIfAbsent(Index<T> index, T entity, String key, Object value) {
        PropertyContainer existing = (PropertyContainer)index.get(key, value).getSingle();
        if (existing != null) {
            return (T)existing;
        }
        try (Statement statement = this.statementCtxProvider.instance();){
            statement.readOperations().acquireExclusive(ResourceTypes.LEGACY_INDEX, ResourceTypes.legacyIndexResourceId(index.getName(), key));
            existing = (PropertyContainer)index.get(key, value).getSingle();
            if (existing != null) {
                statement.readOperations().releaseExclusive(ResourceTypes.LEGACY_INDEX, ResourceTypes.legacyIndexResourceId(index.getName(), key));
                PropertyContainer propertyContainer = existing;
                return (T)propertyContainer;
            }
            index.add(entity, key, value);
            T t = null;
            return t;
        }
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.idGenerator.getHighestPossibleIdInUse(clazz);
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.idGenerator.getNumberOfIdsInUse(clazz);
    }

    public void removeRelationshipTypeFromCache(int id) {
        this.relTypeHolder.removeToken(id);
    }

    public void removeLabelFromCache(int id) {
        this.labelTokenHolder.removeToken(id);
    }

    public void removePropertyKeyFromCache(int id) {
        this.propertyKeyTokenHolder.removeToken(id);
    }

    void addPropertyKeyTokens(Token[] propertyKeyTokens) {
        this.propertyKeyTokenHolder.addTokens(propertyKeyTokens);
    }

    void addLabelTokens(Token[] labelTokens) {
        this.labelTokenHolder.addTokens(labelTokens);
    }

    Token getPropertyKeyTokenOrNull(String key) {
        return this.propertyKeyTokenHolder.getTokenByNameOrNull(key);
    }

    int getRelationshipTypeIdFor(RelationshipType type) {
        return this.relTypeHolder.getIdByName(type.name());
    }

    void addRawRelationshipTypes(Token[] relTypes) {
        this.relTypeHolder.addTokens(relTypes);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return Iterables.cast(this.relTypeHolder.getAllTokens());
    }

    public ArrayMap<Integer, DefinedProperty> deleteNode(NodeImpl node, TransactionState tx) {
        tx.deleteNode(node.getId());
        return this.persistenceManager.nodeDelete(node.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayMap<Integer, DefinedProperty> deleteRelationship(RelationshipImpl rel, TransactionState tx) {
        boolean success = false;
        try {
            boolean loop;
            long endNodeId;
            NodeImpl endNode;
            long startNodeId = rel.getStartNodeId();
            NodeImpl startNode = this.getLightNode(startNodeId);
            if (startNode != null) {
                tx.locks().acquireExclusive(ResourceTypes.NODE, startNodeId);
            }
            if ((endNode = this.getLightNode(endNodeId = rel.getEndNodeId())) != null) {
                tx.locks().acquireExclusive(ResourceTypes.NODE, endNodeId);
            }
            tx.locks().acquireExclusive(ResourceTypes.RELATIONSHIP, rel.getId());
            ArrayMap<Integer, DefinedProperty> skipMap = tx.getOrCreateCowPropertyRemoveMap(rel);
            tx.deleteRelationship(rel.getId());
            ArrayMap<Integer, DefinedProperty> removedProps = this.persistenceManager.relDelete(rel.getId());
            if (removedProps.size() > 0) {
                for (int index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            int typeId = rel.getTypeId();
            long id = rel.getId();
            boolean bl = loop = startNodeId == endNodeId;
            if (startNode != null) {
                tx.getOrCreateCowRelationshipRemoveMap(startNode, typeId).add(id, loop ? Direction.BOTH : Direction.OUTGOING);
            }
            if (endNode != null && !loop) {
                tx.getOrCreateCowRelationshipRemoveMap(endNode, typeId).add(id, Direction.INCOMING);
            }
            success = true;
            ArrayMap<Integer, DefinedProperty> arrayMap = removedProps;
            return arrayMap;
        }
        finally {
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    Triplet<ArrayMap<Integer, RelIdArray>, List<RelationshipImpl>, RelationshipLoadingPosition> getMoreRelationships(NodeImpl node, RelIdArray.DirectionWrapper direction, int[] types) {
        return this.relationshipLoader.getMoreRelationships(node, direction, types);
    }

    public NodeImpl getNodeIfCached(long nodeId) {
        return this.nodeCache.getIfCached(nodeId);
    }

    public RelationshipImpl getRelIfCached(long nodeId) {
        return this.relCache.getIfCached(nodeId);
    }

    public void addRelationshipTypeToken(Token type) {
        this.relTypeHolder.addTokens(type);
    }

    public void addLabelToken(Token type) {
        this.labelTokenHolder.addTokens(type);
    }

    public void addPropertyKeyToken(Token index) {
        this.propertyKeyTokenHolder.addTokens(index);
    }

    public String getKeyForProperty(DefinedProperty property) {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(property.propertyKeyId())).name();
        }
        catch (TokenNotFoundException e) {
            throw new ThisShouldNotHappenError("Mattias", "The key should exist at this point");
        }
    }

    public List<PropertyTracker<Node>> getNodePropertyTrackers() {
        return this.nodePropertyTrackers;
    }

    public List<PropertyTracker<Relationship>> getRelationshipPropertyTrackers() {
        return this.relationshipPropertyTrackers;
    }

    public void addNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.add(nodePropertyTracker);
    }

    public void removeNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.remove(nodePropertyTracker);
    }

    public void addRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.add(relationshipPropertyTracker);
    }

    public void removeRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.remove(relationshipPropertyTracker);
    }

    public boolean isDeleted(PropertyContainer entity) {
        if (entity instanceof Node) {
            return this.isDeleted((Node)entity);
        }
        if (entity instanceof Relationship) {
            return this.isDeleted((Relationship)entity);
        }
        throw new IllegalArgumentException("Unknown entity type: " + entity + ", " + entity.getClass());
    }

    public boolean isDeleted(Node resource) {
        return this.getTransactionState().nodeIsDeleted(resource.getId());
    }

    public boolean isDeleted(Relationship resource) {
        return this.getTransactionState().relationshipIsDeleted(resource.getId());
    }

    private GraphPropertiesImpl instantiateGraphProperties() {
        return new GraphPropertiesImpl(this, this.statementCtxProvider);
    }

    public GraphPropertiesImpl getGraphProperties() {
        return this.graphProperties;
    }

    public void removeGraphPropertiesFromCache() {
        this.graphProperties = this.instantiateGraphProperties();
    }

    void updateCacheSize(NodeImpl node, int newSize) {
        this.nodeCache.updateSize(node, newSize);
    }

    void updateCacheSize(RelationshipImpl rel, int newSize) {
        this.relCache.updateSize(rel, newSize);
    }

    public TransactionState getTransactionState() {
        return this.transactionManager.getTransactionState();
    }

    public int getRelationshipCount(NodeImpl nodeImpl, int type, RelIdArray.DirectionWrapper direction) {
        return this.persistenceManager.getRelationshipCount(nodeImpl.getId(), type, direction);
    }

    public Iterator<Integer> getRelationshipTypes(DenseNodeImpl node) {
        return Arrays.asList(this.persistenceManager.getRelationshipTypes(node.getId())).iterator();
    }

    public Lock lowLevelNodeReadLock(long nodeId) {
        return this.locks.acquireNodeLock(nodeId, LockService.LockType.READ_LOCK);
    }
}

