/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.state.NodeState;
import org.neo4j.kernel.impl.api.state.RelationshipState;
import org.neo4j.kernel.impl.util.DiffSets;

public interface TxState {
    public boolean hasChanges();

    public void accept(Visitor var1);

    public long relationshipDoCreate(int var1, long var2, long var4);

    public long nodeDoCreate();

    public DiffSets<Long> labelStateNodeDiffSets(int var1);

    public DiffSets<Integer> nodeStateLabelDiffSets(long var1);

    public Iterator<DefinedProperty> augmentNodeProperties(long var1, Iterator<DefinedProperty> var3);

    public Iterator<DefinedProperty> augmentRelProperties(long var1, Iterator<DefinedProperty> var3);

    public Iterator<DefinedProperty> augmentGraphProperties(Iterator<DefinedProperty> var1);

    public Iterator<DefinedProperty> addedAndChangedNodeProperties(long var1);

    public Iterator<DefinedProperty> addedAndChangedRelProperties(long var1);

    public Set<Long> nodesWithLabelAdded(int var1);

    public DiffSets<Long> nodesWithLabelChanged(int var1);

    public DiffSets<Long> addedAndRemovedNodes();

    public DiffSets<Long> addedAndRemovedRels();

    public Iterable<NodeState> modifiedNodes();

    public Iterable<RelationshipState> modifiedRelationships();

    public boolean nodeIsAddedInThisTx(long var1);

    public boolean nodeIsDeletedInThisTx(long var1);

    public boolean nodeModifiedInThisTx(long var1);

    public DiffSets<Long> nodesWithChangedProperty(int var1, Object var2);

    public boolean relationshipIsAddedInThisTx(long var1);

    public boolean relationshipIsDeletedInThisTx(long var1);

    public UpdateTriState labelState(long var1, int var3);

    public void relationshipDoDelete(long var1, long var3, long var5, int var7);

    public void relationshipDoDeleteAddedInThisTx(long var1);

    public void nodeDoDelete(long var1);

    public void nodeDoReplaceProperty(long var1, Property var3, DefinedProperty var4);

    public void relationshipDoReplaceProperty(long var1, Property var3, DefinedProperty var4);

    public void graphDoReplaceProperty(Property var1, DefinedProperty var2);

    public void nodeDoRemoveProperty(long var1, DefinedProperty var3);

    public void relationshipDoRemoveProperty(long var1, DefinedProperty var3);

    public void graphDoRemoveProperty(DefinedProperty var1);

    public void nodeDoAddLabel(int var1, long var2);

    public void nodeDoRemoveLabel(int var1, long var2);

    public PrimitiveLongIterator augmentRelationships(long var1, Direction var3, PrimitiveLongIterator var4);

    public PrimitiveLongIterator augmentRelationships(long var1, Direction var3, int[] var4, PrimitiveLongIterator var5);

    public int augmentNodeDegree(long var1, int var3, Direction var4);

    public int augmentNodeDegree(long var1, int var3, Direction var4, int var5);

    public PrimitiveIntIterator nodeRelationshipTypes(long var1);

    public DiffSets<IndexDescriptor> indexDiffSetsByLabel(int var1);

    public DiffSets<IndexDescriptor> constraintIndexDiffSetsByLabel(int var1);

    public DiffSets<IndexDescriptor> indexChanges();

    public DiffSets<IndexDescriptor> constraintIndexChanges();

    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx();

    public DiffSets<UniquenessConstraint> constraintsChanges();

    public DiffSets<UniquenessConstraint> constraintsChangesForLabel(int var1);

    public DiffSets<UniquenessConstraint> constraintsChangesForLabelAndProperty(int var1, int var2);

    public void indexRuleDoAdd(IndexDescriptor var1);

    public void constraintIndexRuleDoAdd(IndexDescriptor var1);

    public void indexDoDrop(IndexDescriptor var1);

    public void constraintIndexDoDrop(IndexDescriptor var1);

    public void constraintDoAdd(UniquenessConstraint var1, long var2);

    public void constraintDoDrop(UniquenessConstraint var1);

    public boolean constraintDoUnRemove(UniquenessConstraint var1);

    public boolean constraintIndexDoUnRemove(IndexDescriptor var1);

    public Long indexCreatedForConstraint(UniquenessConstraint var1);

    public DiffSets<Long> indexUpdates(IndexDescriptor var1, Object var2);

    public void indexUpdateProperty(IndexDescriptor var1, long var2, Object var4, Object var5);

    public static interface Visitor {
        public void visitNodePropertyChanges(long var1, Iterator<DefinedProperty> var3, Iterator<DefinedProperty> var4, Iterator<Integer> var5);

        public void visitRelPropertyChanges(long var1, Iterator<DefinedProperty> var3, Iterator<DefinedProperty> var4, Iterator<Integer> var5);

        public void visitGraphPropertyChanges(Iterator<DefinedProperty> var1, Iterator<DefinedProperty> var2, Iterator<Integer> var3);

        public void visitNodeLabelChanges(long var1, Iterator<Integer> var3, Iterator<Integer> var4);

        public void visitAddedIndex(IndexDescriptor var1, boolean var2);

        public void visitRemovedIndex(IndexDescriptor var1, boolean var2);

        public void visitAddedConstraint(UniquenessConstraint var1);

        public void visitRemovedConstraint(UniquenessConstraint var1);
    }

    public static interface IdGeneration {
        public long newNodeId();

        public long newRelationshipId();
    }

    public static interface Holder {
        public TxState txState();

        public boolean hasTxState();

        public boolean hasTxStateWithChanges();
    }

    public static enum UpdateTriState {
        ADDED{

            @Override
            public boolean isTouched() {
                return true;
            }

            @Override
            public boolean isAdded() {
                return true;
            }
        }
        ,
        REMOVED{

            @Override
            public boolean isTouched() {
                return true;
            }

            @Override
            public boolean isAdded() {
                return false;
            }
        }
        ,
        UNTOUCHED{

            @Override
            public boolean isTouched() {
                return false;
            }

            @Override
            public boolean isAdded() {
                throw new UnsupportedOperationException("Cannot convert an UNTOUCHED UpdateTriState to a boolean");
            }
        };


        public abstract boolean isTouched();

        public abstract boolean isAdded();
    }
}

