/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.TokenRecord;
import org.neo4j.kernel.impl.nioneo.store.TokenStore;
import org.neo4j.kernel.impl.nioneo.xa.TokenCreator;
import org.neo4j.unsafe.impl.batchimport.store.BatchingRecordAccess;

public abstract class BatchingTokenRepository<T extends TokenRecord> {
    private final Map<String, Integer> existing = new HashMap<String, Integer>();
    private final Map<String, Integer> created = new HashMap<String, Integer>();
    private final TokenStore<T> store;
    private int highId;

    public BatchingTokenRepository(TokenStore<T> store) {
        this.store = store;
        this.highId = (int)store.getHighId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateId(String name) {
        assert (name != null);
        Integer id = this.existing.get(name);
        if (id == null) {
            Map<String, Integer> map = this.created;
            synchronized (map) {
                id = this.created.get(name);
                if (id == null) {
                    id = this.highId++;
                    this.created.put(name, id);
                }
            }
        }
        return id;
    }

    protected abstract T createRecord(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        BatchingRecordAccess recordAccess = new BatchingRecordAccess<Integer, T, Void>(){

            @Override
            protected T createRecord(Integer key, Void additionalData) {
                return BatchingTokenRepository.this.createRecord(key);
            }
        };
        TokenCreator<T> creator = new TokenCreator<T>(this.store);
        int highest = 1;
        for (Map.Entry<Integer, String> tokenToCreate : this.sortCreatedTokensById()) {
            creator.createToken(tokenToCreate.getValue(), tokenToCreate.getKey(), recordAccess);
            highest = Math.max(highest, tokenToCreate.getKey());
        }
        this.store.setRecovered();
        try {
            for (TokenRecord record : recordAccess.records()) {
                this.store.updateRecord(record);
            }
            this.store.updateIdGenerators();
        }
        finally {
            this.store.unsetRecovered();
        }
    }

    private Iterable<Map.Entry<Integer, String>> sortCreatedTokensById() {
        TreeMap<Integer, String> sorted = new TreeMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : this.created.entrySet()) {
            sorted.put(entry.getValue(), entry.getKey());
        }
        return sorted.entrySet();
    }

    public static class BatchingRelationshipTypeTokenRepository
    extends BatchingTokenRepository<RelationshipTypeTokenRecord> {
        public BatchingRelationshipTypeTokenRepository(TokenStore<RelationshipTypeTokenRecord> store) {
            super(store);
        }

        @Override
        protected RelationshipTypeTokenRecord createRecord(int key) {
            return new RelationshipTypeTokenRecord(key);
        }
    }

    public static class BatchingLabelTokenRepository
    extends BatchingTokenRepository<LabelTokenRecord> {
        public BatchingLabelTokenRepository(TokenStore<LabelTokenRecord> store) {
            super(store);
        }

        @Override
        protected LabelTokenRecord createRecord(int key) {
            return new LabelTokenRecord(key);
        }
    }

    public static class BatchingPropertyKeyTokenRepository
    extends BatchingTokenRepository<PropertyKeyTokenRecord> {
        public BatchingPropertyKeyTokenRepository(TokenStore<PropertyKeyTokenRecord> store) {
            super(store);
        }

        @Override
        protected PropertyKeyTokenRecord createRecord(int key) {
            return new PropertyKeyTokenRecord(key);
        }
    }
}

