/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.helpers.Exceptions;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.ProcessingStats;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public abstract class AbstractStep<T>
implements Step<T> {
    private final StageControl control;
    private final String name;
    private volatile Step downstream;
    protected volatile boolean endOfUpstream;
    protected final AtomicLong downstreamIdleTime = new AtomicLong();
    protected final AtomicLong upstreamIdleTime = new AtomicLong();
    protected final AtomicLong receivedBatches = new AtomicLong();
    protected final AtomicLong doneBatches = new AtomicLong();
    protected final AtomicLong totalProcessingTime = new AtomicLong();
    private volatile boolean panic;
    private volatile boolean completed;

    public AbstractStep(StageControl control, String name) {
        this.control = control;
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void receivePanic(Throwable cause) {
        this.panic = true;
    }

    protected boolean stillWorking() {
        if (this.panic) {
            return false;
        }
        return !this.endOfUpstream || this.doneBatches.get() != this.receivedBatches.get();
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void issuePanic(Throwable cause) {
        this.control.panic(cause);
        throw Exceptions.launderedException(cause);
    }

    protected long awaitTicket(long ticket) {
        long waitTime = System.currentTimeMillis();
        while (this.receivedBatches.get() != ticket - 1L) {
            this.waitSome();
        }
        return System.currentTimeMillis() - waitTime;
    }

    protected void assertHealthy() {
        if (this.panic) {
            throw new RuntimeException("Panic called, so exiting");
        }
    }

    protected void waitSome() {
        try {
            Thread.sleep(1L);
            Thread.yield();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void ticketReceived(long ticket) {
        if (!this.receivedBatches.compareAndSet(ticket - 1L, ticket)) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setDownstream(Step<?> downstream) {
        this.downstream = downstream;
    }

    @Override
    public StepStats stats() {
        ArrayList<StatsProvider> providers = new ArrayList<StatsProvider>();
        this.addStatsProviders(providers);
        return new StepStats(this.name, this.stillWorking(), providers);
    }

    protected void addStatsProviders(Collection<StatsProvider> providers) {
        providers.add(new ProcessingStats(this.receivedBatches.get(), this.doneBatches.get(), this.totalProcessingTime.get(), this.upstreamIdleTime.get(), this.downstreamIdleTime.get()));
    }

    protected <BATCH> void sendDownstream(long ticket, BATCH batch) {
        if (batch == null) {
            if (this.downstream != null) {
                throw new IllegalArgumentException("Expected a batch to send downstream");
            }
        } else {
            this.downstreamIdleTime.addAndGet(this.downstream.receive(ticket, batch));
        }
        this.checkNotifyEndDownstream();
    }

    @Override
    public void endOfUpstream() {
        this.endOfUpstream = true;
        this.checkNotifyEndDownstream();
    }

    protected void checkNotifyEndDownstream() {
        if (!this.stillWorking() && !this.isCompleted()) {
            this.done();
            if (this.downstream != null) {
                this.downstream.endOfUpstream();
            }
            this.completed = true;
        }
    }

    protected void done() {
    }
}

