/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.Arrays;
import java.util.Collection;
import org.neo4j.helpers.Pair;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

public class InputNode
extends InputEntity {
    private final String[] labels;
    private final Long labelField;

    public InputNode(long id, Object[] properties, Long firstPropertyId, String[] labels, Long labelField) {
        super(id, properties, firstPropertyId);
        this.labels = labels;
        this.labelField = labelField;
    }

    public String[] labels() {
        return this.labels;
    }

    public boolean hasLabelField() {
        return this.labelField != null;
    }

    public Long labelField() {
        return this.labelField;
    }

    @Override
    protected void toStringFields(Collection<Pair<String, ?>> fields) {
        super.toStringFields(fields);
        if (this.hasLabelField()) {
            fields.add(Pair.of("labelField", this.labelField));
        } else {
            fields.add(Pair.of("labels", Arrays.toString(this.labels)));
        }
    }
}

