/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Iterator;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.unsafe.impl.batchimport.cache.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class IdMappers {
    public static IdMapper actualIds() {
        return new ActualIdMapper();
    }

    public static class ActualIdMapper
    implements IdMapper {
        @Override
        public Iterator<InputNode> wrapNodes(Iterator<InputNode> nodes) {
            return new IteratorWrapper<InputNode, InputNode>(nodes){
                private long lastSeenId;
                {
                    this.lastSeenId = -1L;
                }

                @Override
                protected InputNode underlyingObjectToObject(InputNode node) {
                    if (this.lastSeenId != -1L && node.id() < this.lastSeenId) {
                        throw new IllegalArgumentException("Cannot go backwards in node id sequence, last seen was " + this.lastSeenId + ", given id is " + node.id());
                    }
                    this.lastSeenId = node.id();
                    return node;
                }
            };
        }

        @Override
        public Iterator<InputRelationship> wrapRelationships(Iterator<InputRelationship> relationships) {
            return relationships;
        }
    }
}

