/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.rawstorereader;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.DefaultWindowPoolFactory;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.xa.LogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;
import org.neo4j.kernel.impl.util.StringLogger;

public class RsdrMain {
    private static final FileSystemAbstraction files = new DefaultFileSystemAbstraction();
    private static final Console console = System.console();
    private static final Pattern readCommandPattern = Pattern.compile("r((?<lower>\\d+)?,(?<upper>\\d+)?)?\\s+(?<fname>[\\w\\.]+)(\\s*\\|\\s*(?<regex>.+))?");

    public static void main(String[] args) throws IOException {
        console.printf("Neo4j Raw Store Diagnostics Reader%n", new Object[0]);
        if (args.length != 1 || !files.isDirectory(new File(args[0]))) {
            console.printf("Usage: rsdr <storepath>%n", new Object[0]);
            return;
        }
        File storepath = new File(args[0]);
        StoreFactory factory = RsdrMain.openStore();
        NeoStore neoStore = factory.newNeoStore(new File(storepath, "neostore"));
        RsdrMain.interact(neoStore);
    }

    private static StoreFactory openStore() {
        Config config = new Config(MapUtil.stringMap(GraphDatabaseSettings.read_only.name(), "true", GraphDatabaseSettings.use_memory_mapped_buffers.name(), "false"));
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
        DefaultWindowPoolFactory windowPoolFactory = new DefaultWindowPoolFactory();
        StringLogger logger = StringLogger.DEV_NULL;
        StoreFactory factory = new StoreFactory(config, idGeneratorFactory, windowPoolFactory, files, logger, null);
        return factory;
    }

    private static void interact(NeoStore neoStore) throws IOException {
        String cmd;
        RsdrMain.printHelp();
        while (RsdrMain.execute(cmd = console.readLine("neo? ", new Object[0]), neoStore)) {
        }
    }

    private static void printHelp() {
        console.printf("Usage:%n  h            print this message%n  l            list store files in store%n  r f          read all records in store file 'f'%n  r5,10 f      read record 5 through 10 in store file 'f'%n  r f | rx     read records and filter through regex 'rx'%n  q            quit%n", new Object[0]);
    }

    private static boolean execute(String cmd, NeoStore neoStore) throws IOException {
        if (cmd == null || cmd.equals("q")) {
            return false;
        }
        if (cmd.equals("h")) {
            RsdrMain.printHelp();
        } else if (cmd.equals("l")) {
            RsdrMain.listFiles(neoStore);
        } else if (cmd.startsWith("r")) {
            RsdrMain.read(cmd, neoStore);
        } else if (!cmd.trim().isEmpty()) {
            console.printf("unrecognized command%n", new Object[0]);
        }
        return true;
    }

    private static void listFiles(NeoStore neoStore) {
        File[] listing;
        File storedir = neoStore.getStorageFileName().getParentFile();
        for (File file : listing = files.listFiles(storedir)) {
            console.printf("%s%n", file.getName());
        }
    }

    private static void read(String cmd, NeoStore neoStore) throws IOException {
        Matcher matcher = readCommandPattern.matcher(cmd);
        if (matcher.find()) {
            String lower = matcher.group("lower");
            String upper = matcher.group("upper");
            String fname = matcher.group("fname");
            String regex = matcher.group("regex");
            Pattern pattern = regex != null ? Pattern.compile(regex) : null;
            long fromId = lower != null ? Long.parseLong(lower) : 0L;
            long toId = upper != null ? Long.parseLong(upper) : Long.MAX_VALUE;
            RecordStore store = RsdrMain.getStore(fname, neoStore);
            if (store != null) {
                RsdrMain.readStore(store, fromId, toId, pattern);
                return;
            }
            Cursor<LogEntry, IOException> cursor = RsdrMain.getLogCursor(fname, neoStore);
            if (cursor != null) {
                RsdrMain.readLog(cursor, fromId, toId, pattern);
                cursor.close();
                return;
            }
            console.printf("don't know how to read '%s'%n", fname);
        } else {
            console.printf("bad read command format%n", new Object[0]);
        }
    }

    private static void readStore(RecordStore store, long fromId, long toId, Pattern pattern) throws IOException {
        toId = Math.min(toId, store.getHighId());
        try (StoreChannel channel = files.open(store.getStorageFileName(), "r");){
            int recordSize = store.getRecordSize();
            ByteBuffer buf = ByteBuffer.allocate(recordSize);
            for (long i = fromId; i <= toId; ++i) {
                String str;
                String use;
                buf.clear();
                long offset = (long)recordSize * i;
                int count = channel.read(buf, offset);
                byte[] bytes = new byte[count];
                buf.clear();
                buf.get(bytes);
                String hex = DatatypeConverter.printHexBinary((byte[])bytes);
                int paddingNeeded = recordSize * 2 - Math.max(count * 2, 0) + 1;
                String format = "%s %6s 0x%08X %s%" + paddingNeeded + "s%s%n";
                try {
                    Object record = store.getRecord(i);
                    use = ((AbstractBaseRecord)record).inUse() ? "+" : "-";
                    str = record.toString();
                }
                catch (InvalidRecordException e) {
                    str = new String(bytes, 0, count, "ASCII");
                    use = "?";
                }
                if (pattern != null && !pattern.matcher(str).find()) continue;
                console.printf(format, use, i, offset, hex, " ", str);
            }
        }
    }

    private static RecordStore getStore(String fname, NeoStore neoStore) {
        switch (fname) {
            case "neostore.nodestore.db": {
                return neoStore.getNodeStore();
            }
            case "neostore.labeltokenstore.db": {
                return neoStore.getLabelTokenStore();
            }
            case "neostore.propertystore.db.index": {
                return neoStore.getPropertyKeyTokenStore();
            }
            case "neostore.propertystore.db": {
                return neoStore.getPropertyStore();
            }
            case "neostore.relationshipgroupstore.db": {
                return neoStore.getRelationshipGroupStore();
            }
            case "neostore.relationshipstore.db": {
                return neoStore.getRelationshipStore();
            }
            case "neostore.relationshiptypestore.db": {
                return neoStore.getRelationshipTypeStore();
            }
            case "neostore.schemastore.db": {
                return neoStore.getSchemaStore();
            }
        }
        return null;
    }

    private static Cursor<LogEntry, IOException> getLogCursor(String fname, NeoStore neoStore) throws IOException {
        File file = new File(neoStore.getStorageFileName().getParent(), fname);
        StoreChannel fileChannel = files.open(file, "r");
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        long[] header = VersionAwareLogEntryReader.readLogHeader(buffer, fileChannel, false);
        long logVersion = header[0];
        long prevLastCommittedTx = header[1];
        console.printf("Logical log version: %s with prev committed tx[%s]%n", logVersion, prevLastCommittedTx);
        LogDeserializer deserializer = new LogDeserializer(buffer, XaCommandReaderFactory.DEFAULT);
        return deserializer.cursor(fileChannel);
    }

    private static void readLog(Cursor<LogEntry, IOException> cursor, final long fromLine, final long toLine, final Pattern pattern) throws IOException {
        Consumer<LogEntry, IOException> printer = new Consumer<LogEntry, IOException>(){
            long lineCount = -1L;
            TimeZone timeZone = TimeZone.getDefault();

            @Override
            public boolean accept(LogEntry logEntry) throws IOException {
                ++this.lineCount;
                if (this.lineCount > toLine) {
                    return false;
                }
                if (this.lineCount < fromLine) {
                    return true;
                }
                String str = logEntry.toString(this.timeZone);
                if (pattern == null || pattern.matcher(str).find()) {
                    console.printf("%s%n", str);
                }
                return true;
            }
        };
        while (cursor.next(printer)) {
        }
    }
}

