/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.LogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.RecoveryLogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.SlaveLogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.LogFilter;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.nioneo.xa.command.LogReader;
import org.neo4j.kernel.impl.nioneo.xa.command.LogWriter;
import org.neo4j.kernel.impl.nioneo.xa.command.MasterLogWriter;
import org.neo4j.kernel.impl.nioneo.xa.command.PositionCacheLogHandler;
import org.neo4j.kernel.impl.nioneo.xa.command.SlaveLogWriter;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.xaframework.DirectLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.EntryCountingLogHandler;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchLogVersionException;
import org.neo4j.kernel.impl.transaction.xaframework.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.xaframework.NullLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.PartialTransactionCopier;
import org.neo4j.kernel.impl.transaction.xaframework.TranslatingEntryConsumer;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLogFiles;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLogRecoveryCheck;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.BufferedFileChannel;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class XaLogicalLog
implements LogExtractor.LogLoader {
    private final LogFilter masterHandler;
    private final LogFilter slaveHandler;
    private StoreChannel fileChannel = null;
    private final ByteBuffer sharedBuffer;
    private LogBuffer writeBuffer = null;
    private long previousLogLastCommittedTx = -1L;
    private long logVersion = 0L;
    private final ArrayMap<Integer, LogEntry.Start> xidIdentMap = new ArrayMap(4, false, true);
    private final Map<Integer, XaTransaction> recoveredTxMap = new HashMap<Integer, XaTransaction>();
    private int nextIdentifier = 1;
    private boolean scanIsComplete = false;
    private boolean nonCleanShutdown = false;
    private final File fileName;
    private final XaResourceManager xaRm;
    private final XaTransactionFactory xaTf;
    private char currentLog = (char)67;
    private boolean autoRotate;
    private long rotateAtSize;
    private boolean doingRecovery;
    private long lastRecoveredTx = -1L;
    private final StringLogger msgLog;
    private final LogExtractor.LogPositionCache positionCache = new LogExtractor.LogPositionCache();
    private final FileSystemAbstraction fileSystem;
    private final LogPruneStrategy pruneStrategy;
    private final XaLogicalLogFiles logFiles;
    private final PartialTransactionCopier partialTransactionCopier;
    private final InjectedTransactionValidator injectedTxValidator;
    private final TransactionStateFactory stateFactory;
    protected final ByteCounterMonitor bufferMonitor;
    protected final ByteCounterMonitor logDeserializerMonitor;
    private final PhysicalLogWriterSPI logWriterSPI;
    private final XaCommandReaderFactory commandReaderFactory;
    private final XaCommandWriterFactory commandWriterFactory;
    private final LogEntryWriterv1 logEntryWriter = new LogEntryWriterv1();
    private final TranslatingEntryConsumer translatingEntryConsumer;
    private final LogReader<ReadableByteChannel> reader;
    private final LogReader<ReadableByteChannel> slaveLogReader;
    private final LogEntry.Done doneEntry = new LogEntry.Done(-1);
    private final KernelHealth kernelHealth;
    private final ArrayMap<Thread, Integer> txIdentMap = new ArrayMap(5, true, true);
    public static final int MASTER_ID_REPRESENTING_NO_MASTER = -1;

    public XaLogicalLog(File fileName, XaResourceManager xaRm, XaCommandReaderFactory commandReaderFactory, XaCommandWriterFactory commandWriterFactory, XaTransactionFactory xaTf, FileSystemAbstraction fileSystem, Monitors monitors, Logging logging, LogPruneStrategy pruneStrategy, TransactionStateFactory stateFactory, KernelHealth kernelHealth, long rotateAtSize, InjectedTransactionValidator injectedTxValidator, Function<List<LogEntry>, List<LogEntry>> interceptor, Function<List<LogEntry>, List<LogEntry>> transactionTranslator) {
        this.fileName = fileName;
        this.xaRm = xaRm;
        this.commandReaderFactory = commandReaderFactory;
        this.commandWriterFactory = commandWriterFactory;
        this.xaTf = xaTf;
        this.fileSystem = fileSystem;
        this.kernelHealth = kernelHealth;
        this.bufferMonitor = monitors.newMonitor(ByteCounterMonitor.class, XaLogicalLog.class, new String[0]);
        this.logDeserializerMonitor = monitors.newMonitor(ByteCounterMonitor.class, "logdeserializer");
        this.pruneStrategy = pruneStrategy;
        this.stateFactory = stateFactory;
        this.rotateAtSize = rotateAtSize;
        this.autoRotate = rotateAtSize > 0L;
        this.logFiles = new XaLogicalLogFiles(fileName, fileSystem);
        this.sharedBuffer = ByteBuffer.allocateDirect(713);
        this.msgLog = logging.getMessagesLog(this.getClass());
        this.partialTransactionCopier = new PartialTransactionCopier(this.sharedBuffer, commandReaderFactory, commandWriterFactory, this.msgLog, this.positionCache, this, this.logEntryWriter, this.xidIdentMap);
        this.injectedTxValidator = injectedTxValidator;
        this.logWriterSPI = new PhysicalLogWriterSPI();
        this.reader = new LogDeserializer(this.sharedBuffer, commandReaderFactory);
        this.slaveLogReader = new SlaveLogDeserializer(this.sharedBuffer, commandReaderFactory);
        this.logEntryWriter.setCommandWriter(commandWriterFactory.newInstance());
        LogApplier applier = new LogApplier();
        PositionCacheLogHandler.SPI positionCacheSPI = new PositionCacheLogHandler.SPI(){

            @Override
            public long getLogVersion() {
                return XaLogicalLog.this.logVersion;
            }
        };
        this.masterHandler = new LogFilter(interceptor, new MasterLogWriter(new PositionCacheLogHandler(applier, this.positionCache, positionCacheSPI), this.logWriterSPI, injectedTxValidator, this.logEntryWriter));
        this.slaveHandler = new LogFilter(interceptor, new ForgetUnsuccessfulReceivedTransaction(new SlaveLogWriter(new PositionCacheLogHandler(applier, this.positionCache, positionCacheSPI), this.logWriterSPI, this.logEntryWriter)));
        this.translatingEntryConsumer = new TranslatingEntryConsumer(transactionTranslator);
    }

    synchronized void open() throws IOException {
        switch (this.logFiles.determineState()) {
            case LEGACY_WITHOUT_LOG_ROTATION: {
                this.open(this.fileName);
                break;
            }
            case NO_ACTIVE_FILE: {
                this.open(this.logFiles.getLog1FileName());
                this.setActiveLog('1');
                break;
            }
            case CLEAN: {
                File newLog = this.logFiles.getLog1FileName();
                this.renameIfExists(newLog);
                this.renameIfExists(this.logFiles.getLog2FileName());
                this.open(newLog);
                this.setActiveLog('1');
                break;
            }
            case DUAL_LOGS_LOG_1_ACTIVE: {
                this.fixDualLogFiles(this.logFiles.getLog1FileName(), this.logFiles.getLog2FileName());
            }
            case LOG_1_ACTIVE: {
                this.currentLog = (char)49;
                this.open(this.logFiles.getLog1FileName());
                break;
            }
            case DUAL_LOGS_LOG_2_ACTIVE: {
                this.fixDualLogFiles(this.logFiles.getLog2FileName(), this.logFiles.getLog1FileName());
            }
            case LOG_2_ACTIVE: {
                this.currentLog = (char)50;
                this.open(this.logFiles.getLog2FileName());
                break;
            }
            default: {
                throw new IllegalStateException("FATAL: Unrecognized logical log state.");
            }
        }
        this.instantiateCorrectWriteBuffer();
    }

    private void renameIfExists(File fileName) throws IOException {
        if (this.fileSystem.fileExists(fileName)) {
            this.renameLogFileToRightVersion(fileName, this.fileSystem.getFileSize(fileName));
            this.xaTf.getAndSetNewVersion();
        }
    }

    private void instantiateCorrectWriteBuffer() throws IOException {
        this.writeBuffer = this.instantiateCorrectWriteBuffer(this.fileChannel);
    }

    private LogBuffer instantiateCorrectWriteBuffer(StoreChannel channel) throws IOException {
        return new DirectMappedLogBuffer(channel, this.bufferMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(File fileToOpen) throws IOException {
        this.fileChannel = this.fileSystem.open(fileToOpen, "rw");
        if (new XaLogicalLogRecoveryCheck(this.fileChannel).recoveryRequired()) {
            this.nonCleanShutdown = true;
            this.doingRecovery = true;
            try {
                this.doInternalRecovery(fileToOpen);
            }
            finally {
                this.doingRecovery = false;
            }
        } else {
            this.logVersion = this.xaTf.getCurrentVersion();
            this.determineLogVersionFromArchivedFiles();
            long lastTxId = this.xaTf.getLastCommittedTx();
            LogEntryWriterv1.writeLogHeader(this.sharedBuffer, this.logVersion, lastTxId);
            this.previousLogLastCommittedTx = lastTxId;
            this.positionCache.putHeader(this.logVersion, this.previousLogLastCommittedTx);
            this.fileChannel.writeAll(this.sharedBuffer);
            this.scanIsComplete = true;
            this.msgLog.info(this.openedLogicalLogMessage(fileToOpen, lastTxId, true));
        }
    }

    private void determineLogVersionFromArchivedFiles() {
        long version = this.logFiles.determineNextLogVersion(this.logVersion);
        if (version != this.logVersion) {
            this.logVersion = version;
            this.xaTf.setVersion(version);
        }
    }

    private String openedLogicalLogMessage(File fileToOpen, long lastTxId, boolean clean) {
        return "Opened logical log [" + fileToOpen + "] version=" + this.logVersion + ", lastTxId=" + lastTxId + " (" + (clean ? "clean" : "recovered") + ")";
    }

    public boolean scanIsComplete() {
        return this.scanIsComplete;
    }

    private int getNextIdentifier() {
        ++this.nextIdentifier;
        if (this.nextIdentifier < 0) {
            this.nextIdentifier = 1;
        }
        return this.nextIdentifier;
    }

    public synchronized int start(Xid xid, int masterId, int myId, long highestKnownCommittedTx) {
        int xidIdent = this.getNextIdentifier();
        long timeWritten = System.currentTimeMillis();
        LogEntry.Start start = new LogEntry.Start(xid, xidIdent, masterId, myId, -1L, timeWritten, highestKnownCommittedTx);
        this.xidIdentMap.put(xidIdent, start);
        return xidIdent;
    }

    public synchronized void writeStartEntry(int identifier) throws XAException {
        this.kernelHealth.assertHealthy(XAException.class);
        try {
            long position = this.writeBuffer.getFileChannelPosition();
            LogEntry.Start start = this.xidIdentMap.get(identifier);
            start.setStartPosition(position);
            this.logEntryWriter.writeLogEntry(start, this.writeBuffer);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log couldn't write transaction start entry: " + e), e);
        }
    }

    synchronized LogEntry.Start getStartEntry(int identifier) {
        LogEntry.Start start = this.xidIdentMap.get(identifier);
        if (start == null) {
            throw new IllegalArgumentException("Start entry for " + identifier + " not found");
        }
        return start;
    }

    public synchronized void prepare(int identifier) throws XAException {
        this.kernelHealth.assertHealthy(XAException.class);
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        try {
            this.logEntryWriter.writeLogEntry(new LogEntry.Prepare(identifier, System.currentTimeMillis()), this.writeBuffer);
            this.writeBuffer.writeOut();
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark prepare [" + identifier + "] "), e);
        }
    }

    public void forget(int identifier) {
        this.xidIdentMap.remove(identifier);
    }

    public synchronized void done(int identifier) throws XAException {
        assert (this.xidIdentMap.get(identifier) != null);
        try {
            this.logEntryWriter.writeLogEntry(this.doneEntry.reset(identifier), this.writeBuffer);
            this.xidIdentMap.remove(identifier);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark as done [" + identifier + "] "), e);
        }
    }

    synchronized void doneInternal(int identifier) throws IOException {
        if (this.writeBuffer != null) {
            this.logEntryWriter.writeLogEntry(this.doneEntry.reset(identifier), this.writeBuffer);
        } else {
            InMemoryLogBuffer buffer = new InMemoryLogBuffer();
            this.logEntryWriter.writeLogEntry(this.doneEntry.reset(identifier), buffer);
            this.fileChannel.writeAll(buffer.asByteBuffer());
        }
        this.xidIdentMap.remove(identifier);
    }

    public synchronized void commitOnePhase(int identifier, long txId, ForceMode forceMode) throws XAException {
        this.kernelHealth.assertHealthy(XAException.class);
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        assert (txId != -1L);
        try {
            this.positionCache.cacheStartPosition(txId, startEntry, this.logVersion);
            this.logEntryWriter.writeLogEntry(new LogEntry.OnePhaseCommit(identifier, txId, System.currentTimeMillis()), this.writeBuffer);
            forceMode.force(this.writeBuffer);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark 1P-commit [" + identifier + "] "), e);
        }
    }

    public synchronized void commitTwoPhase(int identifier, long txId, ForceMode forceMode) throws XAException {
        this.kernelHealth.assertHealthy(XAException.class);
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        assert (startEntry != null);
        assert (txId != -1L);
        try {
            this.positionCache.cacheStartPosition(txId, startEntry, this.logVersion);
            this.logEntryWriter.writeLogEntry(new LogEntry.TwoPhaseCommit(identifier, txId, System.currentTimeMillis()), this.writeBuffer);
            forceMode.force(this.writeBuffer);
        }
        catch (IOException e) {
            throw Exceptions.withCause(new XAException("Logical log unable to mark 2PC [" + identifier + "] "), e);
        }
    }

    public synchronized void writeCommand(XaCommand command, int identifier) throws IOException {
        this.checkLogRotation();
        assert (this.xidIdentMap.get(identifier) != null);
        this.logEntryWriter.writeLogEntry(new LogEntry.Command(identifier, command), this.writeBuffer);
    }

    private void registerRecoveredTransaction(long txId) {
        if (this.doingRecovery) {
            this.lastRecoveredTx = txId;
        }
    }

    private void logRecoveryMessage(String string) {
        if (this.doingRecovery) {
            this.msgLog.logMessage(string, true);
        }
    }

    private void checkLogRotation() throws IOException {
        long firstStartEntry;
        long currentPos;
        if (this.autoRotate && this.writeBuffer.getFileChannelPosition() >= this.rotateAtSize && (currentPos = this.writeBuffer.getFileChannelPosition()) - (firstStartEntry = this.getFirstStartEntry(currentPos)) < this.rotateAtSize / 2L) {
            this.rotate();
        }
    }

    private void fixDualLogFiles(File activeLog, File oldLog) throws IOException {
        StoreChannel activeLogChannel = this.fileSystem.open(activeLog, "r");
        long[] activeLogHeader = VersionAwareLogEntryReader.readLogHeader(ByteBuffer.allocate(16), activeLogChannel, false);
        activeLogChannel.close();
        StoreChannel oldLogChannel = this.fileSystem.open(oldLog, "r");
        long[] oldLogHeader = VersionAwareLogEntryReader.readLogHeader(ByteBuffer.allocate(16), oldLogChannel, false);
        oldLogChannel.close();
        if (oldLogHeader == null) {
            if (!this.fileSystem.deleteFile(oldLog)) {
                throw new IOException("Unable to delete " + oldLog);
            }
        } else if (activeLogHeader == null || activeLogHeader[0] > oldLogHeader[0]) {
            File newName = this.getFileName(oldLogHeader[0]);
            if (!this.fileSystem.renameFile(oldLog, newName)) {
                throw new IOException("Unable to rename " + oldLog + " to " + newName);
            }
        } else {
            assert (activeLogHeader[0] < oldLogHeader[0]);
            if (!this.fileSystem.deleteFile(oldLog)) {
                throw new IOException("Unable to delete " + oldLog);
            }
        }
    }

    private void renameLogFileToRightVersion(File logFileName, long endPosition) throws IOException {
        if (!this.fileSystem.fileExists(logFileName)) {
            throw new IOException("Logical log[" + logFileName + "] not found");
        }
        StoreChannel channel = this.fileSystem.open(logFileName, "rw");
        long[] header = VersionAwareLogEntryReader.readLogHeader(ByteBuffer.allocate(16), channel, false);
        try {
            FileUtils.truncateFile(channel, endPosition);
        }
        catch (IOException e) {
            this.msgLog.warn("Failed to truncate log at correct size", e);
        }
        channel.close();
        File newName = header == null ? new File(this.getFileName(-1L).getPath() + "_empty_header_log_" + System.currentTimeMillis()) : this.getFileName(header[0]);
        if (!this.fileSystem.renameFile(logFileName, newName)) {
            throw new IOException("Failed to rename log to: " + newName);
        }
    }

    private void releaseCurrentLogFile() throws IOException {
        if (this.writeBuffer != null) {
            this.writeBuffer.force();
        }
        this.fileChannel.close();
        this.fileChannel = null;
    }

    public synchronized void close() throws IOException {
        if (this.fileChannel == null || !this.fileChannel.isOpen()) {
            this.msgLog.debug("Logical log: " + this.fileName + " already closed");
            return;
        }
        long endPosition = this.writeBuffer.getFileChannelPosition();
        if (this.xidIdentMap.size() > 0) {
            this.msgLog.info("Close invoked with " + this.xidIdentMap.size() + " running transaction(s). ");
            this.writeBuffer.force();
            this.fileChannel.close();
            this.msgLog.info("Dirty log: " + this.fileName + "." + this.currentLog + " now closed. Recovery will be started automatically next " + "time it is opened.");
            return;
        }
        this.releaseCurrentLogFile();
        char logWas = this.currentLog;
        if (this.currentLog != 'C') {
            this.setActiveLog('C');
        }
        this.xaTf.flushAll();
        File activeLogFileName = new File(this.fileName.getPath() + "." + logWas);
        this.renameLogFileToRightVersion(activeLogFileName, endPosition);
        this.xaTf.getAndSetNewVersion();
        this.pruneStrategy.prune(this);
        this.msgLog.info("Closed log " + this.fileName);
    }

    static long[] readAndAssertLogHeader(ByteBuffer localBuffer, ReadableByteChannel channel, long expectedVersion) throws IOException {
        long[] header = VersionAwareLogEntryReader.readLogHeader(localBuffer, channel, false);
        if (header[0] != expectedVersion) {
            throw new IOException("Wrong version in log. Expected " + expectedVersion + ", but got " + header[0]);
        }
        return header;
    }

    StringLogger getStringLogger() {
        return this.msgLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInternalRecovery(File logFileName) throws IOException {
        long lastCommittedTx;
        this.msgLog.info("Non clean shutdown detected on log [" + logFileName + "]. Recovery started ...");
        long[] header = this.readLogHeader(this.fileChannel, "Tried to do recovery on log with illegal format version", true);
        if (header == null) {
            this.msgLog.info("Unable to read header information, no records in logical log.");
            this.msgLog.logMessage("No log version found for " + logFileName, true);
            this.fileChannel.close();
            boolean success = this.fileSystem.renameFile(logFileName, new File(logFileName.getPath() + "_unknown_timestamp_" + System.currentTimeMillis() + ".log"));
            assert (success);
            this.fileChannel.close();
            this.fileChannel = this.fileSystem.open(logFileName, "rw");
            return;
        }
        this.logVersion = header[0];
        this.determineLogVersionFromArchivedFiles();
        if (header[0] != this.logVersion) {
            ByteBuffer buff = ByteBuffer.allocate(64);
            LogEntryWriterv1.writeLogHeader(buff, this.logVersion, header[1]);
            this.fileChannel.writeAll(buff, 0L);
        }
        this.previousLogLastCommittedTx = lastCommittedTx = header[1];
        this.positionCache.putHeader(this.logVersion, this.previousLogLastCommittedTx);
        this.msgLog.logMessage("[" + logFileName + "] logVersion=" + this.logVersion + " with committed tx=" + lastCommittedTx, true);
        this.fileChannel = new BufferedFileChannel(this.fileChannel, this.bufferMonitor);
        RecoveryLogDeserializer reader = new RecoveryLogDeserializer(this.sharedBuffer, this.commandReaderFactory);
        EntryCountingLogHandler counter = new EntryCountingLogHandler(new LogApplier());
        RecoveryConsumer consumer = new RecoveryConsumer(counter);
        boolean success = true;
        consumer.startLog();
        Cursor<LogEntry, IOException> cursor = reader.cursor(this.fileChannel);
        try {
            while (cursor.next(consumer)) {
            }
        }
        catch (IOException e) {
            success = false;
        }
        finally {
            consumer.endLog(success);
        }
        long lastEntryPos = this.fileChannel.position();
        this.fileChannel = ((BufferedFileChannel)this.fileChannel).getSource();
        this.fileChannel.position(lastEntryPos);
        this.msgLog.logMessage("[" + logFileName + "] entries found=" + counter.getEntriesFound() + " lastEntryPos=" + lastEntryPos, true);
        this.sharedBuffer.clear();
        while (this.sharedBuffer.hasRemaining()) {
            this.sharedBuffer.put((byte)0);
        }
        this.sharedBuffer.flip();
        long endPosition = this.fileChannel.size();
        do {
            long bytesLeft;
            if ((bytesLeft = this.fileChannel.size() - this.fileChannel.position()) < (long)this.sharedBuffer.capacity()) {
                this.sharedBuffer.limit((int)bytesLeft);
            }
            this.fileChannel.writeAll(this.sharedBuffer);
            this.sharedBuffer.flip();
        } while (this.fileChannel.position() < endPosition);
        this.fileChannel.position(lastEntryPos);
        this.scanIsComplete = true;
        String recoveryCompletedMessage = this.openedLogicalLogMessage(logFileName, this.lastRecoveredTx, false);
        this.msgLog.logMessage(recoveryCompletedMessage);
        this.xaRm.checkXids();
        if (this.xidIdentMap.size() == 0) {
            this.msgLog.logMessage("Recovery on log [" + logFileName + "] completed.");
        } else {
            this.msgLog.logMessage("Recovery on log [" + logFileName + "] completed with " + this.xidIdentMap + " prepared transactions found.");
            for (LogEntry.Start startEntry : this.xidIdentMap.values()) {
                this.msgLog.debug("[" + logFileName + "] 2PC xid[" + startEntry.getXid() + "]");
            }
        }
        this.recoveredTxMap.clear();
    }

    void reset() {
        this.xidIdentMap.clear();
        this.recoveredTxMap.clear();
    }

    void registerTxIdentifier(int identifier) {
        this.txIdentMap.put(Thread.currentThread(), identifier);
    }

    void unregisterTxIdentifier() {
        this.txIdentMap.remove(Thread.currentThread());
    }

    public int getCurrentTxIdentifier() {
        Integer intValue = this.txIdentMap.get(Thread.currentThread());
        if (intValue != null) {
            return intValue;
        }
        return -1;
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        return this.getLogicalLog(version, 0L);
    }

    public ReadableByteChannel getLogicalLog(long version, long position) throws IOException {
        File name = this.getFileName(version);
        if (!this.fileSystem.fileExists(name)) {
            throw new NoSuchLogVersionException(version);
        }
        StoreChannel channel = this.fileSystem.open(name, "r");
        channel.position(position);
        return new BufferedFileChannel(channel, this.bufferMonitor);
    }

    private void extractPreparedTransactionFromLog(int identifier, StoreChannel logChannel, LogBuffer targetBuffer) throws IOException {
        LogEntry.Start startEntry = this.xidIdentMap.get(identifier);
        logChannel.position(startEntry.getStartPosition());
        long startedAt = this.sharedBuffer.position();
        SkipPrepareLogEntryWriter consumer = new SkipPrepareLogEntryWriter(identifier, targetBuffer);
        try (Cursor<LogEntry, IOException> cursor = this.reader.cursor(logChannel);){
            while (cursor.next(consumer)) {
            }
        }
        this.bufferMonitor.bytesRead((long)this.sharedBuffer.position() - startedAt);
        if (!consumer.hasFound()) {
            throw new IOException("Transaction for internal identifier[" + identifier + "] not found in current log");
        }
    }

    public synchronized ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        StoreChannel logChannel = (StoreChannel)this.getLogicalLogOrMyselfPrepared(this.logVersion, 0L);
        InMemoryLogBuffer localBuffer = new InMemoryLogBuffer();
        this.extractPreparedTransactionFromLog(identifier, logChannel, localBuffer);
        logChannel.close();
        return localBuffer;
    }

    public synchronized void getPreparedTransaction(int identifier, LogBuffer targetBuffer) throws IOException {
        StoreChannel logChannel = (StoreChannel)this.getLogicalLogOrMyselfPrepared(this.logVersion, 0L);
        this.extractPreparedTransactionFromLog(identifier, logChannel, targetBuffer);
        logChannel.close();
    }

    public LogExtractor getLogExtractor(long startTxId, long endTxIdHint) throws IOException {
        return new LogExtractor(this.positionCache, this, this.commandReaderFactory, this.commandWriterFactory, this.logEntryWriter, startTxId, endTxIdHint);
    }

    public synchronized Pair<Integer, Long> getMasterForCommittedTransaction(long txId) throws IOException {
        if (txId == 1L) {
            return Pair.of(-1, 0L);
        }
        LogExtractor.TxPosition cache = this.positionCache.getStartPosition(txId);
        if (cache != null) {
            return Pair.of(cache.masterId, cache.checksum);
        }
        try (LogExtractor extractor = this.getLogExtractor(txId, txId);){
            if (extractor.extractNext(NullLogBuffer.INSTANCE) != -1L) {
                Pair<Integer, Long> pair = Pair.of(extractor.getLastStartEntry().getMasterId(), extractor.getLastTxChecksum());
                return pair;
            }
            throw new NoSuchTransactionException(txId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadableByteChannel getLogicalLogOrMyselfCommitted(long version, long position) throws IOException {
        XaLogicalLog xaLogicalLog = this;
        synchronized (xaLogicalLog) {
            if (version == this.logVersion) {
                File currentLogName = this.getCurrentLogFileName();
                StoreChannel channel = this.fileSystem.open(currentLogName, "r");
                channel.position(position);
                return new BufferedFileChannel(channel, this.bufferMonitor);
            }
        }
        if (version < this.logVersion) {
            return this.getLogicalLog(version, position);
        }
        throw new RuntimeException("Version[" + version + "] is higher then current log version[" + this.logVersion + "]");
    }

    private ReadableByteChannel getLogicalLogOrMyselfPrepared(long version, long position) throws IOException {
        if (version < this.logVersion) {
            return this.getLogicalLog(version, position);
        }
        if (version == this.logVersion) {
            File currentLogName = this.getCurrentLogFileName();
            StoreChannel channel = this.fileSystem.open(currentLogName, "r");
            channel = new BufferedFileChannel(channel, this.bufferMonitor);
            this.writeBuffer.writeOut();
            channel.position(position);
            return channel;
        }
        throw new RuntimeException("Version[" + version + "] is higher then current log version[" + this.logVersion + "]");
    }

    private File getCurrentLogFileName() {
        return this.currentLog == '1' ? this.logFiles.getLog1FileName() : this.logFiles.getLog2FileName();
    }

    public long getLogicalLogLength(long version) {
        return this.fileSystem.getFileSize(this.getFileName(version));
    }

    public boolean hasLogicalLog(long version) {
        return this.fileSystem.fileExists(this.getFileName(version));
    }

    public boolean deleteLogicalLog(long version) {
        File file = this.getFileName(version);
        return this.fileSystem.fileExists(file) && this.fileSystem.deleteFile(file);
    }

    public LogBufferFactory createLogWriter(final Function<Config, File> logBasePath) {
        return new LogBufferFactory(){

            @Override
            public LogBuffer createActiveLogFile(Config config, long prevCommittedId) throws IllegalStateException, IOException {
                File activeLogFile = new XaLogicalLogFiles((File)logBasePath.apply(config), XaLogicalLog.this.fileSystem).getLog1FileName();
                StoreChannel channel = XaLogicalLog.this.fileSystem.create(activeLogFile);
                ByteBuffer scratch = ByteBuffer.allocateDirect(128);
                LogEntryWriterv1.writeLogHeader(scratch, 0L, prevCommittedId);
                while (scratch.hasRemaining()) {
                    channel.writeAll(scratch);
                }
                scratch.clear();
                return new DirectLogBuffer(channel, scratch);
            }
        };
    }

    private long[] readLogHeader(ReadableByteChannel source, String message, boolean strict) throws IOException {
        try {
            return VersionAwareLogEntryReader.readLogHeader(this.sharedBuffer, source, strict);
        }
        catch (IllegalLogFormatException e) {
            this.msgLog.logMessage(message, e);
            throw e;
        }
    }

    public synchronized void applyTransactionWithoutTxId(ReadableByteChannel byteChannel, long nextTxId, ForceMode forceMode) throws IOException {
        this.kernelHealth.assertHealthy(IOException.class);
        if (nextTxId != this.xaTf.getLastCommittedTx() + 1L) {
            throw new IllegalStateException("Tried to apply tx " + nextTxId + " but expected transaction " + (this.xaTf.getCurrentVersion() + 1L));
        }
        this.logRecoveryMessage("applyTxWithoutTxId log version: " + this.logVersion + ", committing tx=" + nextTxId + ") @ pos " + this.writeBuffer.getFileChannelPosition());
        this.scanIsComplete = false;
        this.logWriterSPI.bind(forceMode, nextTxId);
        this.translatingEntryConsumer.bind(this.getNextIdentifier(), this.masterHandler);
        boolean success = true;
        this.masterHandler.startLog();
        try (Cursor<LogEntry, IOException> cursor = this.reader.cursor(byteChannel);){
            while (cursor.next(this.translatingEntryConsumer)) {
            }
        }
        catch (IOException e) {
            this.kernelHealth.panic(e);
            success = false;
            throw Exceptions.launderedException(IOException.class, "Failure applying transaction", e);
        }
        finally {
            this.masterHandler.endLog(success);
            this.scanIsComplete = true;
        }
        this.logRecoveryMessage("Applied external tx and generated tx id=" + nextTxId);
        this.checkLogRotation();
    }

    public synchronized void applyTransaction(ReadableByteChannel byteChannel) throws IOException {
        this.kernelHealth.assertHealthy(IOException.class);
        this.scanIsComplete = false;
        this.translatingEntryConsumer.bind(this.getNextIdentifier(), this.slaveHandler);
        boolean success = false;
        this.slaveHandler.startLog();
        try (Cursor<LogEntry, IOException> cursor = this.slaveLogReader.cursor(byteChannel);){
            while (cursor.next(this.translatingEntryConsumer)) {
            }
            success = true;
        }
        catch (Exception e) {
            this.kernelHealth.panic(e);
            throw Exceptions.launderedException(IOException.class, "Failure applying transaction", e);
        }
        finally {
            try {
                this.slaveHandler.endLog(success);
            }
            catch (Exception e) {
                this.kernelHealth.panic(e);
                throw Exceptions.launderedException(IOException.class, "Failure applying transaction", e);
            }
            this.scanIsComplete = true;
        }
        this.checkLogRotation();
    }

    public synchronized long rotate() throws IOException {
        this.xaTf.flushAll();
        File newLogFile = this.logFiles.getLog2FileName();
        File currentLogFile = this.logFiles.getLog1FileName();
        char newActiveLog = '2';
        long currentVersion = this.xaTf.getCurrentVersion();
        File oldCopy = this.getFileName(currentVersion);
        if (this.currentLog == 'C' || this.currentLog == '2') {
            newActiveLog = '1';
            newLogFile = this.logFiles.getLog1FileName();
            currentLogFile = this.logFiles.getLog2FileName();
        } else assert (this.currentLog == '1');
        this.assertFileDoesntExist(newLogFile, "New log file");
        this.assertFileDoesntExist(oldCopy, "Copy log file");
        long endPosition = this.writeBuffer.getFileChannelPosition();
        this.msgLog.logMessage("Rotating [" + currentLogFile + "] @ version=" + currentVersion + " to " + newLogFile + " from position " + endPosition, true);
        this.writeBuffer.force();
        StoreChannel newLog = this.fileSystem.open(newLogFile, "rw");
        long lastTx = this.xaTf.getLastCommittedTx();
        LogEntryWriterv1.writeLogHeader(this.sharedBuffer, currentVersion + 1L, lastTx);
        this.previousLogLastCommittedTx = lastTx;
        if (newLog.write(this.sharedBuffer) != 16) {
            throw new IOException("Unable to write log version to new");
        }
        this.fileChannel.position(0L);
        XaLogicalLog.readAndAssertLogHeader(this.sharedBuffer, this.fileChannel, currentVersion);
        this.fileChannel.position(endPosition);
        if (this.xidIdentMap.size() > 0) {
            long firstEntryPosition = this.getFirstStartEntry(endPosition);
            this.fileChannel.position(firstEntryPosition);
            this.msgLog.logMessage("Rotate log first start entry @ pos=" + firstEntryPosition + " out of " + this.xidIdentMap);
        }
        LogBuffer newLogBuffer = this.instantiateCorrectWriteBuffer(newLog);
        this.partialTransactionCopier.copy(this.fileChannel, newLogBuffer, this.logVersion + 1L);
        newLogBuffer.force();
        newLog.position(newLogBuffer.getFileChannelPosition());
        this.msgLog.logMessage("Rotate: old log scanned, newLog @ pos=" + newLog.position(), true);
        newLog.force(false);
        this.releaseCurrentLogFile();
        this.setActiveLog(newActiveLog);
        this.renameLogFileToRightVersion(currentLogFile, endPosition);
        this.xaTf.getAndSetNewVersion();
        this.logVersion = this.xaTf.getCurrentVersion();
        if (this.xaTf.getCurrentVersion() != currentVersion + 1L) {
            throw new IOException("Version change failed, expected " + (currentVersion + 1L) + ", but was " + this.xaTf.getCurrentVersion());
        }
        this.pruneStrategy.prune(this);
        this.fileChannel = newLog;
        this.positionCache.putHeader(this.logVersion, lastTx);
        this.instantiateCorrectWriteBuffer();
        this.msgLog.logMessage("Log rotated, newLog @ pos=" + this.writeBuffer.getFileChannelPosition() + ", version " + this.logVersion + " and last tx " + this.previousLogLastCommittedTx, true);
        return lastTx;
    }

    private void assertFileDoesntExist(File file, String description) throws IOException {
        if (this.fileSystem.fileExists(file)) {
            throw new IOException(description + ": " + file + " already exist");
        }
    }

    private long getFirstStartEntry(long endPosition) {
        long firstEntryPosition = endPosition;
        for (LogEntry.Start entry : this.xidIdentMap.values()) {
            if (entry.getStartPosition() <= 0L || entry.getStartPosition() >= firstEntryPosition) continue;
            firstEntryPosition = entry.getStartPosition();
        }
        return firstEntryPosition;
    }

    private void setActiveLog(char c) throws IOException {
        if (c != 'C' && c != '1' && c != '2') {
            throw new IllegalArgumentException("Log must be either clean, 1 or 2");
        }
        if (c == this.currentLog) {
            throw new IllegalStateException("Log should not be equal to current " + this.currentLog);
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[4]);
        bb.asCharBuffer().put(c).flip();
        StoreChannel fc = this.fileSystem.open(new File(this.fileName.getPath() + ".active"), "rw");
        int wrote = fc.write(bb);
        if (wrote != 4) {
            throw new IllegalStateException("Expected to write 4 -> " + wrote);
        }
        fc.force(false);
        fc.close();
        this.currentLog = c;
    }

    @Deprecated
    public void setAutoRotateLogs(boolean autoRotate) {
        this.autoRotate = autoRotate;
    }

    @Deprecated
    public boolean isLogsAutoRotated() {
        return this.autoRotate;
    }

    @Deprecated
    public void setLogicalLogTargetSize(long size) {
        this.rotateAtSize = size;
    }

    @Deprecated
    public long getLogicalLogTargetSize() {
        return this.rotateAtSize;
    }

    @Override
    public File getFileName(long version) {
        return XaLogicalLog.getHistoryFileName(this.fileName, version);
    }

    public File getBaseFileName() {
        return this.fileName;
    }

    public Pattern getHistoryFileNamePattern() {
        return XaLogicalLog.getHistoryFileNamePattern(this.fileName.getName());
    }

    public static Pattern getHistoryFileNamePattern(String baseFileName) {
        return Pattern.compile(baseFileName + "\\.v\\d+");
    }

    public static File getHistoryFileName(File baseFile, long version) {
        return new File(baseFile.getPath() + ".v" + version);
    }

    public static long getHistoryLogVersion(File historyLogFile) {
        String toFind;
        String name = historyLogFile.getName();
        int index = name.lastIndexOf(toFind = ".v");
        if (index == -1) {
            throw new RuntimeException("Invalid log file '" + historyLogFile + "'");
        }
        return Integer.parseInt(name.substring(index + toFind.length()));
    }

    public static long getHighestHistoryLogVersion(FileSystemAbstraction fileSystem, File storeDir, String baseFileName) {
        Pattern logFilePattern = XaLogicalLog.getHistoryFileNamePattern(baseFileName);
        long highest = -1L;
        for (File file : fileSystem.listFiles(storeDir)) {
            if (!logFilePattern.matcher(file.getName()).matches()) continue;
            highest = Math.max(highest, XaLogicalLog.getHistoryLogVersion(file));
        }
        return highest;
    }

    public boolean wasNonClean() {
        return this.nonCleanShutdown;
    }

    @Override
    public long getHighestLogVersion() {
        return this.logVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getFirstCommittedTxId(long version) {
        if (version == 0L) {
            return 1L;
        }
        Long header = this.positionCache.getHeader(version - 1L);
        if (header != null) {
            return header + 1L;
        }
        XaLogicalLog xaLogicalLog = this;
        synchronized (xaLogicalLog) {
            if (version > this.logVersion) {
                throw new IllegalArgumentException("Too high version " + version + ", active is " + this.logVersion);
            }
            if (version == this.logVersion) {
                throw new IllegalArgumentException("Last committed tx for the active log isn't determined yet");
            }
            if (version == this.logVersion - 1L) {
                return this.previousLogLastCommittedTx;
            }
            File file = this.getFileName(version);
            if (this.fileSystem.fileExists(file)) {
                try {
                    long[] headerLongs = VersionAwareLogEntryReader.readLogHeader(this.fileSystem, file);
                    return headerLongs[1] + 1L;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    @Override
    public long getLastCommittedTxId() {
        return this.xaTf.getLastCommittedTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getFirstStartRecordTimestamp(long version) throws IOException {
        try (ReadableByteChannel log = null;){
            ByteBuffer buffer = LogExtractor.newLogReaderBuffer();
            log = this.getLogicalLog(version);
            VersionAwareLogEntryReader.readLogHeader(buffer, log, true);
            LogDeserializer deserializer = new LogDeserializer(buffer, this.commandReaderFactory);
            TimeWrittenConsumer consumer = new TimeWrittenConsumer();
            try (Cursor<LogEntry, IOException> cursor = deserializer.cursor(log);){
                while (cursor.next(consumer)) {
                }
            }
            Long l = consumer.getTimeWritten();
            return l;
        }
    }

    private class RecoveryConsumer
    implements Consumer<LogEntry, IOException> {
        private final EntryCountingLogHandler counter;

        private RecoveryConsumer(EntryCountingLogHandler counter) {
            this.counter = counter;
        }

        @Override
        public boolean accept(LogEntry entry) throws IOException {
            switch (entry.getType()) {
                case 1: {
                    this.counter.startEntry((LogEntry.Start)entry);
                    break;
                }
                case 3: {
                    this.counter.commandEntry((LogEntry.Command)entry);
                    break;
                }
                case 2: {
                    this.counter.prepareEntry((LogEntry.Prepare)entry);
                    break;
                }
                case 5: {
                    this.counter.onePhaseCommitEntry((LogEntry.OnePhaseCommit)entry);
                    break;
                }
                case 6: {
                    this.counter.twoPhaseCommitEntry((LogEntry.TwoPhaseCommit)entry);
                    break;
                }
                case 4: {
                    this.counter.doneEntry((LogEntry.Done)entry);
                }
            }
            return true;
        }

        public void startLog() {
            this.counter.startLog();
        }

        public void endLog(boolean success) throws IOException {
            this.counter.endLog(success);
        }
    }

    private class SkipPrepareLogEntryWriter
    implements Consumer<LogEntry, IOException> {
        private final int identifier;
        private final LogBuffer targetBuffer;
        private boolean found = false;

        private SkipPrepareLogEntryWriter(int identifier, LogBuffer targetBuffer) {
            this.identifier = identifier;
            this.targetBuffer = targetBuffer;
        }

        @Override
        public boolean accept(LogEntry logEntry) throws IOException {
            if (logEntry.getIdentifier() != this.identifier) {
                return true;
            }
            if (logEntry instanceof LogEntry.Prepare) {
                return false;
            }
            if (!(logEntry instanceof LogEntry.Start) && !(logEntry instanceof LogEntry.Command)) {
                throw new RuntimeException("Expected start or command entry but found: " + logEntry);
            }
            XaLogicalLog.this.logEntryWriter.writeLogEntry(logEntry, this.targetBuffer);
            this.found = true;
            return true;
        }

        public boolean hasFound() {
            return this.found;
        }
    }

    private class TimeWrittenConsumer
    implements Consumer<LogEntry, IOException> {
        private long timeWritten = -1L;

        private TimeWrittenConsumer() {
        }

        @Override
        public boolean accept(LogEntry logEntry) throws IOException {
            if (logEntry instanceof LogEntry.Start) {
                this.timeWritten = ((LogEntry.Start)logEntry).getTimeWritten();
                return false;
            }
            return true;
        }

        public long getTimeWritten() {
            return this.timeWritten;
        }
    }

    private class PhysicalLogWriterSPI
    implements LogWriter.SPI {
        private ForceMode forceMode;
        private long nextTxId;

        private PhysicalLogWriterSPI() {
        }

        @Override
        public LogBuffer getWriteBuffer() {
            return XaLogicalLog.this.writeBuffer;
        }

        @Override
        public void commitTransactionWithoutTxId(LogEntry.Start startEntry) throws IOException {
            if (startEntry == null) {
                throw new IOException("Unable to find start entry");
            }
            try {
                XaLogicalLog.this.injectedTxValidator.assertInjectionAllowed(startEntry.getLastCommittedTxWhenTransactionStarted());
            }
            catch (XAException e) {
                throw new IOException(e);
            }
            LogEntry.OnePhaseCommit commit = new LogEntry.OnePhaseCommit(startEntry.getIdentifier(), this.nextTxId, System.currentTimeMillis());
            XaLogicalLog.this.logEntryWriter.writeLogEntry(commit, XaLogicalLog.this.writeBuffer);
            this.forceMode.force(XaLogicalLog.this.writeBuffer);
            Xid xid = startEntry.getXid();
            try {
                XaTransaction xaTx = XaLogicalLog.this.xaRm.getXaTransaction(xid);
                xaTx.setCommitTxId(this.nextTxId);
                XaLogicalLog.this.positionCache.cacheStartPosition(this.nextTxId, startEntry, XaLogicalLog.this.logVersion);
                XaLogicalLog.this.xaRm.commit(xid, true);
                LogEntry.Done doneEntry = new LogEntry.Done(startEntry.getIdentifier());
                XaLogicalLog.this.logEntryWriter.writeLogEntry(doneEntry, XaLogicalLog.this.writeBuffer);
                XaLogicalLog.this.xidIdentMap.remove(startEntry.getIdentifier());
                XaLogicalLog.this.recoveredTxMap.remove(startEntry.getIdentifier());
            }
            catch (XAException e) {
                throw new IOException(e);
            }
        }

        public void bind(ForceMode forceMode, long nextTxId) {
            this.forceMode = forceMode;
            this.nextTxId = nextTxId;
        }
    }

    public class LogApplier
    implements LogHandler {
        @Override
        public void startLog() {
        }

        @Override
        public void startEntry(LogEntry.Start startEntry) throws IOException {
            int identifier = startEntry.getIdentifier();
            if (identifier >= XaLogicalLog.this.nextIdentifier) {
                XaLogicalLog.this.nextIdentifier = identifier + 1;
            }
            Xid xid = startEntry.getXid();
            XaLogicalLog.this.xidIdentMap.put(identifier, startEntry);
            XaTransaction xaTx = XaLogicalLog.this.xaTf.create(startEntry.getLastCommittedTxWhenTransactionStarted(), XaLogicalLog.this.stateFactory.create(null));
            xaTx.setIdentifier(identifier);
            xaTx.setRecovered();
            XaLogicalLog.this.recoveredTxMap.put(identifier, xaTx);
            XaLogicalLog.this.xaRm.injectStart(xid, xaTx);
        }

        @Override
        public void prepareEntry(LogEntry.Prepare prepareEntry) throws IOException {
            int identifier = prepareEntry.getIdentifier();
            LogEntry.Start entry = (LogEntry.Start)XaLogicalLog.this.xidIdentMap.get(identifier);
            if (entry == null) {
                throw new IOException("Unknown xid for identifier " + identifier);
            }
            Xid xid = entry.getXid();
            if (XaLogicalLog.this.xaRm.injectPrepare(xid)) {
                XaLogicalLog.this.xidIdentMap.remove(identifier);
                XaLogicalLog.this.recoveredTxMap.remove(identifier);
            }
        }

        @Override
        public void onePhaseCommitEntry(LogEntry.OnePhaseCommit onePhaseCommitEntry) throws IOException {
            int identifier = onePhaseCommitEntry.getIdentifier();
            long txId = onePhaseCommitEntry.getTxId();
            LogEntry.Start startEntry = (LogEntry.Start)XaLogicalLog.this.xidIdentMap.get(identifier);
            if (startEntry == null) {
                throw new IOException("Unknown xid for identifier " + identifier);
            }
            Xid xid = startEntry.getXid();
            try {
                XaTransaction xaTx = XaLogicalLog.this.xaRm.getXaTransaction(xid);
                xaTx.setCommitTxId(txId);
                XaLogicalLog.this.positionCache.cacheStartPosition(txId, startEntry, XaLogicalLog.this.logVersion);
                XaLogicalLog.this.xaRm.injectOnePhaseCommit(xid);
                XaLogicalLog.this.registerRecoveredTransaction(txId);
            }
            catch (XAException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void twoPhaseCommitEntry(LogEntry.TwoPhaseCommit twoPhaseCommitEntry) throws IOException {
            int identifier = twoPhaseCommitEntry.getIdentifier();
            long txId = twoPhaseCommitEntry.getTxId();
            LogEntry.Start startEntry = (LogEntry.Start)XaLogicalLog.this.xidIdentMap.get(identifier);
            if (startEntry == null) {
                throw new IOException("Unknown xid for identifier " + identifier);
            }
            Xid xid = startEntry.getXid();
            if (xid == null) {
                throw new IOException("Xid null for identifier " + identifier);
            }
            try {
                XaTransaction xaTx = XaLogicalLog.this.xaRm.getXaTransaction(xid);
                xaTx.setCommitTxId(txId);
                XaLogicalLog.this.positionCache.cacheStartPosition(txId, startEntry, XaLogicalLog.this.logVersion);
                XaLogicalLog.this.xaRm.injectTwoPhaseCommit(xid);
                XaLogicalLog.this.registerRecoveredTransaction(txId);
            }
            catch (XAException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void doneEntry(LogEntry.Done doneEntry) throws IOException {
            int identifier = doneEntry.getIdentifier();
            LogEntry.Start entry = (LogEntry.Start)XaLogicalLog.this.xidIdentMap.get(identifier);
            if (entry == null) {
                throw new IOException("Unknown xid for identifier " + identifier);
            }
            Xid xid = entry.getXid();
            XaLogicalLog.this.xaRm.pruneXid(xid);
            XaLogicalLog.this.xidIdentMap.remove(identifier);
            XaLogicalLog.this.recoveredTxMap.remove(identifier);
        }

        @Override
        public void commandEntry(LogEntry.Command commandEntry) throws IOException {
            int identifier = commandEntry.getIdentifier();
            XaCommand command = commandEntry.getXaCommand();
            if (command == null) {
                throw new IOException("Null command for identifier " + identifier);
            }
            command.setRecovered();
            XaTransaction xaTx = (XaTransaction)XaLogicalLog.this.recoveredTxMap.get(identifier);
            xaTx.injectCommand(command);
        }

        @Override
        public void endLog(boolean success) throws IOException {
        }
    }

    public class ForgetUnsuccessfulReceivedTransaction
    extends LogHandler.Filter {
        private LogEntry.Start startEntry;

        public ForgetUnsuccessfulReceivedTransaction(LogHandler delegate) {
            super(delegate);
        }

        public void setDelegate(LogHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void startEntry(LogEntry.Start startEntry) throws IOException {
            this.startEntry = startEntry;
            super.startEntry(startEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endLog(boolean success) throws IOException {
            try {
                super.endLog(success);
            }
            finally {
                if (!success && this.startEntry != null && XaLogicalLog.this.xidIdentMap.get(this.startEntry.getIdentifier()) != null) {
                    try {
                        XaLogicalLog.this.xaRm.forget(this.startEntry.getXid());
                    }
                    catch (XAException e) {
                        throw new IOException(e);
                    }
                    finally {
                        XaLogicalLog.this.xidIdentMap.remove(this.startEntry.getIdentifier());
                    }
                }
            }
        }
    }
}

